/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentGroupStrategy {
    private TaskComment convertToTaskComment(TaskDataModel taskDataModel, TaskAttribute commentAttribute) {
        TaskComment taskComment = new TaskComment(taskDataModel.getTaskRepository(), taskDataModel.getTask(), commentAttribute);
        taskDataModel.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)taskComment, commentAttribute);
        return taskComment;
    }

    public List<CommentGroup> groupCommentsFromModel(TaskDataModel taskDataModel) {
        int recentFromIndex;
        ArrayList<TaskAttribute> recent;
        List taskAttributes = taskDataModel.getTaskData().getAttributeMapper().getAttributesByType(taskDataModel.getTaskData(), "comment");
        ArrayList<CommentGroup> commentGroups = new ArrayList<CommentGroup>();
        ArrayList<TaskAttribute> comments = new ArrayList<TaskAttribute>();
        int currentFromIndex = -1;
        String currentPersonId = taskDataModel.getTaskRepository().getUserName();
        ArrayList<TaskAttribute> current = new ArrayList<TaskAttribute>();
        int i = 0;
        while (i < taskAttributes.size()) {
            IRepositoryPerson person;
            TaskAttribute commentAttribute = (TaskAttribute)taskAttributes.get(i);
            TaskComment taskComment = this.convertToTaskComment(taskDataModel, commentAttribute);
            comments.add(commentAttribute);
            if (taskDataModel.hasIncomingChanges(taskComment.getTaskAttribute())) {
                current.add(commentAttribute);
            }
            if ((person = taskComment.getAuthor()) != null && person.getPersonId().equals(currentPersonId)) {
                currentFromIndex = i;
            }
            ++i;
        }
        if (current.size() > 0) {
            comments.removeAll(current);
        }
        if (currentFromIndex != -1 && currentFromIndex < comments.size()) {
            current.addAll(0, new ArrayList(comments.subList(currentFromIndex, comments.size())));
            if (current.size() > 0) {
                comments.removeAll(current);
            }
        }
        if ((recent = new ArrayList<TaskAttribute>(comments.subList(recentFromIndex = comments.size() - 20 < 0 ? 0 : comments.size() - 20, comments.size()))).size() > 0) {
            comments.removeAll(recent);
        }
        if (comments.size() > 0) {
            commentGroups.add(new CommentGroup("Older", comments));
        }
        if (recent.size() > 0) {
            commentGroups.add(new CommentGroup("Recent", recent));
        }
        if (current.size() > 0) {
            commentGroups.add(new CommentGroup("Current", current));
        }
        return commentGroups;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CommentGroup {
        private final List<TaskAttribute> commentAttributes;
        private final String groupName;

        CommentGroup(String groupName, List<TaskAttribute> commentAttributes) {
            this.groupName = groupName;
            this.commentAttributes = commentAttributes;
        }

        public List<TaskAttribute> getCommentAttributes() {
            return this.commentAttributes;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }
}

