/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.CodeBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ExtendedPreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ExtendedQuoteBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.QuoteBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.TableOfContentsBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.TextBoxBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.ImagePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.SimpleWrappedPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.token.AnchorReplacementToken;
import org.eclipse.mylyn.internal.wikitext.confluence.core.token.HyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternEntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLineBreakReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLiteralReplacementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceLanguage
extends MarkupLanguage {
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Block> paragraphBreakingBlocks = new ArrayList<Block>();
    private static MarkupLanguage.PatternBasedSyntax tokenSyntax = new MarkupLanguage.PatternBasedSyntax();
    private static MarkupLanguage.PatternBasedSyntax phraseModifierSyntax = new MarkupLanguage.PatternBasedSyntax();

    static {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.STRONG));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("??", DocumentBuilder.SpanType.CITATION));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("-", DocumentBuilder.SpanType.DELETED));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("+", DocumentBuilder.SpanType.UNDERLINED));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleWrappedPhraseModifier("{{", "}}", DocumentBuilder.SpanType.MONOSPACE));
        phraseModifierSyntax.add((PatternBasedElement)new ImagePhraseModifier());
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new HyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(---)(?=\\s\\w))", "#8212"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(--)(?=\\s\\w))", "#8211"));
        tokenSyntax.add((PatternBasedElement)new PatternLiteralReplacementToken("(?:(?<=\\w\\s)(----)(?=\\s\\w))", "<hr/>"));
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("(\\\\\\\\)"));
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new AnchorReplacementToken());
    }

    protected MarkupLanguage.PatternBasedSyntax getPhraseModifierSyntax() {
        return phraseModifierSyntax;
    }

    protected MarkupLanguage.PatternBasedSyntax getReplacementTokenSyntax() {
        return tokenSyntax;
    }

    public ConfluenceLanguage() {
        this.blocks.add(new HeadingBlock());
        ListBlock listBlock = new ListBlock();
        this.blocks.add(listBlock);
        this.paragraphBreakingBlocks.add(listBlock);
        this.blocks.add(new QuoteBlock());
        TableBlock tableBlock = new TableBlock();
        this.blocks.add(tableBlock);
        this.paragraphBreakingBlocks.add(tableBlock);
        this.blocks.add(new ExtendedQuoteBlock());
        this.blocks.add(new ExtendedPreformattedBlock());
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.PANEL, "panel"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.NOTE, "note"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.INFORMATION, "info"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.WARNING, "warning"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.TIP, "tip"));
        this.blocks.add(new CodeBlock());
        this.blocks.add(new TableOfContentsBlock());
        this.blocks.add(new ParagraphBlock());
        this.setName("Confluence");
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Block> getParagraphBreakingBlocks() {
        return this.paragraphBreakingBlocks;
    }
}

