/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.outline;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineItem {
    private final OutlineItem parent;
    private final int level;
    private final List<OutlineItem> children = new ArrayList<OutlineItem>();
    private final int offset;
    private final int length;
    private final String id;
    private String label;
    private String kind;
    private int childOffset;
    private String tooltip;

    public OutlineItem(OutlineItem parent, int level, String id, int offset, int length, String label) {
        this.parent = parent;
        int n = this.level = parent == null ? 0 : level;
        if (parent != null && level < parent.getLevel()) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.offset = offset;
        this.length = length;
        this.label = label;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public int getLength() {
        return this.length;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.level;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public OutlineItem getParent() {
        return this.parent;
    }

    public List<OutlineItem> getChildren() {
        return this.children;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return this.calculatePositionKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutlineItem other = (OutlineItem)obj;
        return other.calculatePositionKey().equals(this.calculatePositionKey());
    }

    public void clear() {
        this.children.clear();
    }

    private String calculatePositionKey() {
        if (this.parent == null) {
            return "";
        }
        return String.valueOf(this.getParent().calculatePositionKey()) + "/" + this.kind + this.childOffset;
    }

    private void addChild(OutlineItem outlineItem) {
        outlineItem.childOffset = this.children.size();
        this.children.add(outlineItem);
    }

    public OutlineItem findNearestMatchingOffset(int offset) {
        NearestItemVisitor visitor = new NearestItemVisitor(offset);
        this.accept(visitor);
        return visitor.nearest;
    }

    public int distance(int offset) {
        int startDistance = this.offset - offset;
        return startDistance;
    }

    public void accept(Visitor visitor) {
        if (visitor.visit(this)) {
            for (OutlineItem item : this.getChildren()) {
                item.accept(visitor);
            }
        }
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    private static class NearestItemVisitor
    implements Visitor {
        private OutlineItem nearest = null;
        private final int offset;

        public NearestItemVisitor(int offset) {
            this.offset = offset;
        }

        public boolean visit(OutlineItem item) {
            if (item.getOffset() == -1) {
                return true;
            }
            if (this.nearest == null) {
                this.nearest = item;
                return true;
            }
            int itemDistance = item.distance(this.offset);
            if (itemDistance > 0) {
                return true;
            }
            int nearestDistance = this.nearest.distance(this.offset);
            nearestDistance = Math.abs(nearestDistance);
            if ((itemDistance = Math.abs(itemDistance)) < nearestDistance) {
                this.nearest = item;
            } else if (itemDistance > nearestDistance) {
                return false;
            }
            return true;
        }
    }

    public static interface Visitor {
        public boolean visit(OutlineItem var1);
    }
}

