/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.io.InputStream;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class MarkupDocumentProvider
extends FileDocumentProvider {
    private MarkupLanguage markupLanguage;

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
            partitioner.setMarkupLanguage(this.markupLanguage == null ? null : this.markupLanguage.clone());
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        super.setDocumentContent(document, contentStream, encoding);
        MarkupDocumentProvider.cleanUpEolMarkers(document);
    }

    public static void cleanUpEolMarkers(IDocument document) {
        String platformEolMarker = Text.DELIMITER;
        document.set(Pattern.compile("(\r\n|\n|\r)").matcher(document.get()).replaceAll(platformEolMarker));
    }
}

