/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.mylyn.wikitext.ui.WikiTextUiPlugin;

public class FilePropertyTester
extends PropertyTester {
    private static final String CONTENT_TYPE_CLASSIFICATION = "contentTypeClassification";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IFile && property.equals(CONTENT_TYPE_CLASSIFICATION)) {
            return this.testContentType((IFile)receiver, this.toString(expectedValue));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testContentType(IFile file, String expectedValue) {
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) return false;
            IContentType contentType = contentDescription.getContentType();
            while (true) {
                if (contentType == null) {
                    return false;
                }
                if (expectedValue.equals(contentType.getId())) {
                    return true;
                }
                contentType = contentType.getBaseType();
            }
        }
        catch (CoreException e) {
            WikiTextUiPlugin.getDefault().log(e);
        }
        return false;
    }

    protected String toString(Object expectedValue) {
        return expectedValue == null ? "" : expectedValue.toString();
    }
}

