/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.Templates;
import org.eclipse.mylyn.internal.wikitext.ui.editor.help.CheatSheetContent;
import org.eclipse.mylyn.internal.wikitext.ui.editor.help.HelpContent;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.wikitext.core.WikiTextPlugin;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTextUiPlugin
extends AbstractUIPlugin {
    private static final String EXTENSION_POINT_CHEAT_SHEET = "cheatSheet";
    private static final String EXTENSION_POINT_CONTENT_ASSIST = "contentAssist";
    private static final String EXTENSION_POINT_TEMPLATES = "templates";
    private static final String EXTENSION_POINT_TEMPLATE = "template";
    private static WikiTextUiPlugin plugin;
    private SortedMap<String, HelpContent> cheatSheets;
    private Map<String, Templates> templates;

    public WikiTextUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static WikiTextUiPlugin getDefault() {
        return plugin;
    }

    public void log(Throwable ce) {
        if (ce instanceof CoreException) {
            this.getLog().log(((CoreException)ce).getStatus());
        } else {
            this.log(4, ce.getMessage(), ce);
        }
    }

    public void log(int severity, String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        ILog log = this.getLog();
        IStatus status = null;
        if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
        }
        if (status == null) {
            status = new Status(severity, this.getPluginId(), severity, message, exception);
        }
        log.log(status);
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public IStatus createStatus(int statusCode, Throwable exception) {
        return this.createStatus(null, statusCode, exception);
    }

    public IStatus createStatus(String message, int statusCode, Throwable exception) {
        if (message == null && exception != null) {
            message = String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage();
        }
        Status status = new Status(statusCode, this.getPluginId(), statusCode, message, exception);
        return status;
    }

    public Preferences getPreferences() {
        Preferences prefs = new Preferences();
        prefs.load(this.getPreferenceStore());
        return prefs;
    }

    public SortedMap<String, HelpContent> getCheatSheets() {
        if (this.cheatSheets == null) {
            TreeMap<String, HelpContent> cheatSheets = new TreeMap<String, HelpContent>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), EXTENSION_POINT_CHEAT_SHEET);
            if (extensionPoint != null) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String declaringPluginId = element.getDeclaringExtension().getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)declaringPluginId);
                    String markupLanguage = element.getAttribute("markupLanguage");
                    String contentLanguage = element.getAttribute("contentLanguage");
                    String resource = element.getAttribute("resource");
                    try {
                        if (markupLanguage == null) {
                            throw new Exception("Must specify markupLanguage");
                        }
                        if (!WikiTextPlugin.getDefault().getMarkupLanguageNames().contains(markupLanguage)) {
                            throw new Exception(String.format("'%s' is not a valid markupLanguage", markupLanguage));
                        }
                        if (resource == null || resource.length() == 0) {
                            throw new Exception("Must specify resource");
                        }
                        CheatSheetContent cheatSheet = new CheatSheetContent(bundle, resource, contentLanguage, markupLanguage);
                        HelpContent previous = cheatSheets.put(cheatSheet.getMarkupLanguageName(), cheatSheet);
                        if (previous != null) {
                            cheatSheets.put(previous.getMarkupLanguageName(), previous);
                            throw new Exception(String.format("content for markupLanguage '%s' is already declared by plugin '%s'", previous.getMarkupLanguageName(), previous.getProvider().getSymbolicName()));
                        }
                    }
                    catch (Exception e) {
                        this.log(4, String.format("Plugin '%s' extension '%s' invalid: %s", declaringPluginId, EXTENSION_POINT_CHEAT_SHEET, e.getMessage()), e);
                    }
                    ++n2;
                }
            }
            this.cheatSheets = Collections.unmodifiableSortedMap(cheatSheets);
        }
        return this.cheatSheets;
    }

    public Map<String, Templates> getTemplates() {
        if (this.templates == null) {
            HashMap<String, Templates> templates = new HashMap<String, Templates>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPluginId(), EXTENSION_POINT_CONTENT_ASSIST);
            if (extensionPoint != null) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String declaringPluginId = element.getDeclaringExtension().getContributor().getName();
                    if (EXTENSION_POINT_TEMPLATES.equals(element.getName())) {
                        try {
                            String markupLanguage = element.getAttribute("markupLanguage");
                            if (markupLanguage == null) {
                                throw new Exception("Must specify markupLanguage");
                            }
                            if (!WikiTextPlugin.getDefault().getMarkupLanguageNames().contains(markupLanguage)) {
                                throw new Exception(String.format("'%s' is not a valid markupLanguage", markupLanguage));
                            }
                            Templates dialectTemplates = new Templates();
                            dialectTemplates.setMarkupLanguageName(markupLanguage);
                            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                            int n3 = iConfigurationElementArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IConfigurationElement templatesChild = iConfigurationElementArray2[n4];
                                if (EXTENSION_POINT_TEMPLATE.equals(templatesChild.getName())) {
                                    try {
                                        String name = templatesChild.getAttribute("name");
                                        String description = templatesChild.getAttribute("description");
                                        String content = templatesChild.getAttribute("content");
                                        String autoInsert = templatesChild.getAttribute("autoInsert");
                                        String block = templatesChild.getAttribute("block");
                                        if (name == null || name.length() == 0) {
                                            throw new Exception(String.format("Must specify %s/name", EXTENSION_POINT_TEMPLATE));
                                        }
                                        if (description == null || description.length() == 0) {
                                            throw new Exception(String.format("Must specify %s/description", EXTENSION_POINT_TEMPLATE));
                                        }
                                        if (content == null || content.length() == 0) {
                                            throw new Exception(String.format("Must specify %s/content", EXTENSION_POINT_TEMPLATE));
                                        }
                                        if ((content = content.replace("\\r\\n", Text.DELIMITER).replace("\\r", Text.DELIMITER).replace("\\n", Text.DELIMITER).replace("\\\\", "\\")).endsWith("$")) {
                                            content = content.substring(0, content.length() - 1);
                                        }
                                        dialectTemplates.addTemplate(new Template(name, description, "org.eclipse.mylyn.wikitext.ui.editor", content, autoInsert == null || !"false".equalsIgnoreCase(autoInsert)), block != null && "true".equalsIgnoreCase(block));
                                    }
                                    catch (Exception e) {
                                        this.log(4, String.format("Plugin '%s' extension '%s' invalid: %s", declaringPluginId, EXTENSION_POINT_CONTENT_ASSIST, e.getMessage()), e);
                                    }
                                } else {
                                    this.log(4, String.format("Plugin '%s' extension '%s' unexpected element: %s", declaringPluginId, EXTENSION_POINT_CONTENT_ASSIST, templatesChild.getName()), null);
                                }
                                ++n4;
                            }
                            Templates previous = templates.put(dialectTemplates.getMarkupLanguageName(), dialectTemplates);
                            if (previous != null) {
                                dialectTemplates.addAll(previous);
                            }
                        }
                        catch (Exception e) {
                            this.log(4, String.format("Plugin '%s' extension '%s' invalid: %s", declaringPluginId, EXTENSION_POINT_TEMPLATES, e.getMessage()), e);
                        }
                    } else {
                        this.log(4, String.format("Plugin '%s' extension '%s' unexpected element: %s", declaringPluginId, EXTENSION_POINT_CONTENT_ASSIST, element.getName()), null);
                    }
                    ++n2;
                }
            }
            Set languageNames = WikiTextPlugin.getDefault().getMarkupLanguageNames();
            for (String languageName : languageNames) {
                Templates languageTemplates = (Templates)templates.get(languageName);
                if (languageTemplates != null) continue;
                languageTemplates = new Templates();
                templates.put(languageName, languageTemplates);
            }
            for (String languageName : languageNames) {
                MarkupLanguage markupLanguage = WikiTextPlugin.getDefault().getMarkupLanguage(languageName);
                if (markupLanguage == null || markupLanguage.getExtendsLanguage() == null) continue;
                Templates languageTemplates = (Templates)templates.get(languageName);
                Templates parentLanguageTemplates = (Templates)templates.get(markupLanguage.getExtendsLanguage());
                languageTemplates.setParent(parentLanguageTemplates);
            }
            this.templates = Collections.unmodifiableMap(templates);
        }
        return this.templates;
    }
}

