/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.viewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.AnnotationHyperlinkDetector;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.TextHover;
import org.eclipse.mylyn.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.HyperlinkDetectorRegistry;

public class HtmlViewerConfiguration
extends TextSourceViewerConfiguration {
    private final HtmlViewer viewer;
    private TextPresentation textPresentation;

    public HtmlViewerConfiguration(HtmlViewer viewer) {
        super(HtmlViewerConfiguration.getDefaultPreferenceStore());
        this.viewer = viewer;
    }

    private static IPreferenceStore getDefaultPreferenceStore() {
        return WikiTextUiPlugin.getDefault() == null ? null : EditorsUI.getPreferenceStore();
    }

    public HtmlViewerConfiguration(HtmlViewer viewer, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.viewer = viewer;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        MarkupViewerDamagerRepairer dr = this.createMarkupViewerDamagerRepairer();
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    private MarkupViewerDamagerRepairer createMarkupViewerDamagerRepairer() {
        return new MarkupViewerDamagerRepairer();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return annotation.getType().equals("org.eclipse.mylyn.wikitext.ui.annotation.title") || HtmlViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new TextHover(sourceViewer);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || this.fPreferenceStore == null) {
            return new IHyperlinkDetector[]{this.createAnnotationHyperlinkDetector()};
        }
        HyperlinkDetectorRegistry registry = EditorsUI.getHyperlinkDetectorRegistry();
        HyperlinkDetectorDescriptor[] descriptors = registry.getHyperlinkDetectorDescriptors();
        Map targets = this.getHyperlinkDetectorTargets(sourceViewer);
        ArrayList<Object> detectors = new ArrayList<Object>(8);
        detectors.add(this.createAnnotationHyperlinkDetector());
        for (Map.Entry target : targets.entrySet()) {
            String targetId = (String)target.getKey();
            IAdaptable context = (IAdaptable)target.getValue();
            HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                HyperlinkDetectorDescriptor descriptor = hyperlinkDetectorDescriptorArray[n2];
                if (targetId.equals(descriptor.getTargetId()) && !"org.eclipse.ui.internal.editors.text.URLHyperlinkDetector".equals(id = descriptor.getId())) {
                    HyperlinkDetectorDelegate delegate = new HyperlinkDetectorDelegate(descriptor);
                    delegate.setContext(context);
                    detectors.add(delegate);
                }
                ++n2;
            }
        }
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    protected AnnotationHyperlinkDetector createAnnotationHyperlinkDetector() {
        return new AnnotationHyperlinkDetector();
    }

    public void setTextPresentation(TextPresentation textPresentation) {
        if (textPresentation != null) {
            TextPresentation textPresentationCopy = new TextPresentation();
            textPresentationCopy.setDefaultStyleRange((StyleRange)(textPresentation.getDefaultStyleRange() == null ? null : textPresentation.getDefaultStyleRange().clone()));
            Iterator iterator = textPresentation.getAllStyleRangeIterator();
            while (iterator.hasNext()) {
                StyleRange styleRange = (StyleRange)iterator.next();
                textPresentationCopy.addStyleRange((StyleRange)styleRange.clone());
            }
            textPresentation = textPresentationCopy;
        }
        this.textPresentation = textPresentation;
    }

    private class HyperlinkDetectorDelegate
    implements IHyperlinkDetector,
    IHyperlinkDetectorExtension,
    IHyperlinkDetectorExtension2 {
        private HyperlinkDetectorDescriptor descriptor;
        private AbstractHyperlinkDetector delegate;
        private boolean createFailed;
        private IAdaptable context;
        private int stateMask;
        private boolean enabled;

        private HyperlinkDetectorDelegate(HyperlinkDetectorDescriptor descriptor) {
            this.descriptor = descriptor;
            if (HtmlViewerConfiguration.this.fPreferenceStore != null) {
                this.stateMask = HtmlViewerConfiguration.this.fPreferenceStore.getInt(String.valueOf(descriptor.getId()) + "_stateMask");
                this.enabled = !HtmlViewerConfiguration.this.fPreferenceStore.getBoolean(descriptor.getId());
            }
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            if (!this.isEnabled()) {
                return null;
            }
            if (!this.createFailed && this.delegate == null) {
                try {
                    this.delegate = this.descriptor.createHyperlinkDetector();
                }
                catch (CoreException coreException) {
                    this.createFailed = true;
                }
                if (this.delegate != null && this.context != null) {
                    this.delegate.setContext(this.context);
                }
            }
            if (this.delegate != null) {
                return this.delegate.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
            }
            return null;
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        private void setContext(IAdaptable context) {
            this.context = context;
        }

        public void dispose() {
            if (this.delegate != null) {
                this.delegate.dispose();
                this.delegate = null;
            }
            this.descriptor = null;
            this.context = null;
        }

        public int getStateMask() {
            return this.stateMask;
        }
    }

    protected class MarkupViewerDamagerRepairer
    implements IPresentationDamager,
    IPresentationRepairer {
        private IDocument document;

        protected MarkupViewerDamagerRepairer() {
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
            return new Region(0, this.document.getLength());
        }

        public void setDocument(IDocument document) {
            this.document = document;
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
            TextPresentation viewerPresentation = HtmlViewerConfiguration.this.textPresentation == null ? HtmlViewerConfiguration.this.viewer.getTextPresentation() : HtmlViewerConfiguration.this.textPresentation;
            presentation.clear();
            if (viewerPresentation == null) {
                return;
            }
            StyleRange defaultStyleRange = viewerPresentation.getDefaultStyleRange();
            presentation.setDefaultStyleRange((StyleRange)(defaultStyleRange == null ? null : defaultStyleRange.clone()));
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
            Iterator allStyleRangeIterator = viewerPresentation.getAllStyleRangeIterator();
            while (allStyleRangeIterator.hasNext()) {
                StyleRange range = (StyleRange)allStyleRangeIterator.next();
                ranges.add((StyleRange)range.clone());
            }
            int start = damage.getOffset();
            int x = 0;
            while (x < ranges.size()) {
                StyleRange range = (StyleRange)ranges.get(x);
                if (range.start > start) {
                    StyleRange newRange = defaultStyleRange == null ? new StyleRange() : (StyleRange)defaultStyleRange.clone();
                    newRange.start = start;
                    newRange.length = range.start - start;
                    ranges.add(++x, newRange);
                }
                start = range.start + range.length + 1;
                ++x;
            }
            if (start < damage.getOffset() + damage.getLength()) {
                StyleRange newRange = defaultStyleRange == null ? new StyleRange() : (StyleRange)defaultStyleRange.clone();
                newRange.start = start;
                newRange.length = damage.getOffset() + damage.getLength() - start;
                ranges.add(newRange);
            }
            presentation.replaceStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
        }
    }
}

