/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.provisional.commons.ui.IFilteredTreeListener;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.ui.IViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusTaskListAction
extends AbstractFocusViewAction
implements IFilteredTreeListener {
    private final TaskListInterestFilter taskListInterestFilter = new TaskListInterestFilter();
    private final TaskListInterestSorter taskListInterestSorter = new TaskListInterestSorter();
    private Set<AbstractTaskListFilter> previousFilters = new HashSet<AbstractTaskListFilter>();
    private ViewerSorter previousSorter;

    public FocusTaskListAction() {
        super(new InterestFilter(), false, true, false);
    }

    @Override
    public void init(IViewPart view) {
        super.init(view);
        IViewPart part = super.getPartForAction();
        if (part instanceof TaskListView) {
            ((TaskListView)part).getFilteredTree().getRefreshPolicy().addListener((IFilteredTreeListener)this);
        }
        this.update();
        ((TaskListView)part).getFilteredTree().setShowProgress(super.isChecked());
    }

    @Override
    protected boolean updateEnablementWithContextActivation() {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        IViewPart part = super.getPartForAction();
        if (part instanceof TaskListView) {
            ((TaskListView)part).getFilteredTree().getRefreshPolicy().removeListener((IFilteredTreeListener)this);
        }
    }

    @Override
    public void run(IAction action) {
        super.run(action);
    }

    @Override
    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        IViewPart part = super.getPartForAction();
        if (part instanceof TaskListView) {
            viewers.add((StructuredViewer)((TaskListView)part).getViewer());
        }
        return viewers;
    }

    @Override
    protected boolean installInterestFilter(StructuredViewer viewer) {
        IViewPart part = super.getPartForAction();
        if (part instanceof TaskListView) {
            final TaskListView taskListView = (TaskListView)part;
            TasksUiInternal.preservingSelection((TreeViewer)taskListView.getViewer(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        taskListView.getViewer().getControl().setRedraw(false);
                        taskListView.setFocusedMode(true);
                        FocusTaskListAction.this.previousSorter = taskListView.getViewer().getSorter();
                        FocusTaskListAction.this.previousFilters = new HashSet(taskListView.getFilters());
                        taskListView.clearFilters(false);
                        if (!taskListView.getFilters().contains(FocusTaskListAction.this.taskListInterestFilter)) {
                            taskListView.addFilter((AbstractTaskListFilter)FocusTaskListAction.this.taskListInterestFilter);
                        }
                        taskListView.getViewer().setSorter((ViewerSorter)FocusTaskListAction.this.taskListInterestSorter);
                        taskListView.getViewer().expandAll();
                        taskListView.setManualFiltersEnabled(false);
                        FocusTaskListAction.this.showProgressBar(taskListView, true);
                    }
                    finally {
                        taskListView.getViewer().getControl().setRedraw(true);
                    }
                }
            });
            return true;
        }
        return false;
    }

    private void showProgressBar(TaskListView taskListView, boolean visible) {
        taskListView.getFilteredTree().setShowProgress(visible);
    }

    @Override
    protected void uninstallInterestFilter(StructuredViewer viewer) {
        TaskListView taskListView;
        IViewPart part = super.getPartForAction();
        if (part instanceof TaskListView && (taskListView = (TaskListView)part).isFocusedMode()) {
            TasksUiInternal.preservingSelection((TreeViewer)taskListView.getViewer(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        taskListView.getViewer().getControl().setRedraw(false);
                        taskListView.setFocusedMode(false);
                        taskListView.removeFilter((AbstractTaskListFilter)FocusTaskListAction.this.taskListInterestFilter);
                        taskListView.setManualFiltersEnabled(true);
                        for (AbstractTaskListFilter filter : FocusTaskListAction.this.previousFilters) {
                            TaskListView.getFromActivePerspective().addFilter(filter);
                        }
                        taskListView.getViewer().collapseAll();
                        taskListView.getViewer().setSorter(FocusTaskListAction.this.previousSorter);
                        FocusTaskListAction.this.showProgressBar(taskListView, false);
                    }
                    finally {
                        taskListView.getViewer().getControl().setRedraw(true);
                    }
                }
            });
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }

    public void filterTextChanged(String text) {
        IViewPart part;
        if (this.isChecked() && (text == null || "".equals(text)) && (part = FocusTaskListAction.super.getPartForAction()) instanceof TaskListView) {
            ((TaskListView)part).getViewer().expandAll();
        }
    }

    @Override
    protected String getEmptyViewMessage() {
        return "No tasks scheduled for this week";
    }
}

