/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttributeFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskAttribute;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotification;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LegacyChangeManager {
    private static final int MAX_CHANGED_ATTRIBUTES = 2;

    static String cleanValue(String value) {
        if (value == null) {
            return "";
        }
        String commentText = value.replaceAll("\\s", " ").trim();
        if (commentText.length() > 60) {
            commentText = String.valueOf(commentText.substring(0, 55)) + "...";
        }
        return commentText;
    }

    static String cleanValues(List<String> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(LegacyChangeManager.cleanValue(value));
            first = false;
        }
        return sb.toString();
    }

    private static String getChangedAttributes(RepositoryTaskData newTaskData, RepositoryTaskData oldTaskData) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (RepositoryTaskAttribute newAttribute : newTaskData.getAttributes()) {
            List oldValues;
            List newValues;
            if (LegacyChangeManager.ignoreAttribute(newTaskData, newAttribute) || (newValues = newAttribute.getValues()) == null) continue;
            RepositoryTaskAttribute oldAttribute = oldTaskData.getAttribute(newAttribute.getId());
            if (oldAttribute == null) {
                changes.add(LegacyChangeManager.getDiff(newTaskData, newAttribute, null, newValues));
            }
            if (oldAttribute == null || (oldValues = oldAttribute.getValues()).equals(newValues)) continue;
            changes.add(LegacyChangeManager.getDiff(newTaskData, newAttribute, oldValues, newValues));
        }
        for (RepositoryTaskAttribute oldAttribute : oldTaskData.getAttributes()) {
            if (LegacyChangeManager.ignoreAttribute(oldTaskData, oldAttribute)) continue;
            RepositoryTaskAttribute attribute = newTaskData.getAttribute(oldAttribute.getId());
            List values = oldAttribute.getValues();
            if (attribute != null || values == null || values.isEmpty()) continue;
            changes.add(LegacyChangeManager.getDiff(oldTaskData, oldAttribute, values, null));
        }
        if (changes.isEmpty()) {
            return "";
        }
        String details = "";
        String sep = "";
        int n = 0;
        for (Change change : changes) {
            String removed = LegacyChangeManager.cleanValues(change.removed);
            String added = LegacyChangeManager.cleanValues(change.added);
            details = String.valueOf(details) + sep + "  " + change.field + " " + removed;
            if (removed.length() > 30) {
                details = String.valueOf(details) + "\n  ";
            }
            details = String.valueOf(details) + " -> " + added;
            sep = "\n";
            if (++n == 2) break;
        }
        return details;
    }

    private static String getChangedDescription(RepositoryTaskData newTaskData, RepositoryTaskData oldTaskData) {
        TaskComment lastComment;
        List taskComments;
        String descriptionText = "";
        if (newTaskData.getComments().size() > oldTaskData.getComments().size() && (taskComments = newTaskData.getComments()) != null && taskComments.size() > 0 && (lastComment = (TaskComment)taskComments.get(taskComments.size() - 1)) != null) {
            descriptionText = String.valueOf(descriptionText) + lastComment.getAuthor() + ":  ";
            descriptionText = String.valueOf(descriptionText) + LegacyChangeManager.cleanValue(lastComment.getText());
        }
        return descriptionText;
    }

    static Change getDiff(RepositoryTaskData taskData, RepositoryTaskAttribute attribute, List<String> oldValues, List<String> newValues) {
        Change change = new Change(attribute.getName(), newValues);
        if (oldValues != null) {
            for (String value : oldValues) {
                if (change.added.contains(value)) {
                    change.added.remove(value);
                    continue;
                }
                change.removed.add(value);
            }
        }
        return change;
    }

    @Deprecated
    public static TaskListNotification getIncommingNotification(AbstractRepositoryConnector connector, ITask task) {
        TaskListNotification notification = new TaskListNotification(task);
        RepositoryTaskData newTaskData = TasksUiPlugin.getTaskDataStorageManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
        RepositoryTaskData oldTaskData = TasksUiPlugin.getTaskDataStorageManager().getOldTaskData(task.getRepositoryUrl(), task.getTaskId());
        try {
            if (task.getSynchronizationState().equals((Object)ITask.SynchronizationState.INCOMING) && ((AbstractTask)task).getLastReadTimeStamp() == null) {
                notification.setDescription("New unread task ");
            } else if (newTaskData != null && oldTaskData != null) {
                AbstractTaskDataHandler offlineHandler;
                StringBuilder description = new StringBuilder();
                String changedDescription = LegacyChangeManager.getChangedDescription(newTaskData, oldTaskData);
                String changedAttributes = LegacyChangeManager.getChangedAttributes(newTaskData, oldTaskData);
                if (!"".equals(changedDescription.trim())) {
                    description.append(changedDescription);
                    if (!"".equals(changedAttributes)) {
                        description.append('\n');
                    }
                }
                if (!"".equals(changedAttributes)) {
                    description.append(changedAttributes);
                }
                notification.setDescription(description.toString());
                if (connector instanceof AbstractLegacyRepositoryConnector && (offlineHandler = ((AbstractLegacyRepositoryConnector)connector).getLegacyTaskDataHandler()) != null && newTaskData.getLastModified() != null) {
                    Date modified = newTaskData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", newTaskData.getLastModified());
                    notification.setDate(modified);
                }
            } else {
                notification.setDescription("Unread task");
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not format notification for: " + task, t));
        }
        return notification;
    }

    static boolean ignoreAttribute(RepositoryTaskData taskData, RepositoryTaskAttribute attribute) {
        AbstractAttributeFactory factory = taskData.getAttributeFactory();
        return attribute.getId().equals(factory.mapCommonAttributeKey("task.common.date.modified")) || attribute.getId().equals(factory.mapCommonAttributeKey("task.common.date.created")) || "delta_ts".equals(attribute.getId()) || "longdesclength".equals(attribute.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Change {
        final List<String> added;
        final String field;
        final List<String> removed = new ArrayList<String>();

        public Change(String field, List<String> newValues) {
            this.field = field;
            this.added = newValues != null ? new ArrayList<String>(newValues) : new ArrayList<String>();
        }
    }
}

