/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AutomaticRepositoryTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.delete";

    public DeleteAction() {
        this.setText("Delete");
        this.setId(ID);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void run() {
        ISelection selection = TaskListView.getFromActivePerspective().getViewer().getSelection();
        this.doDelete(((IStructuredSelection)selection).toList());
    }

    protected void doDelete(List<?> toDelete) {
        Object object;
        String elements = "";
        int i = 0;
        for (Object object2 : toDelete) {
            if (object2 instanceof UnmatchedTaskContainer) continue;
            if (++i < 20) {
                if (!(object2 instanceof IRepositoryElement)) continue;
                elements = String.valueOf(elements) + "    " + ((IRepositoryElement)object2).getSummary() + "\n";
                continue;
            }
            elements = String.valueOf(elements) + "...";
            break;
        }
        String message = toDelete.size() == 1 ? ((object = toDelete.get(0)) instanceof ITask ? (((AbstractTask)object).isLocal() ? "Permanently delete the task listed below?" : "Delete the planning information and context for the repository task?  The server copy will not be deleted and the task will remain in queries that match it.") : (object instanceof TaskCategory ? "Permanently delete the category?  Local tasks will be moved to the Uncategorized folder. Repository tasks will be moved to the Unmatched folder." : (object instanceof IRepositoryQuery ? "Permanently delete the query?  Contained tasks will be moved to the Unmatched folder." : (object instanceof UnmatchedTaskContainer ? "Delete the planning information and context of all unmatched tasks?  The server copy of these tasks will not be deleted and the task will remain in queries that match it." : (object instanceof UnsubmittedTaskContainer ? "Delete all of the unsubmitted tasks?" : "Permanently delete the element listed below?"))))) : "Delete the elements listed below?  If categories or queries are selected contained tasks will not be deleted.  Contexts will be deleted for selected tasks.";
        message = String.valueOf(message) + "\n\n" + elements;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm Delete", (String)message);
        if (!deleteConfirmed) {
            return;
        }
        this.performDeletion(toDelete);
    }

    protected void performDeletion(Collection<?> toDelete) {
        for (Object selectedObject : toDelete) {
            if (selectedObject instanceof ITask) {
                AbstractTask task = null;
                task = (AbstractTask)selectedObject;
                TasksUi.getTaskActivityManager().deactivateTask((ITask)task);
                TasksUiInternal.getTaskList().deleteTask((ITask)task);
                try {
                    TasksUiPlugin.getTaskDataManager().deleteTaskData((ITask)task);
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to delete task data", (Throwable)e));
                }
                ContextCore.getContextManager().deleteContext(task.getHandleIdentifier());
                TasksUiInternal.closeEditorInActivePage((ITask)task, false);
                continue;
            }
            if (selectedObject instanceof IRepositoryQuery) {
                TasksUiInternal.getTaskList().deleteQuery((RepositoryQuery)selectedObject);
                continue;
            }
            if (selectedObject instanceof TaskCategory) {
                TaskCategory cat = (TaskCategory)selectedObject;
                for (ITask task : cat.getChildren()) {
                    ContextCore.getContextManager().deleteContext(task.getHandleIdentifier());
                    TasksUiInternal.closeEditorInActivePage(task, false);
                }
                TasksUiInternal.getTaskList().deleteCategory((AbstractTaskCategory)cat);
                continue;
            }
            if (selectedObject instanceof AutomaticRepositoryTaskContainer) {
                if (toDelete.size() != 1) continue;
                while (((AutomaticRepositoryTaskContainer)selectedObject).getChildren().size() != 0) {
                    this.performDeletion(((AutomaticRepositoryTaskContainer)selectedObject).getChildren());
                }
                continue;
            }
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete failed", (String)"Nothing selected.");
            return;
        }
    }
}

