/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExportAction
extends Action
implements IViewActionDelegate {
    protected ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run(this.getSelectedQueries(this.selection));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        List<RepositoryQuery> selectedQueries = this.getSelectedQueries(selection);
        action.setEnabled(true);
        if (selectedQueries.size() > 0) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    protected List<RepositoryQuery> getSelectedQueries(ISelection newSelection) {
        ArrayList<RepositoryQuery> selectedQueries = new ArrayList<RepositoryQuery>();
        if (this.selection instanceof StructuredSelection) {
            List selectedObjects = ((StructuredSelection)this.selection).toList();
            for (Object selectedObject : selectedObjects) {
                if (!(selectedObject instanceof IRepositoryQuery)) continue;
                selectedQueries.add((RepositoryQuery)selectedObject);
            }
        }
        return selectedQueries;
    }

    public void run(List<RepositoryQuery> queries) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 40960);
        dialog.setFilterExtensions(new String[]{"*.xml.zip"});
        if (queries.size() == 1) {
            dialog.setFileName(String.valueOf(queries.get(0).getHandleIdentifier()) + ".xml.zip");
        } else {
            String fomratString = "yyyy-MM-dd";
            SimpleDateFormat format = new SimpleDateFormat(fomratString, Locale.ENGLISH);
            String date = format.format(new Date());
            dialog.setFileName(String.valueOf(date) + "-exported-queries" + ".xml.zip");
        }
        String path = dialog.open();
        if (path != null) {
            File file = new File(path);
            if (file.isDirectory()) {
                MessageDialog.openError((Shell)shell, (String)"Query Export Error", (String)"Could not export query because specified location is a folder");
                return;
            }
            if (file.exists() && !MessageDialog.openConfirm((Shell)shell, (String)"Confirm File Replace", (String)("The file " + file.getPath() + " already exists. Do you want to overwrite it?"))) {
                return;
            }
            TasksUiPlugin.getTaskListManager().getTaskListWriter().writeQueries(queries, file);
        }
    }
}

