/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.ActionFactory;

public class SynchronizeSelectedAction
extends ActionDelegate
implements IViewActionDelegate {
    private final Map<AbstractRepositoryConnector, List<RepositoryQuery>> queriesToSyncMap = new LinkedHashMap<AbstractRepositoryConnector, List<RepositoryQuery>>();
    private final Map<AbstractRepositoryConnector, List<ITask>> tasksToSyncMap = new LinkedHashMap<AbstractRepositoryConnector, List<ITask>>();
    private IAction action;

    public void run(IAction action) {
        if (TaskListView.getFromActivePerspective() != null) {
            ISelection selection = TaskListView.getFromActivePerspective().getViewer().getSelection();
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                AbstractRepositoryConnector client;
                if (obj instanceof IRepositoryQuery) {
                    RepositoryQuery repositoryQuery = (RepositoryQuery)obj;
                    client = TasksUi.getRepositoryManager().getRepositoryConnector(repositoryQuery.getConnectorKind());
                    if (client == null) continue;
                    List<RepositoryQuery> queriesToSync = this.queriesToSyncMap.get(client);
                    if (queriesToSync == null) {
                        queriesToSync = new ArrayList<RepositoryQuery>();
                        this.queriesToSyncMap.put(client, queriesToSync);
                    }
                    queriesToSync.add(repositoryQuery);
                    continue;
                }
                if (obj instanceof TaskCategory) {
                    TaskCategory cat = (TaskCategory)obj;
                    for (ITask task : cat.getChildren()) {
                        AbstractRepositoryConnector client2 = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
                        this.addTaskToSync(client2, task);
                    }
                    continue;
                }
                if (!(obj instanceof ITask)) continue;
                AbstractTask repositoryTask = (AbstractTask)obj;
                client = TasksUi.getRepositoryManager().getRepositoryConnector(repositoryTask.getConnectorKind());
                this.addTaskToSync(client, (ITask)repositoryTask);
            }
            TasksUiPlugin.getTaskDataManager();
            if (!this.queriesToSyncMap.isEmpty()) {
                HashMap<TaskRepository, HashSet<RepositoryQuery>> repositoriesToSync = new HashMap<TaskRepository, HashSet<RepositoryQuery>>();
                for (AbstractRepositoryConnector abstractRepositoryConnector : this.queriesToSyncMap.keySet()) {
                    List<RepositoryQuery> queriesToSync = this.queriesToSyncMap.get(abstractRepositoryConnector);
                    if (queriesToSync == null || queriesToSync.isEmpty()) continue;
                    for (RepositoryQuery query : queriesToSync) {
                        TaskRepository repos = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
                        HashSet<RepositoryQuery> queries = (HashSet<RepositoryQuery>)repositoriesToSync.get(repos);
                        if (queries == null) {
                            queries = new HashSet<RepositoryQuery>();
                            repositoriesToSync.put(repos, queries);
                        }
                        queries.add(query);
                    }
                }
                for (Map.Entry entry : repositoriesToSync.entrySet()) {
                    TaskRepository repository = (TaskRepository)entry.getKey();
                    AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                    Set queries = (Set)entry.getValue();
                    TasksUiInternal.synchronizeQueries(connector, repository, queries, null, true);
                }
            }
            if (!this.tasksToSyncMap.isEmpty()) {
                for (AbstractRepositoryConnector connector : this.tasksToSyncMap.keySet()) {
                    List<ITask> tasksToSync = this.tasksToSyncMap.get(connector);
                    if (tasksToSync == null || tasksToSync.size() <= 0) continue;
                    TasksUiInternal.synchronizeTasks(connector, new HashSet<ITask>(tasksToSync), true, null);
                }
            }
        }
        this.queriesToSyncMap.clear();
        this.tasksToSyncMap.clear();
    }

    private void addTaskToSync(AbstractRepositoryConnector connector, ITask task) {
        if (connector == null || task instanceof LocalTask || task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
            return;
        }
        List<ITask> tasksToSync = this.tasksToSyncMap.get(connector);
        if (tasksToSync == null) {
            tasksToSync = new ArrayList<ITask>();
            this.tasksToSyncMap.put(connector, tasksToSync);
        }
        tasksToSync.add(task);
    }

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IViewPart view) {
        IActionBars actionBars = view.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.action);
        actionBars.updateActionBars();
    }
}

