/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.DateAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorSummaryPart
extends AbstractTaskEditorPart {
    private static final int COLUMN_MARGIN = 6;
    private Composite headerComposite;
    private AbstractAttributeEditor summaryEditor;

    public TaskEditorSummaryPart() {
        this.setPartName("Summary");
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute) {
        this.addAttribute(composite, toolkit, attribute, 6);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, int indent) {
        this.addAttribute(composite, toolkit, attribute, indent, true);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, int indent, boolean showLabel) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            Image image;
            ITask.PriorityLevel priorityLevel;
            ITaskMapping mapping;
            editor.setReadOnly(true);
            editor.setDecorationEnabled(false);
            boolean isPriority = this.isAttribute(attribute, "task.common.priority");
            if (showLabel && !isPriority) {
                editor.createLabelControl(composite, toolkit);
                GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(indent, 0).applyTo((Control)editor.getLabelControl());
            }
            if (isPriority && (mapping = this.getTaskEditorPage().getConnector().getTaskMapping(this.getTaskData())) != null && (priorityLevel = mapping.getPriorityLevel()) != null && (image = CommonImages.getImage((ImageDescriptor)TasksUiInternal.getPriorityImage(this.getTaskEditorPage().getTask()))) != null) {
                Label label = toolkit.createLabel(this.headerComposite, null);
                label.setImage(image);
                GridDataFactory.defaultsFor((Control)label).indent(5, -3).applyTo((Control)label);
            }
            if (this.isAttribute(attribute, "task.common.date.modified") && editor instanceof DateAttributeEditor) {
                ((DateAttributeEditor)editor).setShowTime(true);
            }
            editor.createControl(composite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
        }
    }

    private boolean isAttribute(TaskAttribute attribute, String id) {
        return attribute.getId().equals(attribute.getTaskData().getAttributeMapper().mapToRepositoryKey(attribute.getParentAttribute(), id));
    }

    private void addSummaryText(Composite composite, FormToolkit toolkit) {
        this.summaryEditor = this.createAttributeEditor(this.getTaskData().getRoot().getMappedAttribute("task.common.summary"));
        if (this.summaryEditor != null) {
            this.summaryEditor.createControl(composite, toolkit);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(this.summaryEditor.getControl());
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.summaryEditor);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        this.addSummaryText(composite, toolkit);
        if (this.needsHeader()) {
            this.createHeaderLayout(composite, toolkit);
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }

    protected void createHeaderLayout(Composite composite, FormToolkit toolkit) {
        this.headerComposite = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout(11, false);
        layout.verticalSpacing = 1;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.headerComposite.setLayout((Layout)layout);
        TaskAttribute priorityAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.priority");
        this.addAttribute(this.headerComposite, toolkit, priorityAttribute);
        TaskAttribute statusAtribute = this.getTaskData().getRoot().getMappedAttribute("task.common.status");
        this.addAttribute(this.headerComposite, toolkit, statusAtribute, 0);
        ITaskMapping mapping = this.getTaskEditorPage().getConnector().getTaskMapping(this.getTaskData());
        if (mapping != null && mapping.getResolution() != null && mapping.getResolution().length() > 0) {
            TaskAttribute resolutionAtribute = this.getTaskData().getRoot().getMappedAttribute("task.common.resolution");
            this.addAttribute(this.headerComposite, toolkit, resolutionAtribute, 0, false);
        }
        TaskAttribute keyAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.key");
        this.addAttribute(this.headerComposite, toolkit, keyAttribute);
        TaskAttribute dateCreation = this.getTaskData().getRoot().getMappedAttribute("task.common.date.created");
        this.addAttribute(this.headerComposite, toolkit, dateCreation);
        TaskAttribute dateModified = this.getTaskData().getRoot().getMappedAttribute("task.common.date.modified");
        this.addAttribute(this.headerComposite, toolkit, dateModified);
    }

    public boolean needsHeader() {
        return !this.getTaskData().isNew();
    }

    public void setFocus() {
        if (this.summaryEditor != null) {
            this.summaryEditor.getControl().setFocus();
        }
    }
}

