/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.search.RepositorySearchResultView;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchHitCollector;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.PlatformUI;

public class CreateQueryFromSearchAction
extends Action {
    private final RepositorySearchResultView resultView;

    public CreateQueryFromSearchAction(String text, RepositorySearchResultView resultView) {
        this.setText(text);
        this.setImageDescriptor(TasksUiImages.QUERY_NEW);
        this.resultView = resultView;
    }

    public void run() {
        IStructuredSelection structuredSelection;
        ISelection selection = this.resultView.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof ITask) {
            ISearchQuery[] queries = NewSearchUI.getQueries();
            ITask task = (ITask)structuredSelection.getFirstElement();
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
            if (queries.length != 0 && connector != null) {
                SearchHitCollector searchHitCollector = (SearchHitCollector)queries[0];
                IRepositoryQuery query = searchHitCollector.getRepositoryQuery();
                InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Create Query", "Name of query to be added to the Task List: ", "", null);
                int dialogResult = dialog.open();
                if (dialogResult == 0) {
                    query.setSummary(dialog.getValue());
                    TasksUiInternal.getTaskList().addQuery((RepositoryQuery)query);
                    TasksUiInternal.synchronizeQuery(connector, (RepositoryQuery)query, null, true);
                }
            }
        }
    }
}

