/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.ui.search.RepositorySearchResult;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultContentProvider;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class SearchResultTreeContentProvider
extends SearchResultContentProvider {
    private final List<Object> elements = new ArrayList<Object>();
    private final Map<String, Person> owners = new HashMap<String, Person>();
    private final Map<String, TaskGroup> completeState = new HashMap<String, TaskGroup>();
    private GroupBy selectedGroup;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof RepositorySearchResult) {
            this.searchResult = (RepositorySearchResult)((Object)newInput);
            this.clear();
            this.elementsChanged(this.searchResult.getElements());
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this.searchResult) {
            if (this.selectedGroup == GroupBy.OWNER) {
                return this.owners.values().toArray();
            }
            if (this.selectedGroup == GroupBy.COMPLETION) {
                return this.completeState.values().toArray();
            }
            return this.elements.toArray();
        }
        return this.EMPTY_ARR;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TaskGroup || parent instanceof Person) {
            return ((ITaskContainer)parent).getChildren().toArray();
        }
        return this.EMPTY_ARR;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void elementsChanged(Object[] updatedElements) {
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.elements.add(object);
            if (object instanceof ITask) {
                Person person;
                AbstractTask task = (AbstractTask)object;
                String owner = task.getOwner();
                if (owner == null) {
                    owner = "<unknown>";
                }
                if ((person = this.owners.get(owner)) == null) {
                    person = new Person(owner, task.getConnectorKind(), task.getRepositoryUrl());
                    this.owners.put(owner, person);
                }
                person.internalAddChild(task);
                TaskGroup completeIncomplete = null;
                if (task.isCompleted()) {
                    completeIncomplete = this.completeState.get("Complete");
                    if (completeIncomplete == null) {
                        completeIncomplete = new TaskGroup("group-complete", "Complete", GroupBy.COMPLETION.name());
                        this.completeState.put("Complete", completeIncomplete);
                    }
                } else {
                    completeIncomplete = this.completeState.get("Incomplete");
                    if (completeIncomplete == null) {
                        completeIncomplete = new TaskGroup("group-incomplete", "Incomplete", GroupBy.COMPLETION.name());
                        this.completeState.put("Incomplete", completeIncomplete);
                    }
                }
                completeIncomplete.internalAddChild(task);
            }
            ++n2;
        }
    }

    public void clear() {
        this.elements.clear();
        this.owners.clear();
        this.completeState.clear();
    }

    public GroupBy getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(GroupBy selectedGroup) {
        this.selectedGroup = selectedGroup;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GroupBy {
        NONE,
        OWNER,
        COMPLETION;

    }
}

