/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

class PriorityDropDownAction
extends Action
implements IMenuCreator {
    private final TaskListView taskListView;
    private static final String FILTER_PRIORITY_LABEL = "Filter Priority Lower Than";
    private Action priority1;
    private Action priority2;
    private Action priority3;
    private Action priority4;
    private Action priority5;
    private Menu dropDownMenu = null;

    public PriorityDropDownAction(TaskListView taskListView) {
        this.taskListView = taskListView;
        this.setText(FILTER_PRIORITY_LABEL);
        this.setToolTipText(FILTER_PRIORITY_LABEL);
        this.setImageDescriptor(CommonImages.FILTER_PRIORITY);
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public void addActionsToMenu() {
        this.priority1 = new Action("", 2){

            public void run() {
                TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.priority", ITask.PriorityLevel.P1.toString());
                PriorityDropDownAction.this.taskListView.displayPrioritiesAbove(TaskListView.PRIORITY_LEVELS[0]);
            }
        };
        this.priority1.setEnabled(true);
        this.priority1.setText(ITask.PriorityLevel.P1.getDescription());
        this.priority1.setImageDescriptor(CommonImages.PRIORITY_1);
        ActionContributionItem item = new ActionContributionItem((IAction)this.priority1);
        item.fill(this.dropDownMenu, -1);
        this.priority2 = new Action("", 2){

            public void run() {
                TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.priority", ITask.PriorityLevel.P2.toString());
                PriorityDropDownAction.this.taskListView.displayPrioritiesAbove(TaskListView.PRIORITY_LEVELS[1]);
            }
        };
        this.priority2.setEnabled(true);
        this.priority2.setText(ITask.PriorityLevel.P2.getDescription());
        this.priority2.setImageDescriptor(CommonImages.PRIORITY_2);
        item = new ActionContributionItem((IAction)this.priority2);
        item.fill(this.dropDownMenu, -1);
        this.priority3 = new Action("", 2){

            public void run() {
                TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.priority", ITask.PriorityLevel.P3.toString());
                PriorityDropDownAction.this.taskListView.displayPrioritiesAbove(TaskListView.PRIORITY_LEVELS[2]);
            }
        };
        this.priority3.setEnabled(true);
        this.priority3.setText(ITask.PriorityLevel.P3.getDescription());
        this.priority3.setImageDescriptor(CommonImages.PRIORITY_3);
        item = new ActionContributionItem((IAction)this.priority3);
        item.fill(this.dropDownMenu, -1);
        this.priority4 = new Action("", 2){

            public void run() {
                TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.priority", ITask.PriorityLevel.P4.toString());
                PriorityDropDownAction.this.taskListView.displayPrioritiesAbove(TaskListView.PRIORITY_LEVELS[3]);
            }
        };
        this.priority4.setEnabled(true);
        this.priority4.setText(ITask.PriorityLevel.P4.getDescription());
        this.priority4.setImageDescriptor(CommonImages.PRIORITY_4);
        item = new ActionContributionItem((IAction)this.priority4);
        item.fill(this.dropDownMenu, -1);
        this.priority5 = new Action("", 2){

            public void run() {
                TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.filters.priority", ITask.PriorityLevel.P5.toString());
                PriorityDropDownAction.this.taskListView.displayPrioritiesAbove(TaskListView.PRIORITY_LEVELS[4]);
            }
        };
        this.priority5.setEnabled(true);
        this.priority5.setImageDescriptor(CommonImages.PRIORITY_5);
        this.priority5.setText(ITask.PriorityLevel.P5.getDescription());
        item = new ActionContributionItem((IAction)this.priority5);
        item.fill(this.dropDownMenu, -1);
        this.updateCheckedState();
    }

    void updateCheckedState() {
        if (this.priority1 == null) {
            return;
        }
        String priority = TaskListView.getCurrentPriorityLevel();
        this.priority1.setChecked(false);
        this.priority2.setChecked(false);
        this.priority3.setChecked(false);
        this.priority4.setChecked(false);
        this.priority5.setChecked(false);
        if (priority.equals(TaskListView.PRIORITY_LEVELS[0])) {
            this.priority1.setChecked(true);
        } else if (priority.equals(TaskListView.PRIORITY_LEVELS[1])) {
            this.priority1.setChecked(true);
            this.priority2.setChecked(true);
        } else if (priority.equals(TaskListView.PRIORITY_LEVELS[2])) {
            this.priority1.setChecked(true);
            this.priority2.setChecked(true);
            this.priority3.setChecked(true);
        } else if (priority.equals(TaskListView.PRIORITY_LEVELS[3])) {
            this.priority1.setChecked(true);
            this.priority2.setChecked(true);
            this.priority3.setChecked(true);
            this.priority4.setChecked(true);
        } else if (priority.equals(TaskListView.PRIORITY_LEVELS[4])) {
            this.priority1.setChecked(true);
            this.priority2.setChecked(true);
            this.priority3.setChecked(true);
            this.priority4.setChecked(true);
            this.priority5.setChecked(true);
        }
    }

    public void run() {
        this.setChecked(this.isChecked());
    }
}

