/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class TaskListInterestFilter
extends AbstractTaskListFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Object parent, Object child) {
        try {
            ITask task;
            if (child instanceof ScheduledTaskContainer) {
                ScheduledTaskContainer dateRangeTaskContainer = (ScheduledTaskContainer)child;
                return this.isDateRangeInteresting(dateRangeTaskContainer);
            }
            if (child instanceof ITask) {
                AbstractTask task2 = null;
                if (child instanceof ITask) {
                    task2 = (AbstractTask)child;
                }
                if (task2 == null) return false;
                if (!this.isInteresting(parent, task2)) return false;
                return true;
            }
            if (!(child instanceof ITaskContainer)) return false;
            Collection children = ((ITaskContainer)child).getChildren();
            if (children.size() == 0) {
                return false;
            }
            Iterator iterator = children.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.shouldAlwaysShow(child, (AbstractTask)(task = (ITask)iterator.next()), 10));
            return true;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Interest filter failed", t));
        }
        return false;
    }

    private boolean isDateRangeInteresting(ScheduledTaskContainer scheduleContainer) {
        if (scheduleContainer instanceof TaskScheduleContentProvider.Unscheduled) {
            return true;
        }
        return TaskActivityUtil.getCurrentWeek().isCurrentWeekDay(scheduleContainer.getDateRange()) ? scheduleContainer.isPresent() || scheduleContainer.isFuture() : scheduleContainer.isPresent();
    }

    protected boolean isInteresting(Object parent, AbstractTask task) {
        return this.shouldAlwaysShow(parent, task, 10);
    }

    public boolean shouldAlwaysShow(Object parent, AbstractTask task, int depth) {
        return task.isActive() || TasksUiPlugin.getTaskActivityManager().isCompletedToday((ITask)task) || this.hasChanges(parent, (ITask)task) || this.hasInterestingSubTasks(parent, task, depth) || !task.isCompleted() && ("New Task".equals(task.getSummary()) || this.shouldShowInFocusedWorkweekDateContainer(parent, (ITask)task) || TasksUiPlugin.getTaskActivityManager().isOverdue((ITask)task) || this.isInterestingForThisWeek(parent, task));
    }

    private boolean hasInterestingSubTasks(Object parent, AbstractTask task, int depth) {
        if (depth > 0) {
            if (!TasksUiPlugin.getDefault().groupSubtasks((ITaskContainer)task)) {
                return false;
            }
            if (task.getChildren() != null && task.getChildren().size() > 0) {
                for (ITask subTask : task.getChildren()) {
                    if (!this.shouldAlwaysShow(parent, (AbstractTask)subTask, depth - 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldShowInFocusedWorkweekDateContainer(Object parent, ITask task) {
        if (parent instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)parent;
            if (container instanceof TaskScheduleContentProvider.Unscheduled) {
                return false;
            }
            if (this.isDateRangeInteresting(container)) {
                return true;
            }
        }
        return false;
    }

    public boolean isInterestingForThisWeek(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer) {
            return this.shouldShowInFocusedWorkweekDateContainer(parent, (ITask)task);
        }
        return TasksUiPlugin.getTaskActivityManager().isPastReminder(task) || TasksUiPlugin.getTaskActivityManager().isSheduledForPastWeek(task) || TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task) || TasksUiPlugin.getTaskActivityManager().isDueThisWeek((ITask)task) || TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task);
    }

    public boolean hasChanges(Object parent, ITask task) {
        if (parent instanceof ScheduledTaskContainer && !(parent instanceof TaskScheduleContentProvider.Unscheduled) && !this.shouldShowInFocusedWorkweekDateContainer(parent, task)) {
            return false;
        }
        return this.hasChangesHelper(parent, task);
    }

    private boolean hasChangesHelper(Object parent, ITask task) {
        if (task.getSynchronizationState().isOutgoing()) {
            return true;
        }
        if (task.getSynchronizationState().isIncoming()) {
            return true;
        }
        if (task instanceof ITaskContainer) {
            for (ITask child : ((ITaskContainer)task).getChildren()) {
                if (!this.hasChangesHelper(parent, child)) continue;
                return true;
            }
        }
        return false;
    }
}

