/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IImplicitlyIntersting;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.internal.WorkingSet;

public class InterestFilter
extends ViewerFilter {
    private Object temporarilyUnfiltered = null;

    public boolean select(Viewer viewer, Object parent, Object object) {
        IInteractionElement element;
        block18: {
            AbstractContextStructureBridge bridge;
            block20: {
                block19: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    if (viewer instanceof StructuredViewer) break block14;
                                    return true;
                                }
                                if (!this.isTemporarilyUnfiltered(parent)) break block15;
                                return true;
                            }
                            if (!(this.temporarilyUnfiltered instanceof Tree) || !this.isRootElement(object)) break block16;
                            return true;
                        }
                        element = null;
                        if (!(object instanceof IImplicitlyIntersting)) break block17;
                        return true;
                    }
                    if (object instanceof IInteractionElement) {
                        element = (IInteractionElement)object;
                        break block18;
                    }
                    bridge = ContextCore.getStructureBridge((Object)object);
                    if (bridge.getContentType() != null) break block19;
                    if (object instanceof IAdaptable) {
                        Object adapted = ((IAdaptable)object).getAdapter(IResource.class);
                        if (adapted instanceof IResource) {
                            object = adapted;
                        }
                        bridge = ContextCore.getStructureBridge((Object)object);
                        break block19;
                    }
                    return false;
                }
                if (bridge.canFilter(object)) break block20;
                return true;
            }
            if (!object.getClass().getName().equals(Object.class.getCanonicalName())) {
                String handle = bridge.getHandleIdentifier(object);
                element = ContextCore.getContextManager().getElement(handle);
                break block18;
            }
            return true;
        }
        try {
            if (element != null) {
                return this.isInteresting(element);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Interest filter failed on viewer: " + viewer.getClass(), t));
        }
        return false;
    }

    protected boolean isRootElement(Object object) {
        return object instanceof IProjectNature || object instanceof IProject || object instanceof WorkingSet;
    }

    protected boolean isInteresting(IInteractionElement element) {
        return element.getInterest().isInteresting();
    }

    private boolean isTemporarilyUnfiltered(Object parent) {
        if (parent instanceof TreePath) {
            TreePath treePath = (TreePath)parent;
            parent = treePath.getLastSegment();
        }
        return this.temporarilyUnfiltered != null && this.temporarilyUnfiltered.equals(parent);
    }

    public void setTemporarilyUnfiltered(Object temprarilyUnfiltered) {
        this.temporarilyUnfiltered = temprarilyUnfiltered;
    }

    public boolean resetTemporarilyUnfiltered() {
        if (this.temporarilyUnfiltered != null) {
            this.temporarilyUnfiltered = null;
            return true;
        }
        return false;
    }

    public Object getTemporarilyUnfiltered() {
        return this.temporarilyUnfiltered;
    }
}

