/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.editors.ContextEditorFormPage;
import org.eclipse.mylyn.internal.context.ui.views.ContextNodeOpenListener;
import org.eclipse.mylyn.internal.context.ui.views.QuickOutlinePatternAndInterestFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.ui.navigator.CommonViewer;

public class QuickContextPopupDialog
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    public static final String ID_VIEWER = "org.eclipse.mylyn.context.ui.navigator.context.quick";
    private CommonViewer commonViewer;
    private final InterestFilter interestFilter = new InterestFilter();
    private Text fFilterText;
    private StringMatcher fStringMatcher;
    private QuickOutlinePatternAndInterestFilter namePatternFilter;
    private ContextNodeOpenListener openListener;

    public QuickContextPopupDialog(Shell parent) {
        super(parent, 16, true, true, true, true, null, "Task Context");
        this.create();
    }

    public boolean close() {
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.createViewer(parent);
        this.createUIListenersTreeViewer();
        this.addDisposeListener(this);
        return this.commonViewer.getControl();
    }

    private void createViewer(Composite parent) {
        Control composite = super.createDialogArea(parent);
        this.commonViewer = this.createCommonViewer((Composite)composite);
        this.openListener = new ContextNodeOpenListener((Viewer)this.commonViewer);
        this.commonViewer.addOpenListener((IOpenListener)this.openListener);
        this.commonViewer.getTree().addMouseListener((MouseListener)this.openListener);
        this.commonViewer.addFilter((ViewerFilter)this.interestFilter);
        this.namePatternFilter = new QuickOutlinePatternAndInterestFilter();
        this.commonViewer.addFilter((ViewerFilter)this.namePatternFilter);
        try {
            this.commonViewer.getControl().setRedraw(false);
            ContextEditorFormPage.forceFlatLayoutOfJavaContent(this.commonViewer);
            this.commonViewer.setInput((Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getInput());
            this.commonViewer.expandAll();
        }
        finally {
            this.commonViewer.getControl().setRedraw(true);
        }
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = new CommonViewer(ID_VIEWER, parent, 768);
        viewer.getControl().setLayoutData((Object)new GridData(500, 400));
        return viewer;
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        dialogMenu.add((IContributionItem)new Separator());
        super.fillDialogMenu(dialogMenu);
    }

    private void createUIListenersTreeViewer() {
        final Tree tree = this.commonViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    QuickContextPopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                QuickContextPopupDialog.this.handleTreeViewerMouseUp(tree, e);
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickContextPopupDialog.this.gotoSelectedElement();
            }
        });
    }

    private void handleTreeViewerMouseUp(Tree tree, MouseEvent e) {
        if (tree.getSelectionCount() < 1 || e.button != 1 || !tree.equals(e.getSource())) {
            return;
        }
        TreeItem object = tree.getItem(new Point(e.x, e.y));
        TreeItem selection = tree.getSelection()[0];
        if (selection.equals(object)) {
            this.gotoSelectedElement();
        }
    }

    private Object getSelectedElement() {
        if (this.commonViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.commonViewer.getSelection()).getFirstElement();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.close();
    }

    public boolean isFocusControl() {
        return this.commonViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setLocation(Point location) {
        if (!this.getPersistBounds() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean hasContents() {
        return this.commonViewer != null && this.commonViewer.getInput() != null;
    }

    public void setInput(Object input) {
        if (input != null) {
            this.commonViewer.setSelection((ISelection)new StructuredSelection(input));
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.commonViewer = null;
        this.fFilterText = null;
    }

    protected Control createTitleControl(Composite parent) {
        this.createUIWidgetFilterText(parent);
        this.createUIListenersFilterText();
        return this.fFilterText;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = ContextUiPlugin.getDefault().getDialogSettings();
        IDialogSettings result = dialogSettings.getSection(ID_VIEWER);
        if (result == null) {
            result = dialogSettings.addNewSection(ID_VIEWER);
        }
        return result;
    }

    private void createUIWidgetFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData data = new GridData(768);
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement == null) {
            return;
        }
        this.dispose();
    }

    private void createUIListenersFilterText() {
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    QuickContextPopupDialog.this.gotoSelectedElement();
                } else if (e.keyCode == 0x1000002) {
                    QuickContextPopupDialog.this.commonViewer.getTree().setFocus();
                } else if (e.keyCode == 0x1000001) {
                    QuickContextPopupDialog.this.commonViewer.getTree().setFocus();
                } else if (e.character == '\u001b') {
                    QuickContextPopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0) {
                    if (text.charAt(length - 1) != '*') {
                        text = String.valueOf(text) + '*';
                    }
                    if (text.charAt(0) != '*') {
                        text = String.valueOf('*') + text;
                    }
                }
                QuickContextPopupDialog.this.setMatcherString(text, true);
            }
        });
    }

    private void setMatcherString(String pattern, boolean update) {
        this.fStringMatcher = pattern.length() == 0 ? null : new StringMatcher(pattern, true, false);
        this.namePatternFilter.setStringMatcher(this.fStringMatcher);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private void stringMatcherUpdated() {
        this.commonViewer.getControl().setRedraw(false);
        this.commonViewer.refresh();
        this.commonViewer.expandAll();
        this.selectFirstMatch();
        this.commonViewer.getControl().setRedraw(true);
    }

    private void selectFirstMatch() {
        Tree tree = this.commonViewer.getTree();
        Object element = this.findFirstMatchToPattern(tree.getItems());
        if (element != null) {
            this.commonViewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.commonViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findFirstMatchToPattern(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.commonViewer.getLabelProvider();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText(element))) {
                return element;
            }
            element = this.findFirstMatchToPattern(item.getItems());
            if (element != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

