/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.CheckActivityJob;
import org.eclipse.mylyn.internal.monitor.ui.IActivityManagerCallback;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractUserActivityMonitor;
import org.eclipse.mylyn.monitor.ui.IActivityContextManager;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityContextManager
implements IActivityContextManager {
    private AbstractUserActivityMonitor userActivityMonitor;
    private final Set<IUserAttentionListener> attentionListeners = new CopyOnWriteArraySet<IUserAttentionListener>();
    private final CheckActivityJob checkJob;
    private IWorkingSet[] workingSets;
    private final ArrayList<AbstractUserActivityMonitor> activityMonitors;
    public static final String ACTIVITY_TIMEOUT = "org.eclipse.mylyn.monitor.ui.activity.timeout";
    public static final String ACTIVITY_TIMEOUT_ENABLED = "org.eclipse.mylyn.monitor.ui.activity.timeout.enabled";
    private final IPropertyChangeListener WORKING_SET_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("workingSetContentChange".equals(event.getProperty())) {
                ActivityContextManager.this.updateWorkingSetSelection();
            }
        }
    };

    public ActivityContextManager(ArrayList<AbstractUserActivityMonitor> monitors) {
        this.activityMonitors = monitors;
        this.checkJob = new CheckActivityJob(new IActivityManagerCallback(){

            public void addMonitoredActivityTime(long localStartTime, long currentTime) {
                ActivityContextManager.this.addMonitoredActivityTime(localStartTime, currentTime);
            }

            public void fireInactive() {
                ActivityContextManager.this.fireInactive();
            }

            public long getLastEventTime() {
                return ActivityContextManager.this.getLastEventTime();
            }
        });
        this.checkJob.setSystem(true);
        this.checkJob.setPriority(10);
    }

    protected void updateWorkingSetSelection() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    ActivityContextManager.this.workingSets = page.getWorkingSets();
                }
            }
        });
    }

    public void start() {
        for (AbstractUserActivityMonitor monitor : this.activityMonitors) {
            monitor.start();
        }
        this.updateWorkingSetSelection();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.WORKING_SET_CHANGE_LISTENER);
        this.checkJob.reschedule();
    }

    public void stop() {
        for (AbstractUserActivityMonitor monitor : this.activityMonitors) {
            monitor.stop();
        }
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.WORKING_SET_CHANGE_LISTENER);
        this.checkJob.cancel();
    }

    public void addListener(IUserAttentionListener listener) {
        this.attentionListeners.add(listener);
    }

    public void removeListener(IUserAttentionListener listener) {
        this.attentionListeners.remove(listener);
    }

    private void addMonitoredActivityTime(long start, long end) {
        if (end > 0L && start > 0L && end > start) {
            String handle = this.getStructureHandle();
            if (handle == null) {
                if (this.workingSets != null && this.workingSets.length > 0) {
                    IWorkingSet[] iWorkingSetArray = this.workingSets;
                    int n = this.workingSets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkingSet workingSet = iWorkingSetArray[n2];
                        String workingSetName = workingSet.getName();
                        this.processWorkbenchEvent("org.eclipse.ui.workbench", "workingset", workingSetName, start, end);
                        ++n2;
                    }
                } else {
                    this.processWorkbenchEvent("org.eclipse.ui.workbench", "workingset", "none", start, end);
                }
            } else {
                this.processWorkbenchEvent("org.eclipse.ui.workbench", "timing", handle, start, end);
            }
            for (IUserAttentionListener attentionListener : this.attentionListeners) {
                attentionListener.userAttentionGained();
            }
        }
    }

    private void processWorkbenchEvent(String origin, String structureKind, String handle, long start, long end) {
        ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, structureKind, handle, origin, null, "added", 1.0f, new Date(start), new Date(end)));
    }

    public void addActivityTime(String handle, long start, long end) {
        if (handle != null) {
            ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", handle, "user", null, "added", 1.0f, new Date(start), new Date(end)));
        }
    }

    @Override
    public void removeActivityTime(String handle, long start, long end) {
        if (handle != null) {
            ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", handle, "user", null, "removed", 1.0f, new Date(start), new Date(end)));
        }
    }

    private void fireInactive() {
        for (IUserAttentionListener attentionListener : this.attentionListeners) {
            attentionListener.userAttentionLost();
        }
    }

    private long getLastEventTime() {
        for (AbstractUserActivityMonitor monitor : this.activityMonitors) {
            if (!monitor.isEnabled()) continue;
            this.userActivityMonitor = monitor;
            return this.userActivityMonitor.getLastInteractionTime();
        }
        return -1L;
    }

    @Override
    public void setInactivityTimeout(int inactivityTimeout) {
        this.checkJob.setInactivityTimeout(inactivityTimeout);
    }

    @Override
    public int getInactivityTimeout() {
        return this.checkJob.getInactivityTimeout();
    }

    public String getStructureHandle() {
        if (ContextCore.getContextManager().getActiveContext().getHandleIdentifier() != null) {
            return ContextCore.getContextManager().getActiveContext().getHandleIdentifier();
        }
        return null;
    }
}

