/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.resources.ui.ResourcesUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeMonitor
implements IResourceChangeListener {
    private boolean enabled = true;

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.enabled || !ContextCore.getContextManager().isContextActive()) {
            return;
        }
        if (event.getType() != 1) {
            return;
        }
        final HashSet<IResource> addedResources = new HashSet<IResource>();
        final HashSet<IResource> changedResources = new HashSet<IResource>();
        final Set<String> excludedPatterns = this.getExclusionPatterns();
        IResourceDelta rootDelta = event.getDelta();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResourceDelta[] changed;
                IResourceDelta[] added;
                if (ResourceChangeMonitor.this.isExcluded(delta.getResource().getProjectRelativePath(), delta.getResource(), excludedPatterns)) {
                    return false;
                }
                IResourceDelta[] iResourceDeltaArray = added = delta.getAffectedChildren(1);
                int n = added.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta element = iResourceDeltaArray[n2];
                    IResource resource = element.getResource();
                    if ((resource instanceof IFile || resource instanceof IFolder) && !ResourceChangeMonitor.this.isExcluded(resource.getProjectRelativePath(), resource, excludedPatterns)) {
                        addedResources.add(resource);
                    }
                    ++n2;
                }
                IResourceDelta[] iResourceDeltaArray2 = changed = delta.getAffectedChildren(6);
                int n3 = changed.length;
                n = 0;
                while (n < n3) {
                    IResourceDelta element = iResourceDeltaArray2[n];
                    IResource resource = element.getResource();
                    if (!(!(resource instanceof IFile) || ResourceChangeMonitor.this.isExcluded(resource.getProjectRelativePath(), resource, excludedPatterns) || "feature.xml".equals(resource.getName()) || element.getKind() == 4 && (element.getFlags() & 0x100) == 0)) {
                        changedResources.add(resource);
                    }
                    ++n;
                }
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
            ResourcesUi.addResourceToContext(changedResources, InteractionEvent.Kind.PREDICTION);
            ResourcesUi.addResourceToContext(addedResources, InteractionEvent.Kind.PROPAGATION);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not accept marker visitor", (Throwable)e));
        }
    }

    private Set<String> getExclusionPatterns() {
        Set<String> excludedResourcePatterns = ResourcesUiPreferenceInitializer.getExcludedResourcePatterns();
        excludedResourcePatterns.addAll(ResourcesUiPreferenceInitializer.getForcedExcludedResourcePatterns());
        HashSet<String> excludedPatterns = new HashSet<String>();
        for (String pattern : excludedResourcePatterns) {
            if (pattern == null || pattern.length() <= 0) continue;
            pattern = this.createRegexFromPattern(pattern);
            excludedPatterns.add(pattern);
        }
        return excludedPatterns;
    }

    public String createRegexFromPattern(String pattern) {
        pattern = pattern.replaceAll("\\.", "\\\\.");
        pattern = pattern.replaceAll("\\*", ".*");
        return pattern;
    }

    public boolean isExcluded(IPath path, IResource resource, Set<String> excludedPatterns) {
        if (resource != null && resource.isDerived()) {
            return true;
        }
        boolean excluded = false;
        for (String pattern : excludedPatterns) {
            if (resource != null && pattern.startsWith("file:/")) {
                excluded |= this.isUriExcluded(resource.getLocationURI().toString(), pattern);
            } else {
                String[] stringArray = path.segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if (excluded |= segment.matches(pattern)) break;
                    ++n2;
                }
            }
            if (excluded) break;
        }
        return excluded;
    }

    public boolean isUriExcluded(String uri, String pattern) {
        return uri != null && uri.startsWith(pattern);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

