/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.LegacyTaskDataCollector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeQueriesJob
extends SynchronizationJob {
    public static final String MAX_HITS_REACHED = "Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.";
    private final AbstractRepositoryConnector connector;
    private final Set<RepositoryQuery> queries;
    private final TaskRepository repository;
    private final TaskDataManager taskDataManager;
    private final TaskList taskList;
    private final IRepositoryModel tasksModel;
    private final List<IStatus> statuses;

    public SynchronizeQueriesJob(TaskList taskList, TaskDataManager taskDataManager, IRepositoryModel tasksModel, AbstractRepositoryConnector connector, TaskRepository repository, Set<RepositoryQuery> queries) {
        super("Synchronizing Queries (" + repository.getRepositoryLabel() + ")");
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.tasksModel = tasksModel;
        this.connector = connector;
        this.repository = repository;
        this.queries = queries;
        this.statuses = new ArrayList<IStatus>();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public IStatus run(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("Processing", 20 + this.queries.size() * 20 + 40 + 10);
                if (!this.isFullSynchronization()) {
                    allTasks = new HashSet<E>();
                    for (RepositoryQuery query : this.queries) {
                        allTasks.addAll(query.getChildren());
                    }
                } else {
                    allTasks = this.taskList.getTasks(this.repository.getRepositoryUrl());
                }
                rule = new MutexRule((Object)this.repository);
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)rule, monitor);
                    relationsByTaskId = new HashMap<String, TaskRelation[]>();
                    session = new SynchronizationSession(this.taskDataManager){

                        public void putTaskData(ITask task, TaskData taskData) throws CoreException {
                            boolean changed = SynchronizeQueriesJob.this.connector.hasTaskChanged(SynchronizeQueriesJob.this.repository, task, taskData);
                            SynchronizeQueriesJob.this.taskDataManager.putUpdatedTaskData(task, taskData, this.isUser(), this);
                            if (taskData.isPartial()) {
                                if (changed && SynchronizeQueriesJob.this.connector.canSynchronizeTask(SynchronizeQueriesJob.this.repository, task)) {
                                    this.markStale(task);
                                }
                            } else {
                                Collection<TaskRelation> relations = SynchronizeQueriesJob.this.connector.getTaskRelations(taskData);
                                if (relations != null) {
                                    relationsByTaskId.put(task.getTaskId(), relations.toArray(new TaskRelation[0]));
                                }
                            }
                        }
                    };
                    session.setTaskRepository(this.repository);
                    session.setFullSynchronization(this.isFullSynchronization());
                    session.setTasks(Collections.unmodifiableSet(allTasks));
                    session.setNeedsPerformQueries(true);
                    session.setUser(this.isUser());
                    this.updateQueryStatus(null);
                    try {
                        success = this.preSynchronization(session, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        if (success && session.needsPerformQueries() || this.isUser()) {
                            this.synchronizeQueries(monitor, session);
                        }
                        monitor.worked(this.queries.size() * 20);
                    }
                    finally {
                        ** for (repositoryQuery : this.queries)
                    }
lbl-1000:
                    // 1 sources

                    {
                        repositoryQuery.setSynchronizing(false);
                        continue;
                    }
lbl34:
                    // 1 sources

                    this.taskList.notifySynchronizationStateChanged(this.queries);
                    tasksToBeSynchronized = new HashSet<ITask>();
                    if (session.getStaleTasks() != null) {
                        for (ITask task : session.getStaleTasks()) {
                            tasksToBeSynchronized.add(task);
                            ((AbstractTask)task).setSynchronizing(true);
                        }
                    }
                    job = new SynchronizeTasksJob((ITaskList)this.taskList, this.taskDataManager, this.tasksModel, this.connector, this.repository, tasksToBeSynchronized);
                    job.setUser(this.isUser());
                    job.setSession(session);
                    if (!tasksToBeSynchronized.isEmpty()) {
                        Policy.checkCanceled((IProgressMonitor)monitor);
                        result = job.run((IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        if (result == Status.CANCEL_STATUS) {
                            throw new OperationCanceledException();
                        }
                        this.statuses.addAll(job.getStatuses());
                    }
                    monitor.subTask("Receiving related tasks");
                    job.synchronizedTaskRelations(monitor, relationsByTaskId);
                    monitor.worked(10);
                    session.setChangedTasks(tasksToBeSynchronized);
                    if (this.statuses.size() > 0) {
                        status = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, this.statuses.toArray(new IStatus[0]), "Query synchronization failed", null);
                        session.setStatus((IStatus)status);
                    }
                    this.postSynchronization(session, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
            }
            catch (OperationCanceledException v0) {
                var12_16 = Status.CANCEL_STATUS;
                monitor.done();
                return var12_16;
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Synchronization failed", (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void synchronizeQueries(IProgressMonitor monitor, SynchronizationSession session) {
        for (RepositoryQuery repositoryQuery : this.queries) {
            Policy.checkCanceled((IProgressMonitor)monitor);
            monitor.subTask("Synchronizing query " + repositoryQuery.getSummary());
            this.synchronizeQuery(repositoryQuery, session, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
        }
    }

    private boolean postSynchronization(SynchronizationSession event, IProgressMonitor monitor) {
        try {
            Policy.checkCanceled((IProgressMonitor)monitor);
            monitor.subTask("Updating repository state");
            if (!this.isUser()) {
                monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
            }
            this.connector.postSynchronization(event, monitor);
            return true;
        }
        catch (CoreException e) {
            this.updateQueryStatus(e.getStatus());
            return false;
        }
    }

    private boolean preSynchronization(ISynchronizationSession event, IProgressMonitor monitor) {
        try {
            Policy.checkCanceled((IProgressMonitor)monitor);
            monitor.subTask("Querying repository");
            if (!this.isUser()) {
                monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
            }
            this.connector.preSynchronization(event, monitor);
            return true;
        }
        catch (CoreException e) {
            this.updateQueryStatus(e.getStatus());
            this.statuses.add(e.getStatus());
            return false;
        }
    }

    private void synchronizeQuery(RepositoryQuery repositoryQuery, SynchronizationSession event, IProgressMonitor monitor) {
        IStatus result;
        TaskCollector collector = new TaskCollector(repositoryQuery, event);
        if (!this.isUser()) {
            monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
        }
        if ((result = this.connector.performQuery(this.repository, repositoryQuery, collector, event, monitor)) == null || result.isOK()) {
            Set<ITask> removedChildren;
            if (collector.getResultCount() >= 5000) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.\n" + repositoryQuery.getSummary()));
            }
            if (!(removedChildren = collector.getRemovedChildren()).isEmpty()) {
                this.taskList.removeFromContainer((AbstractTaskContainer)repositoryQuery, removedChildren);
            }
            repositoryQuery.setLastSynchronizedStamp(new SimpleDateFormat("MMM d, H:mm:ss").format(new Date()));
        } else {
            if (result.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            repositoryQuery.setStatus(result);
            this.statuses.add(result);
        }
    }

    private void updateQueryStatus(IStatus status) {
        for (RepositoryQuery repositoryQuery : this.queries) {
            repositoryQuery.setStatus(status);
        }
        this.taskList.notifySynchronizationStateChanged(this.queries);
    }

    public Collection<IStatus> getStatuses() {
        return Collections.unmodifiableCollection(this.statuses);
    }

    private static class MutexRule
    implements ISchedulingRule {
        private final Object object;

        public MutexRule(Object object) {
            this.object = object;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof MutexRule) {
                return this.object.equals(((MutexRule)rule).object);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskCollector
    extends LegacyTaskDataCollector {
        private final Set<ITask> removedQueryResults;
        private final RepositoryQuery repositoryQuery;
        private int resultCount;
        private final SynchronizationSession session;

        public TaskCollector(RepositoryQuery repositoryQuery, SynchronizationSession session) {
            this.repositoryQuery = repositoryQuery;
            this.session = session;
            this.removedQueryResults = new HashSet<ITask>(repositoryQuery.getChildren());
        }

        @Override
        public void accept(TaskData taskData) {
            ITask task = SynchronizeQueriesJob.this.taskList.getTask(taskData.getRepositoryUrl(), taskData.getTaskId());
            if (task == null) {
                task = SynchronizeQueriesJob.this.tasksModel.createTask(SynchronizeQueriesJob.this.repository, taskData.getTaskId());
                if (taskData.isPartial() && SynchronizeQueriesJob.this.connector.canSynchronizeTask(SynchronizeQueriesJob.this.repository, task)) {
                    this.session.markStale(task);
                }
            } else {
                this.removedQueryResults.remove(task);
            }
            try {
                this.session.putTaskData(task, taskData);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to save task", (Throwable)e));
            }
            SynchronizeQueriesJob.this.taskList.addTask(task, this.repositoryQuery);
            ++this.resultCount;
        }

        @Override
        @Deprecated
        public void accept(RepositoryTaskData taskData) {
            boolean changed;
            AbstractTask task = (AbstractTask)SynchronizeQueriesJob.this.taskList.getTask(taskData.getRepositoryUrl(), taskData.getTaskId());
            if (task == null) {
                task = ((AbstractLegacyRepositoryConnector)SynchronizeQueriesJob.this.connector).createTask(taskData.getRepositoryUrl(), taskData.getTaskId(), "");
                task.setStale(true);
                changed = ((AbstractLegacyRepositoryConnector)SynchronizeQueriesJob.this.connector).updateTaskFromTaskData(SynchronizeQueriesJob.this.repository, (ITask)task, taskData);
            } else {
                changed = ((AbstractLegacyRepositoryConnector)SynchronizeQueriesJob.this.connector).updateTaskFromTaskData(SynchronizeQueriesJob.this.repository, (ITask)task, taskData);
                this.removedQueryResults.remove(task);
            }
            SynchronizeQueriesJob.this.taskList.addTask(task, this.repositoryQuery);
            if (!taskData.isPartial()) {
                SynchronizeQueriesJob.this.taskDataManager.saveIncoming(task, taskData, SynchronizeQueriesJob.this.isUser());
            } else if (changed && !task.isStale() && task.getSynchronizationState() == ITask.SynchronizationState.SYNCHRONIZED) {
                task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
            }
            if (task.isStale()) {
                this.session.markStale(task);
                task.setSynchronizing(true);
            }
            ++this.resultCount;
        }

        public Set<ITask> getRemovedChildren() {
            return this.removedQueryResults;
        }

        public int getResultCount() {
            return this.resultCount;
        }
    }
}

