/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.OpenRepositoryTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.PlatformUI;

public class AddExistingTaskJob
extends Job {
    private final TaskRepository repository;
    private final String taskId;
    private final AbstractTaskCategory taskContainer;

    public AddExistingTaskJob(TaskRepository repository, String taskId) {
        this(repository, taskId, null);
    }

    public AddExistingTaskJob(TaskRepository repository, String taskId, AbstractTaskCategory taskContainer) {
        super(MessageFormat.format("Adding task: \"{0}\"...", taskId));
        this.repository = repository;
        this.taskId = taskId;
        this.taskContainer = taskContainer;
    }

    public IStatus run(IProgressMonitor monitor) {
        OpenRepositoryTaskJob job = new OpenRepositoryTaskJob(this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), this.taskId, null, null);
        IStatus result = job.run(monitor);
        final ITask newTask = job.getTask();
        if (newTask != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Object selectedObject;
                    AbstractTaskCategory category = AddExistingTaskJob.this.taskContainer;
                    TaskListView taskListView = TaskListView.getFromActivePerspective();
                    if (category == null && (selectedObject = ((IStructuredSelection)taskListView.getViewer().getSelection()).getFirstElement()) instanceof TaskCategory) {
                        category = (TaskCategory)selectedObject;
                    }
                    TasksUiInternal.getTaskList().addTask(newTask, (AbstractTaskContainer)category);
                    taskListView.getViewer().setSelection((ISelection)new StructuredSelection((Object)newTask));
                }
            });
        }
        return result;
    }
}

