/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.tasks.core.ITaskDataStorage;
import org.eclipse.mylyn.internal.tasks.core.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttributeFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryAttachment;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryOperation;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskAttribute;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskComment;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OfflineFileStorage
implements ITaskDataStorage {
    private static final String ATTRIBUTE_TASK_KIND = "taskKind";
    private static final String ATTRIBUTE_IS_PATCH = "isPatch";
    private static final String ATTRIBUTE_IS_OBSOLETE = "isObsolete";
    private static final String ATTRIBUTE_CREATOR = "creator";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_HAS_ATTACHMENT = "hasAttachment";
    private static final String ATTRIBUTE_ATTACHMENT_ID = "attachmentId";
    private static final String ATTRIBUTE_KNOB_NAME = "knob_name";
    private static final String ATTRIBUTE_OPERATION_NAME = "operationName";
    private static final String ATTRIBUTE_OPTION_NAME = "optionName";
    private static final String ATTRIBUTE_OPTION_SELECTION = "optionSelection";
    private static final String ATTRIBUTE_IS_CHECKED = "isChecked";
    private static final String ATTRIBUTE_INPUT_NAME = "inputName";
    private static final String ATTRIBUTE_INPUT_VALUE = "inputValue";
    private static final String ATTRIBUTE_READONLY = "readonly";
    private static final String ATTRIBUTE_HIDDEN = "hidden";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ELEMENT_META_DATA = "MetaData";
    private static final String ELEMENT_META = "meta";
    private static final String ELEMENT_OPTION = "option";
    private static final String ELEMENT_OPTIONS = "options";
    private static final String ELEMENT_VALUES = "values";
    private static final String ELEMENT_VALUE = "value";
    private static final String ELEMENT_ATTRIBUTE = "Attribute";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_OPTION_NAMES = "optionNames";
    private static final String ELEMENT_OPERATION = "Operation";
    private static final String ELEMENT_SELECTED = "Selected";
    private static final String ELEMENT_COMMENT = "Comment";
    private static final String ELEMENT_ATTACHMENT = "Attachment";
    private static final String ELEMENT_ATTACHMENTS = "Attachments";
    private static final String ELEMENT_COMMENTS = "Comments";
    private static final String ELEMENT_OPERATIONS = "Operations";
    private static final String ELEMENT_ATTRIBUTES = "Attributes";
    private static final String ATTRIBUTE_REPOSITORY_KIND = "repositoryKind";
    private static final String ATTRIBUTE_REPOSITORY_URL = "repositoryUrl";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String FILE_NAME_INTERNAL = "data.xml";
    private static final String ELEMENT_EDITS_DATA = "EditsData";
    private static final String ELEMENT_OLD_DATA = "OldData";
    private static final String ELEMENT_NEW_DATA = "NewData";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ELEMENT_TASK_STATE = "TaskState";
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String SCHEMA_VERSION = "1.0";
    private static final String EXTENSION = ".zip";
    private final File dataDir;
    private static final AbstractAttributeFactory temporaryFactory = new AbstractAttributeFactory(){
        private static final long serialVersionUID = 1L;

        public Date getDateForAttributeType(String attributeKey, String dateString) {
            return null;
        }

        public boolean isHidden(String key) {
            return false;
        }

        public String getName(String key) {
            return key;
        }

        public boolean isReadOnly(String key) {
            return false;
        }

        public String mapCommonAttributeKey(String key) {
            return key;
        }
    };

    public OfflineFileStorage(File rootFolder) {
        this.dataDir = rootFolder;
    }

    public void start() throws Exception {
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
    }

    public void stop() throws Exception {
    }

    public synchronized TaskDataState get(String repositoryUrl, String id) {
        TaskDataState state = null;
        FileInputStream fileInputStream = null;
        FileLock lock = null;
        try {
            try {
                FileChannel channel;
                File dataFile = this.getDataFile(URLEncoder.encode(repositoryUrl, ENCODING_UTF_8), id);
                if (dataFile != null && dataFile.exists() && (lock = (channel = (fileInputStream = new FileInputStream(dataFile)).getChannel()).tryLock(0L, Long.MAX_VALUE, true)) != null) {
                    XMLMemento input;
                    state = new TaskDataState(repositoryUrl, id);
                    ZipInputStream inputStream = new ZipInputStream(fileInputStream);
                    ZipEntry entry = inputStream.getNextEntry();
                    if (entry != null && (input = XMLMemento.createReadRoot((Reader)new InputStreamReader((InputStream)inputStream, ENCODING_UTF_8))) != null) {
                        this.readData(state, input);
                    }
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error retrieving offline data", (Throwable)e));
                try {
                    if (lock != null && lock.isValid()) {
                        lock.release();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e2) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error closing offline data input stream", (Throwable)e2));
                }
            }
        }
        finally {
            try {
                if (lock != null && lock.isValid()) {
                    lock.release();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error closing offline data input stream", (Throwable)e));
            }
        }
        return state;
    }

    public synchronized void put(TaskDataState taskDataState) {
        block23: {
            OutputStream fileOutputStream = null;
            FileLock lock = null;
            try {
                try {
                    String repositoryFolder = URLEncoder.encode(taskDataState.getNewTaskData().getRepositoryUrl(), ENCODING_UTF_8);
                    File dataFile = this.getDataFile(repositoryFolder, taskDataState.getId());
                    if (dataFile != null) {
                        if (!dataFile.getParentFile().exists() && !dataFile.getParentFile().mkdirs()) {
                            throw new IOException("Could not create offline data folder: " + dataFile.getParentFile().getAbsolutePath());
                        }
                        fileOutputStream = new FileOutputStream(dataFile);
                        FileChannel channel = ((FileOutputStream)fileOutputStream).getChannel();
                        lock = channel.tryLock();
                        if (lock != null) {
                            IMemento child;
                            ZipOutputStream outputStream = new ZipOutputStream(fileOutputStream);
                            outputStream.setMethod(8);
                            ZipEntry zipEntry = new ZipEntry(FILE_NAME_INTERNAL);
                            outputStream.putNextEntry(zipEntry);
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, ENCODING_UTF_8);
                            XMLMemento memento = XMLMemento.createWriteRoot((String)ELEMENT_TASK_STATE);
                            memento.putString(ATTRIBUTE_VERSION, SCHEMA_VERSION);
                            if (taskDataState.getNewTaskData() != null) {
                                child = memento.createChild(ELEMENT_NEW_DATA);
                                this.addTaskData(child, taskDataState.getNewTaskData());
                            }
                            if (taskDataState.getOldTaskData() != null) {
                                child = memento.createChild(ELEMENT_OLD_DATA);
                                this.addTaskData(child, taskDataState.getOldTaskData());
                            }
                            if (taskDataState.getEdits() != null && taskDataState.getEdits().size() > 0) {
                                child = memento.createChild(ELEMENT_EDITS_DATA);
                                this.addEdits(child, taskDataState.getEdits());
                            }
                            memento.save((Writer)writer);
                        }
                    }
                }
                catch (Exception exception) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error saving offline data"));
                    try {
                        if (lock != null && lock.isValid()) {
                            lock.release();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.flush();
                            ((FileOutputStream)fileOutputStream).close();
                        }
                        break block23;
                    }
                    catch (IOException iOException) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error closing offline data output stream"));
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null && lock.isValid()) {
                        lock.release();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.flush();
                        ((FileOutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error closing offline data output stream"));
                }
                throw throwable;
            }
            try {
                if (lock != null && lock.isValid()) {
                    lock.release();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    ((FileOutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error closing offline data output stream"));
            }
        }
    }

    private void readData(TaskDataState taskState, XMLMemento parent) {
        Set<RepositoryTaskAttribute> edits;
        IMemento editsData;
        RepositoryTaskData oldTaskData;
        IMemento oldData;
        RepositoryTaskData newTaskData;
        IMemento newData = parent.getChild(ELEMENT_NEW_DATA);
        if (newData != null && (newTaskData = this.readTaskData(newData)) != null) {
            taskState.setNewTaskData(newTaskData);
        }
        if ((oldData = parent.getChild(ELEMENT_OLD_DATA)) != null && (oldTaskData = this.readTaskData(oldData)) != null) {
            taskState.setOldTaskData(oldTaskData);
        }
        if ((editsData = parent.getChild(ELEMENT_EDITS_DATA)) != null && (edits = this.readEdits(editsData)) != null) {
            taskState.setEdits(edits);
        }
    }

    private RepositoryTaskData readTaskData(IMemento newData) {
        IMemento attachmentsMemento;
        IMemento commentsMemento;
        IMemento opsMemento;
        String kind = newData.getString(ATTRIBUTE_REPOSITORY_KIND);
        String id = newData.getString(ATTRIBUTE_ID);
        String url = newData.getString(ATTRIBUTE_REPOSITORY_URL);
        String taskKind = newData.getString(ATTRIBUTE_TASK_KIND);
        if (kind == null || url == null || id == null) {
            return null;
        }
        RepositoryTaskData data = new RepositoryTaskData(temporaryFactory, kind, url, id, taskKind);
        IMemento attMemento = newData.getChild(ELEMENT_ATTRIBUTES);
        if (attMemento != null) {
            List<RepositoryTaskAttribute> attributes = this.readAttributes(attMemento);
            for (RepositoryTaskAttribute repositoryTaskAttribute : attributes) {
                data.addAttribute(repositoryTaskAttribute.getId(), repositoryTaskAttribute);
            }
        }
        if ((opsMemento = newData.getChild(ELEMENT_OPERATIONS)) != null) {
            List<RepositoryOperation> operations = this.readOperations(opsMemento);
            for (RepositoryOperation operation : operations) {
                data.addOperation(operation);
            }
        }
        if ((commentsMemento = newData.getChild(ELEMENT_COMMENTS)) != null) {
            List<TaskComment> comments = this.readComments(commentsMemento);
            for (TaskComment comment : comments) {
                data.addComment(comment);
            }
        }
        if ((attachmentsMemento = newData.getChild(ELEMENT_ATTACHMENTS)) != null) {
            List<RepositoryAttachment> attachments = this.readAttachments(attachmentsMemento);
            for (RepositoryAttachment attachment : attachments) {
                data.addAttachment(attachment);
            }
        }
        return data;
    }

    private void addEdits(IMemento parent, Set<RepositoryTaskAttribute> edits) {
        ArrayList<RepositoryTaskAttribute> changedAttributes = new ArrayList<RepositoryTaskAttribute>();
        changedAttributes.addAll(edits);
        this.addAttributes(parent, changedAttributes);
    }

    private Set<RepositoryTaskAttribute> readEdits(IMemento parent) {
        return new HashSet<RepositoryTaskAttribute>(this.readAttributes(parent));
    }

    private void addTaskData(IMemento parent, RepositoryTaskData newTaskData) {
        parent.putString(ATTRIBUTE_ID, this.getCleanText(newTaskData.getTaskId()));
        parent.putString(ATTRIBUTE_TASK_KIND, this.getCleanText(newTaskData.getTaskKind()));
        parent.putString(ATTRIBUTE_REPOSITORY_URL, this.getCleanText(newTaskData.getRepositoryUrl()));
        parent.putString(ATTRIBUTE_REPOSITORY_KIND, this.getCleanText(newTaskData.getConnectorKind()));
        IMemento attributes = parent.createChild(ELEMENT_ATTRIBUTES);
        this.addAttributes(attributes, newTaskData.getAttributes());
        IMemento operations = parent.createChild(ELEMENT_OPERATIONS);
        this.addOperations(operations, newTaskData.getOperations());
        if (newTaskData.getSelectedOperation() != null) {
            this.addSelectedOperation(operations, newTaskData.getSelectedOperation());
        }
        IMemento comments = parent.createChild(ELEMENT_COMMENTS);
        this.addComments(comments, newTaskData.getComments());
        IMemento attachments = parent.createChild(ELEMENT_ATTACHMENTS);
        this.addAttachments(attachments, newTaskData.getAttachments());
    }

    public void addAttachments(IMemento parent, List<RepositoryAttachment> attachments) {
        for (RepositoryAttachment attachment : attachments) {
            IMemento memento = parent.createChild(ELEMENT_ATTACHMENT);
            memento.putString(ATTRIBUTE_IS_PATCH, String.valueOf(attachment.isPatch()));
            memento.putString(ATTRIBUTE_IS_OBSOLETE, String.valueOf(attachment.isObsolete()));
            memento.putString(ATTRIBUTE_CREATOR, this.getCleanText(attachment.getCreator()));
            memento.putString(ATTRIBUTE_ID, this.getCleanText(attachment.getTaskId()));
            memento.putString(ATTRIBUTE_REPOSITORY_KIND, this.getCleanText(attachment.getRepositoryKind()));
            memento.putString(ATTRIBUTE_REPOSITORY_URL, this.getCleanText(attachment.getRepositoryUrl()));
            IMemento attributes = memento.createChild(ELEMENT_ATTRIBUTES);
            this.addAttributes(attributes, attachment.getAttributes());
        }
    }

    public List<RepositoryAttachment> readAttachments(IMemento parent) {
        ArrayList<RepositoryAttachment> attachments = new ArrayList<RepositoryAttachment>();
        IMemento[] iMementoArray = parent.getChildren(ELEMENT_ATTACHMENT);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento attributesMemento;
            IMemento attachmentMemento = iMementoArray[n2];
            RepositoryAttachment attachment = new RepositoryAttachment(temporaryFactory);
            String isPatch = attachmentMemento.getString(ATTRIBUTE_IS_PATCH);
            String isObsolete = attachmentMemento.getString(ATTRIBUTE_IS_OBSOLETE);
            String taskId = attachmentMemento.getString(ATTRIBUTE_ID);
            String creator = attachmentMemento.getString(ATTRIBUTE_CREATOR);
            String repositoryKind = attachmentMemento.getString(ATTRIBUTE_REPOSITORY_KIND);
            String repositoryUrl = attachmentMemento.getString(ATTRIBUTE_REPOSITORY_URL);
            if (isPatch != null) {
                attachment.setPatch(Boolean.parseBoolean(isPatch));
            }
            if (isObsolete != null) {
                attachment.setObsolete(Boolean.parseBoolean(isObsolete));
            }
            if (creator != null) {
                attachment.setCreator(creator);
            }
            if (repositoryKind != null) {
                attachment.setRepositoryKind(repositoryKind);
            }
            if (repositoryUrl != null) {
                attachment.setRepositoryUrl(repositoryUrl);
            }
            if (taskId != null) {
                attachment.setTaskId(taskId);
            }
            if ((attributesMemento = attachmentMemento.getChild(ELEMENT_ATTRIBUTES)) != null) {
                List<RepositoryTaskAttribute> attributes = this.readAttributes(attributesMemento);
                for (RepositoryTaskAttribute repositoryTaskAttribute : attributes) {
                    attachment.addAttribute(repositoryTaskAttribute.getId(), repositoryTaskAttribute);
                }
            }
            attachments.add(attachment);
            ++n2;
        }
        return attachments;
    }

    public void addComments(IMemento parent, List<TaskComment> comments) {
        for (TaskComment taskComment : comments) {
            IMemento comment = parent.createChild(ELEMENT_COMMENT);
            comment.putInteger(ATTRIBUTE_NUMBER, taskComment.getNumber());
            comment.putString(ATTRIBUTE_HAS_ATTACHMENT, String.valueOf(taskComment.hasAttachment()));
            comment.putString(ATTRIBUTE_ATTACHMENT_ID, this.getCleanText(taskComment.getAttachmentId()));
            IMemento attributes = comment.createChild(ELEMENT_ATTRIBUTES);
            this.addAttributes(attributes, taskComment.getAttributes());
        }
    }

    public List<TaskComment> readComments(IMemento parent) {
        ArrayList<TaskComment> comments = new ArrayList<TaskComment>();
        IMemento[] iMementoArray = parent.getChildren(ELEMENT_COMMENT);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento commentMemento = iMementoArray[n2];
            Integer commentNumber = commentMemento.getInteger(ATTRIBUTE_NUMBER);
            String hasAttachment = commentMemento.getString(ATTRIBUTE_HAS_ATTACHMENT);
            String attachmentId = commentMemento.getString(ATTRIBUTE_ATTACHMENT_ID);
            if (commentNumber != null) {
                IMemento attributesMemento;
                TaskComment comment = new TaskComment(temporaryFactory, commentNumber.intValue());
                if (hasAttachment != null) {
                    comment.setHasAttachment(Boolean.parseBoolean(hasAttachment));
                }
                if (attachmentId != null) {
                    comment.setAttachmentId(attachmentId);
                }
                if ((attributesMemento = commentMemento.getChild(ELEMENT_ATTRIBUTES)) != null) {
                    List<RepositoryTaskAttribute> attributes = this.readAttributes(attributesMemento);
                    for (RepositoryTaskAttribute repositoryTaskAttribute : attributes) {
                        comment.addAttribute(repositoryTaskAttribute.getId(), repositoryTaskAttribute);
                    }
                }
                comments.add(comment);
            }
            ++n2;
        }
        return comments;
    }

    private void addSelectedOperation(IMemento operations, RepositoryOperation selectedOperation) {
        IMemento selected = operations.createChild(ELEMENT_SELECTED);
        ArrayList<RepositoryOperation> list = new ArrayList<RepositoryOperation>();
        list.add(selectedOperation);
        this.addOperations(selected, list);
    }

    public void addOperations(IMemento parent, List<RepositoryOperation> operations) {
        for (RepositoryOperation operation : operations) {
            IMemento operationMemento = parent.createChild(ELEMENT_OPERATION);
            operationMemento.putString(ATTRIBUTE_KNOB_NAME, this.getCleanText(operation.getKnobName()));
            operationMemento.putString(ATTRIBUTE_OPERATION_NAME, this.getCleanText(operation.getOperationName()));
            operationMemento.putString(ATTRIBUTE_IS_CHECKED, String.valueOf(operation.isChecked()));
            if (operation.isInput()) {
                operationMemento.putString(ATTRIBUTE_INPUT_NAME, this.getCleanText(operation.getInputName()));
                operationMemento.putString(ATTRIBUTE_INPUT_VALUE, this.getCleanText(operation.getInputValue()));
            }
            if (!operation.hasOptions()) continue;
            operationMemento.putString(ATTRIBUTE_OPTION_NAME, this.getCleanText(operation.getOptionName()));
            operationMemento.putString(ATTRIBUTE_OPTION_SELECTION, this.getCleanText(operation.getOptionSelection()));
            if (operation.getOptionNames() == null || operation.getOptionNames().size() <= 0) continue;
            IMemento optionNames = operationMemento.createChild(ELEMENT_OPTION_NAMES);
            for (String name : operation.getOptionNames()) {
                IMemento nameMemento = optionNames.createChild("name");
                nameMemento.putTextData(this.getCleanText(name));
                nameMemento.putString("value", this.getCleanText(operation.getOptionValue(name)));
            }
        }
    }

    public List<RepositoryOperation> readOperations(IMemento parent) {
        ArrayList<RepositoryOperation> operations = new ArrayList<RepositoryOperation>();
        IMemento[] iMementoArray = parent.getChildren(ELEMENT_OPERATION);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento operationMemento = iMementoArray[n2];
            String knobName = operationMemento.getString(ATTRIBUTE_KNOB_NAME);
            String operationName = operationMemento.getString(ATTRIBUTE_OPERATION_NAME);
            String optionName = operationMemento.getString(ATTRIBUTE_OPTION_NAME);
            String selection = operationMemento.getString(ATTRIBUTE_OPTION_SELECTION);
            String isChecked = operationMemento.getString(ATTRIBUTE_IS_CHECKED);
            String inputName = operationMemento.getString(ATTRIBUTE_INPUT_NAME);
            String inputValue = operationMemento.getString(ATTRIBUTE_INPUT_VALUE);
            if (knobName != null && operationName != null) {
                IMemento optionNames;
                RepositoryOperation op = new RepositoryOperation(knobName, operationName);
                if (optionName != null) {
                    op.setUpOptions(optionName);
                }
                if (isChecked != null) {
                    op.setChecked(Boolean.parseBoolean(isChecked));
                }
                if (inputName != null) {
                    op.setInputName(inputName);
                }
                if (inputValue != null) {
                    op.setInputValue(inputValue);
                }
                if ((optionNames = operationMemento.getChild(ELEMENT_OPTION_NAMES)) != null) {
                    IMemento[] iMementoArray2 = optionNames.getChildren("name");
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento nameMemento = iMementoArray2[n4];
                        if (nameMemento.getTextData() != null && nameMemento.getTextData().length() > 0) {
                            op.addOption(nameMemento.getTextData(), nameMemento.getString("value"));
                        }
                        ++n4;
                    }
                }
                if (selection != null) {
                    op.setOptionSelection(selection);
                }
                operations.add(op);
            }
            ++n2;
        }
        return operations;
    }

    public void addAttributes(IMemento parent, List<RepositoryTaskAttribute> attributes) {
        for (RepositoryTaskAttribute attribute : attributes) {
            IMemento attribMemento = parent.createChild(ELEMENT_ATTRIBUTE);
            attribMemento.putString(ATTRIBUTE_ID, this.getCleanText(attribute.getId()));
            attribMemento.putString("name", this.getCleanText(attribute.getName()));
            attribMemento.putString(ATTRIBUTE_HIDDEN, String.valueOf(attribute.isHidden()));
            attribMemento.putString(ATTRIBUTE_READONLY, String.valueOf(attribute.isReadOnly()));
            IMemento values = attribMemento.createChild(ELEMENT_VALUES);
            for (String value : attribute.getValues()) {
                values.createChild("value").putTextData(this.getCleanText(value));
            }
            IMemento options = attribMemento.createChild(ELEMENT_OPTIONS);
            for (String optionValue : attribute.getOptions()) {
                IMemento option = options.createChild(ELEMENT_OPTION);
                option.putTextData(this.getCleanText(optionValue));
                String parameter = attribute.getOptionParameter(optionValue);
                if (parameter == null) continue;
                option.putString(ATTRIBUTE_PARAMETER, this.getCleanText(parameter));
            }
            IMemento metaData = attribMemento.createChild(ELEMENT_META_DATA);
            Map metadata = attribute.getMetaData();
            if (metadata == null || metadata.size() <= 0) continue;
            for (String key : metadata.keySet()) {
                IMemento meta = metaData.createChild(ELEMENT_META);
                meta.putString(ATTRIBUTE_KEY, this.getCleanText(key));
                meta.putTextData(this.getCleanText((String)metadata.get(key)));
            }
        }
    }

    private String getCleanText(String text) {
        if (text == null) {
            return "";
        }
        String result = XmlStringConverter.cleanXmlString((String)text);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public List<RepositoryTaskAttribute> readAttributes(IMemento parent) {
        ArrayList<RepositoryTaskAttribute> attributes = new ArrayList<RepositoryTaskAttribute>();
        IMemento[] iMementoArray = parent.getChildren(ELEMENT_ATTRIBUTE);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento attrMemento = iMementoArray[n2];
            String id = attrMemento.getString(ATTRIBUTE_ID);
            String name = attrMemento.getString("name");
            String hidden = attrMemento.getString(ATTRIBUTE_HIDDEN);
            if (id != null && name != null && hidden != null) {
                IMemento metaData;
                IMemento options;
                int n3;
                IMemento values;
                RepositoryTaskAttribute attribute = new RepositoryTaskAttribute(id, name, Boolean.parseBoolean(hidden));
                attributes.add(attribute);
                String readOnly = attrMemento.getString(ATTRIBUTE_READONLY);
                if (readOnly != null) {
                    attribute.setReadOnly(Boolean.parseBoolean(readOnly));
                }
                if ((values = attrMemento.getChild(ELEMENT_VALUES)) != null) {
                    IMemento[] iMementoArray2 = values.getChildren("value");
                    n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento valueMemento = iMementoArray2[n4];
                        attribute.addValue(this.getCleanText(valueMemento.getTextData()));
                        ++n4;
                    }
                }
                if ((options = attrMemento.getChild(ELEMENT_OPTIONS)) != null) {
                    IMemento[] iMementoArray3 = options.getChildren(ELEMENT_OPTION);
                    int n5 = iMementoArray3.length;
                    n3 = 0;
                    while (n3 < n5) {
                        IMemento optionMemento = iMementoArray3[n3];
                        attribute.addOption(this.getCleanText(optionMemento.getTextData()), optionMemento.getString(ATTRIBUTE_PARAMETER));
                        ++n3;
                    }
                }
                if ((metaData = attrMemento.getChild(ELEMENT_META_DATA)) != null) {
                    IMemento[] iMementoArray4 = metaData.getChildren(ELEMENT_META);
                    int n6 = iMementoArray4.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        IMemento optionMemento = iMementoArray4[n7];
                        attribute.putMetaDataValue(optionMemento.getString(ATTRIBUTE_KEY), this.getCleanText(optionMemento.getTextData()));
                        ++n7;
                    }
                }
            }
            ++n2;
        }
        return attributes;
    }

    public void remove(String repositoryUrl, String id) {
        if (repositoryUrl == null || id == null) {
            return;
        }
        try {
            File file = this.getDataFile(URLEncoder.encode(repositoryUrl, ENCODING_UTF_8), id);
            if (file != null && file.exists()) {
                file.delete();
            }
            if (file != null && file.getParentFile() != null && file.getParentFile().exists() && file.getParentFile().list().length == 0) {
                file.getParentFile().delete();
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error removing offline data: " + repositoryUrl + "-" + id, (Throwable)e));
        }
    }

    private File getDataFile(String folder, String id) throws IOException {
        File repositoryFolder = new File(this.dataDir, folder);
        File dataFile = new File(repositoryFolder, String.valueOf(id) + EXTENSION);
        return dataFile;
    }

    public void clear() {
        if (this.dataDir.exists()) {
            File[] fileArray = this.dataDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.destroy(file);
                ++n2;
            }
        }
    }

    private void destroy(File folder) {
        if (folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.destroy(file);
                ++n2;
            }
        }
        folder.delete();
    }

    public void flush() {
    }
}

