/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskAttachmentJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeQueriesJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeRepositoriesJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskJobFactory
implements ITaskJobFactory {
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final IRepositoryManager repositoryManager;
    private final IRepositoryModel tasksModel;

    public TaskJobFactory(TaskList taskList, TaskDataManager taskDataManager, IRepositoryManager repositoryManager, IRepositoryModel tasksModel) {
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.repositoryManager = repositoryManager;
        this.tasksModel = tasksModel;
    }

    public SynchronizationJob createSynchronizeTasksJob(AbstractRepositoryConnector connector, Set<ITask> tasks) {
        SynchronizeTasksJob job = new SynchronizeTasksJob((ITaskList)this.taskList, this.taskDataManager, this.tasksModel, connector, this.repositoryManager, tasks);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)TasksUiImages.REPOSITORY_SYNCHRONIZE);
        job.setPriority(30);
        return job;
    }

    public SynchronizationJob createSynchronizeTasksJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, Set<ITask> tasks) {
        SynchronizeTasksJob job = new SynchronizeTasksJob((ITaskList)this.taskList, this.taskDataManager, this.tasksModel, connector, taskRepository, tasks);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)TasksUiImages.REPOSITORY_SYNCHRONIZE);
        job.setPriority(30);
        return job;
    }

    public SynchronizationJob createSynchronizeQueriesJob(AbstractRepositoryConnector connector, TaskRepository repository, Set<RepositoryQuery> queries) {
        SynchronizeQueriesJob job = new SynchronizeQueriesJob(this.taskList, this.taskDataManager, this.tasksModel, connector, repository, queries);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)TasksUiImages.REPOSITORY_SYNCHRONIZE);
        job.setPriority(50);
        return job;
    }

    public SynchronizationJob createSynchronizeRepositoriesJob(Set<TaskRepository> repositories) {
        SynchronizeRepositoriesJob job = new SynchronizeRepositoriesJob(this.taskList, this.taskDataManager, this.tasksModel, this.repositoryManager, repositories);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)TasksUiImages.REPOSITORY_SYNCHRONIZE);
        job.setPriority(50);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                TaskJobFactory.this.taskList.notifyElementsChanged(null);
            }
        });
        return job;
    }

    public SubmitJob createSubmitTaskJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, final ITask task, TaskData taskData, Set<TaskAttribute> oldAttributes) {
        SubmitTaskJob job = new SubmitTaskJob(this.taskDataManager, connector, taskRepository, task, taskData, oldAttributes);
        job.setPriority(10);
        try {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    ((AbstractTask)task).setSynchronizing(true);
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error", (Throwable)e));
        }
        this.taskList.notifySynchronizationStateChanged((IRepositoryElement)task);
        return job;
    }

    public TaskJob createUpdateRepositoryConfigurationJob(final AbstractRepositoryConnector connector, final TaskRepository taskRepository) {
        TaskJob updateJob = new TaskJob("Refreshing repository configuration"){
            private IStatus error;

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Receiving configuration", -1);
                try {
                    try {
                        connector.updateRepositoryConfiguration(taskRepository, monitor);
                    }
                    catch (CoreException e) {
                        this.error = e.getStatus();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == taskRepository;
            }

            public IStatus getStatus() {
                return this.error;
            }
        };
        updateJob.setPriority(10);
        return updateJob;
    }

    public SubmitJob createSubmitTaskAttachmentJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, final ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute) {
        SubmitTaskAttachmentJob job = new SubmitTaskAttachmentJob(this.taskDataManager, connector, taskRepository, task, source, comment, attachmentAttribute);
        job.setPriority(10);
        try {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    ((AbstractTask)task).setSynchronizing(true);
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error", (Throwable)e));
        }
        this.taskList.notifySynchronizationStateChanged((IRepositoryElement)task);
        job.setUser(true);
        return job;
    }
}

