/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class QueryCloneAction
extends Action
implements IViewActionDelegate {
    protected ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run(this.getSelectedQuery(this.selection));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        RepositoryQuery selectedQuery = this.getSelectedQuery(selection);
        action.setEnabled(true);
        if (selectedQuery != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    protected RepositoryQuery getSelectedQuery(ISelection newSelection) {
        Object selectedObject;
        if (this.selection instanceof StructuredSelection && ((StructuredSelection)this.selection).size() == 1 && (selectedObject = ((StructuredSelection)this.selection).getFirstElement()) instanceof IRepositoryQuery) {
            return (RepositoryQuery)selectedObject;
        }
        return null;
    }

    public void run(RepositoryQuery selectedQuery) {
        if (selectedQuery == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Clone Query", (String)"No query selected.");
            return;
        }
        ArrayList<RepositoryQuery> queries = new ArrayList<RepositoryQuery>();
        queries.add(selectedQuery);
        Document queryDoc = TasksUiPlugin.getTaskListManager().getTaskListWriter().createQueryDocument(queries);
        List<RepositoryQuery> clonedQueries = TasksUiPlugin.getTaskListManager().getTaskListWriter().readQueryDocument(queryDoc);
        if (clonedQueries.size() > 0) {
            for (RepositoryQuery query : clonedQueries) {
                query.setHandleIdentifier(TasksUiPlugin.getTaskList().getUniqueHandleIdentifier());
                TasksUiPlugin.getTaskList().addQuery(query);
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(query.getConnectorKind());
                TasksUiInternal.openEditQueryDialog(connectorUi, (IRepositoryQuery)query);
            }
        } else {
            TasksUiInternal.displayStatus("Clone Query Failes", (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Query cloning did not succeeded."));
        }
    }
}

