/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(region.getOffset());
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        TaskRepository selectedRepository = this.getTaskRepository(textViewer);
        if (selectedRepository != null) {
            repositories.add(selectedRepository);
        } else {
            repositories.addAll(TasksUi.getRepositoryManager().getAllRepositories());
        }
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        this.detectHyperlinks(line, region.getOffset() - lineInfo.getOffset(), lineInfo.getOffset(), repositories, hyperlinks);
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    protected void detectHyperlinks(String line, int lineOffset, int regionOffset, List<TaskRepository> repositories, List<IHyperlink> hyperlinks) {
        for (TaskRepository repository : repositories) {
            IHyperlink[] links;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
            if (connectorUi == null || (links = connectorUi.findHyperlinks(repository, line, lineOffset, regionOffset)) == null) continue;
            hyperlinks.addAll((Collection<IHyperlink>)Arrays.asList(links));
        }
    }

    protected TaskRepository getTaskRepository(ITextViewer textViewer) {
        TaskRepository repository = (TaskRepository)this.getAdapter(TaskRepository.class);
        if (repository != null) {
            return repository;
        }
        IResource resource = (IResource)this.getAdapter(IResource.class);
        if (resource == null) {
            IEditorInput input;
            IWorkbenchPart part;
            IWorkbenchPage activePage;
            if (textViewer instanceof RepositoryTextViewer) {
                RepositoryTextViewer viewer = (RepositoryTextViewer)textViewer;
                return viewer.getRepository();
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (activePage = window.getActivePage()) != null && (part = activePage.getActivePart()) instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) != null) {
                resource = (IResource)input.getAdapter(IResource.class);
            }
        }
        if (resource != null) {
            return TasksUiPlugin.getDefault().getRepositoryForResource(resource);
        }
        return null;
    }
}

