/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

public class PreviewAttachmentPage2
extends WizardPage {
    private static final String DESCRIPTION = "Review the attachment before submitting";
    protected static final int MAX_TEXT_SIZE = 50000;
    private static final String PAGE_NAME = "PreviewAttachmentPage";
    private static final String TITLE = "Attachment Preview";
    private final Set<String> imageTypes;
    private final TaskAttachmentModel model;
    private Button runInBackgroundButton;
    private ScrolledComposite scrolledComposite;
    private final Set<String> textTypes;
    private Composite contentComposite;

    public PreviewAttachmentPage2(TaskAttachmentModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.textTypes = new HashSet<String>();
        this.textTypes.add("text/plain");
        this.textTypes.add("text/html");
        this.textTypes.add("text/html");
        this.textTypes.add("application/xml");
        this.imageTypes = new HashSet<String>();
        this.imageTypes.add("image/jpeg");
        this.imageTypes.add("image/gif");
        this.imageTypes.add("image/png");
    }

    private void adjustScrollbars(Rectangle imgSize) {
        Rectangle clientArea = this.scrolledComposite.getClientArea();
        ScrollBar hBar = this.scrolledComposite.getHorizontalBar();
        hBar.setMinimum(0);
        hBar.setMaximum(imgSize.width - 1);
        hBar.setPageIncrement(clientArea.width);
        hBar.setIncrement(10);
        ScrollBar vBar = this.scrolledComposite.getVerticalBar();
        vBar.setMinimum(0);
        vBar.setMaximum(imgSize.height - 1);
        vBar.setPageIncrement(clientArea.height);
        vBar.setIncrement(10);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.contentComposite = new Composite(composite, 0);
        this.contentComposite.setLayoutData((Object)new GridData(1808));
        this.contentComposite.setLayout((Layout)new GridLayout());
        this.runInBackgroundButton = new Button(composite, 32);
        this.runInBackgroundButton.setText("Run in background");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Control[] children;
            Control[] controlArray = children = this.contentComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            if (this.isTextAttachment() || this.isImageAttachment()) {
                Object content = this.getContent(this.contentComposite);
                if (content instanceof String) {
                    this.createTextPreview(this.contentComposite, (String)content);
                } else if (content instanceof Image) {
                    this.createImagePreview(this.contentComposite, (Image)content);
                }
            } else {
                this.createGenericPreview(this.contentComposite);
            }
            this.contentComposite.layout(true, true);
        }
        super.setVisible(visible);
    }

    private void createErrorPreview(Composite composite, String message) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
        label.setText(message);
    }

    private void createGenericPreview(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
        String name = this.model.getSource().getName();
        TaskAttachmentMapper taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)this.model.getAttribute());
        if (taskAttachment.getFileName() != null) {
            name = taskAttachment.getFileName();
        }
        label.setText("Attaching File '" + name + "'\nA preview the type '" + this.model.getContentType() + "' is currently not available");
    }

    private void createImagePreview(Composite composite, final Image bufferedImage) {
        this.scrolledComposite = new ScrolledComposite(composite, 2816);
        this.scrolledComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        Composite canvasComposite = new Composite((Composite)this.scrolledComposite, 0);
        canvasComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Canvas canvas = new Canvas(canvasComposite, 262144);
        final Rectangle imgSize = bufferedImage.getBounds();
        canvas.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(imgSize.width, imgSize.height).create());
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                event.gc.drawImage(bufferedImage, 0, 0);
            }
        });
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                bufferedImage.dispose();
            }
        });
        canvas.setSize(imgSize.width, imgSize.height);
        this.scrolledComposite.setMinSize(imgSize.width, imgSize.height);
        this.scrolledComposite.setContent((Control)canvasComposite);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                PreviewAttachmentPage2.this.adjustScrollbars(imgSize);
            }
        });
        this.adjustScrollbars(imgSize);
    }

    private void createTextPreview(Composite composite, String contents) {
        Text text = new Text(composite, 2826);
        GridData gd = new GridData(1808);
        gd.heightHint = composite.getBounds().y;
        gd.widthHint = composite.getBounds().x;
        text.setLayoutData((Object)gd);
        text.setText(contents);
    }

    private Object getContent(final Composite composite) {
        final Object[] result = new Object[1];
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("Preparing preview", -1);
                            final InputStream in = PreviewAttachmentPage2.this.model.getSource().createInputStream(monitor);
                            try {
                                try {
                                    if (PreviewAttachmentPage2.this.isTextAttachment()) {
                                        String line;
                                        StringBuilder content = new StringBuilder();
                                        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                                        while ((line = reader.readLine()) != null && content.length() < 50000 && !monitor.isCanceled()) {
                                            content.append(line);
                                            content.append("\n");
                                        }
                                        result[0] = content.toString();
                                    } else if (PreviewAttachmentPage2.this.isImageAttachment()) {
                                        Display.getDefault().syncExec(new Runnable(){

                                            public void run() {
                                                Image originalImage = new Image((Device)PreviewAttachmentPage2.this.getShell().getDisplay(), in);
                                                Image bufferedImage = new Image((Device)PreviewAttachmentPage2.this.getShell().getDisplay(), originalImage.getBounds());
                                                GC gc = new GC((Drawable)bufferedImage);
                                                gc.setBackground(composite.getBackground());
                                                gc.fillRectangle(originalImage.getBounds());
                                                gc.drawImage(originalImage, 0, 0);
                                                gc.dispose();
                                                originalImage.dispose();
                                                result[0] = bufferedImage;
                                            }
                                        });
                                    }
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to close file", (Throwable)e));
                                }
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error generating preview", (Throwable)e));
            this.createErrorPreview(composite, "Could not create preview");
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return result[0];
    }

    private boolean isImageAttachment() {
        return this.imageTypes.contains(this.model.getContentType());
    }

    private boolean isTextAttachment() {
        return this.textTypes.contains(this.model.getContentType());
    }

    public boolean runInBackground() {
        return this.runInBackgroundButton.getSelection();
    }
}

