/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.planner;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskActivitySorter
extends ViewerSorter {
    public static final int DESCRIPTION = 1;
    public static final int PRIORITY = 2;
    public static final int CREATION_DATE = 3;
    public static final int COMPLETED_DATE = 4;
    public static final int DURATION = 5;
    public static final int ESTIMATED = 6;
    public static final int ICON = 0;
    private final int criteria;

    public TaskActivitySorter(int criteria) {
        this.criteria = criteria;
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        AbstractTask t1 = (AbstractTask)obj1;
        AbstractTask t2 = (AbstractTask)obj2;
        switch (this.criteria) {
            case 1: {
                return this.compareDescription((ITask)t1, (ITask)t2);
            }
            case 2: {
                return this.comparePriority((ITask)t1, (ITask)t2);
            }
            case 3: {
                return this.compareCreationDate((ITask)t1, (ITask)t2);
            }
            case 4: {
                return this.compareCompletedDate((ITask)t1, (ITask)t2);
            }
            case 5: {
                return this.compareDuration((ITask)t1, (ITask)t2);
            }
            case 6: {
                return this.compareEstimated(t1, t2);
            }
        }
        return 0;
    }

    protected int compareDescription(ITask task1, ITask task2) {
        return task1.getSummary().compareToIgnoreCase(task2.getSummary());
    }

    protected int comparePriority(ITask task1, ITask task2) {
        return task1.getPriority().compareTo(task2.getPriority());
    }

    protected int compareCompletedDate(ITask task1, ITask task2) {
        return task2.getCompletionDate().compareTo(task1.getCompletionDate());
    }

    protected int compareEstimated(AbstractTask task1, AbstractTask task2) {
        return task2.getEstimatedTimeHours() - task1.getEstimatedTimeHours();
    }

    protected int compareCreationDate(ITask task1, ITask task2) {
        if (task1.getCreationDate() == null) {
            return 1;
        }
        if (task2.getCreationDate() == null) {
            return -1;
        }
        return task2.getCreationDate().compareTo(task1.getCreationDate());
    }

    protected int compareDuration(ITask task1, ITask task2) {
        return TasksUiPlugin.getTaskActivityManager().getElapsedTime(task1) < TasksUiPlugin.getTaskActivityManager().getElapsedTime(task2) ? 1 : -1;
    }
}

