/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.web.tasks.ParametersEditor;
import org.eclipse.mylyn.internal.web.tasks.WebContentProposalProvider;
import org.eclipse.mylyn.internal.web.tasks.WebRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebQueryWizardPage
extends AbstractRepositoryQueryPage {
    private Text queryUrlText;
    private Text queryPatternText;
    private TableViewer previewTable;
    private String webPage;
    private UpdatePreviewJob updatePreviewJob;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private ParametersEditor parametersEditor;
    private Map<String, String> oldProperties;
    private final ArrayList<ControlDecoration> decorations = new ArrayList();
    private Text title;

    public WebQueryWizardPage(TaskRepository repository, IRepositoryQuery query) {
        super("New web query", repository, query);
        this.setTitle("Create web query");
        this.setDescription("Specify query parameters for " + repository.getRepositoryUrl());
    }

    public void dispose() {
        for (ControlDecoration decoration : this.decorations) {
            decoration.dispose();
        }
        super.dispose();
    }

    private static String getDefaultQueryTitle(TaskRepository repository) {
        String label;
        String title = label = repository.getRepositoryLabel();
        Set queries = TasksUiPlugin.getTaskList().getRepositoryQueries(repository.getRepositoryUrl());
        int n = 1;
        for (IRepositoryQuery query : queries) {
            if (!query.getSummary().equals(title)) continue;
            title = String.valueOf(label) + " " + n;
        }
        return title;
    }

    private void createTitleGroup(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText("Query Title:");
        this.title = new Text(group, 2048);
        this.title.setLayoutData((Object)new GridData(768));
        this.title.setText(this.getQuery() == null ? WebQueryWizardPage.getDefaultQueryTitle(this.getTaskRepository()) : this.getQuery().getSummary());
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebQueryWizardPage.this.setPageComplete(WebQueryWizardPage.this.isPageComplete());
            }
        });
        this.title.setFocus();
    }

    public String getQueryTitle() {
        return this.title != null ? this.title.getText() : null;
    }

    public void createControl(Composite parent) {
        IRepositoryQuery query;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        if (!this.inSearchContainer()) {
            this.createTitleGroup(composite);
        }
        this.parametersEditor = new ParametersEditor(composite, 0);
        GridData gridData1 = new GridData(4, 4, true, true);
        gridData1.minimumHeight = 90;
        this.parametersEditor.setLayoutData(gridData1);
        ExpandableComposite expComposite = this.toolkit.createExpandableComposite(composite, 34);
        expComposite.setFont(parent.getFont());
        GridData gridData_1 = new GridData(4, 4, true, false);
        gridData_1.heightHint = 150;
        gridData_1.minimumHeight = 150;
        expComposite.setLayoutData((Object)gridData_1);
        expComposite.setBackground(parent.getBackground());
        expComposite.setText("Advanced &Configuration");
        expComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                WebQueryWizardPage.this.getControl().getShell().pack();
            }
        });
        this.toolkit.paintBordersFor((Composite)expComposite);
        Composite composite1 = this.toolkit.createComposite((Composite)expComposite, 2048);
        composite1.setLayout((Layout)new GridLayout(3, false));
        expComposite.setClient((Control)composite1);
        this.toolkit.createLabel(composite1, "&Query URL:", 0);
        this.queryUrlText = new Text(composite1, 2048);
        GridData gridData_2 = new GridData(4, 0x1000000, true, false);
        gridData_2.widthHint = 200;
        this.queryUrlText.setLayoutData((Object)gridData_2);
        this.queryUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebQueryWizardPage.this.webPage = null;
            }
        });
        this.decorations.add(WebContentProposalProvider.createDecoration(this.queryUrlText, this.parametersEditor, false));
        Button button = new Button(composite1, 0);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText("&Open");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebQueryWizardPage.this.openBrowser();
            }
        });
        Label queryPatternLabel = this.toolkit.createLabel(composite1, "Query &Pattern:", 0);
        queryPatternLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.queryPatternText = new Text(composite1, 2626);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.widthHint = 200;
        gridData.heightHint = 60;
        this.queryPatternText.setLayoutData((Object)gridData);
        this.decorations.add(WebContentProposalProvider.createDecoration(this.queryPatternText, this.parametersEditor, true));
        Button preview = new Button(composite1, 0);
        preview.setLayoutData((Object)new GridData(4, 128, false, false));
        preview.setText("Previe&w");
        preview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebQueryWizardPage.this.webPage = null;
                WebQueryWizardPage.this.updatePreview();
            }
        });
        this.previewTable = new TableViewer(composite1, 2048);
        GridData gridData2 = new GridData(4, 4, false, true, 3, 1);
        gridData2.heightHint = 60;
        Table table = this.previewTable.getTable();
        table.setLayoutData((Object)gridData2);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn colId = new TableColumn(table, 0);
        colId.setWidth(100);
        colId.setText("Id");
        TableColumn colDescription = new TableColumn(table, 0);
        colDescription.setWidth(200);
        colDescription.setText("Description");
        TableColumn colStatus = new TableColumn(table, 0);
        colStatus.setText("Status");
        colStatus.setWidth(80);
        TableColumn colType = new TableColumn(table, 0);
        colType.setText("Type");
        colType.setWidth(80);
        TableColumn colOwner = new TableColumn(table, 0);
        colOwner.setText("Owner");
        colOwner.setWidth(120);
        this.previewTable.setColumnProperties(new String[]{"Id", "Description", "Status", "Type", "Owner"});
        this.previewTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.previewTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                TaskMapper task = (TaskMapper)element;
                switch (columnIndex) {
                    case 0: {
                        return task.getTaskData().getTaskId();
                    }
                    case 1: {
                        return task.getSummary();
                    }
                    case 2: {
                        return task.getCompletionDate() != null ? "complete" : "incomplete";
                    }
                    case 3: {
                        return task.getTaskKind();
                    }
                    case 4: {
                        return task.getOwner();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.setControl((Control)composite);
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (this.getTaskRepository() != null) {
            this.queryUrlText.setText(WebQueryWizardPage.addVars(vars, this.getTaskRepository().getProperty("queryUrl")));
            this.queryPatternText.setText(WebQueryWizardPage.addVars(vars, this.getTaskRepository().getProperty("queryPattern")));
            this.oldProperties = this.getTaskRepository().getProperties();
            params.putAll(this.oldProperties);
        }
        if ((query = this.getQuery()) != null) {
            this.setTitle(query.getSummary());
            this.queryUrlText.setText(WebQueryWizardPage.addVars(vars, query.getAttribute("UrlTemplate")));
            this.queryPatternText.setText(WebQueryWizardPage.addVars(vars, query.getAttribute("Regexp")));
            params.putAll(WebRepositoryConnector.getQueryParams(query));
        }
        this.parametersEditor.addParams(params, vars);
    }

    private static String addVars(LinkedHashMap<String, String> vars, String property) {
        if (property == null) {
            return "";
        }
        for (String var : WebRepositoryConnector.getTemplateVariables(property)) {
            vars.put(var, "");
        }
        return property;
    }

    synchronized void updatePreview() {
        if (this.updatePreviewJob == null) {
            this.updatePreviewJob = new UpdatePreviewJob("Updating preview");
            this.updatePreviewJob.setPriority(50);
        }
        this.updatePreviewJob.setParams(this.queryUrlText.getText(), this.queryPatternText.getText(), this.parametersEditor.getParameters());
        if (!this.updatePreviewJob.isActive()) {
            this.updatePreviewJob.schedule();
        }
    }

    protected void openBrowser() {
        final String url = this.queryUrlText.getText();
        final Map<String, String> params = this.parametersEditor.getParameters();
        new Job("Opening Browser"){

            protected IStatus run(IProgressMonitor monitor) {
                String evaluatedUrl = WebRepositoryConnector.evaluateParams(url, (Map<String, String>)params, WebQueryWizardPage.this.getTaskRepository());
                try {
                    String webPage = WebRepositoryConnector.fetchResource(evaluatedUrl, params, WebQueryWizardPage.this.getTaskRepository());
                    File webPageFile = File.createTempFile("mylyn-web-connector", ".html");
                    webPageFile.deleteOnExit();
                    FileWriter w = new FileWriter(webPageFile);
                    w.write(webPage);
                    w.flush();
                    w.close();
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    browser.openURL(webPageFile.toURL());
                }
                catch (Exception e) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            WebQueryWizardPage.this.setMessage(e.toString());
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    void updatePreviewTable(List<TaskMapper> queryHits, MultiStatus queryStatus) {
        this.previewTable.setInput(queryHits);
        if (queryStatus.isOK()) {
            this.setMessage(null, 2);
        } else {
            StringBuffer sb = new StringBuffer();
            IStatus[] iStatusArray = queryStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                sb.append(status.getMessage()).append("\n");
                ++n2;
            }
            this.setMessage(sb.toString(), 2);
        }
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        query.setAttribute("UrlTemplate", this.queryUrlText.getText());
        query.setAttribute("Regexp", this.queryPatternText.getText());
        query.setAttribute("taskPrefix", this.getTaskRepository().getProperty("taskUrl"));
        Map<String, String> params = this.parametersEditor.getParameters();
        query.setUrl(WebRepositoryConnector.evaluateParams(this.queryUrlText.getText(), params, this.getTaskRepository()));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            query.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UpdatePreviewJob
    extends Job {
        private volatile String url;
        private volatile String regexp;
        private volatile Map<String, String> params;
        private volatile boolean active;

        private UpdatePreviewJob(String name) {
            super(name);
            this.active = false;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setParams(String url, String regexp, Map<String, String> params) {
            this.url = url;
            this.regexp = regexp;
            this.params = params;
        }

        protected IStatus run(IProgressMonitor monitor) {
            String currentRegexp = this.regexp;
            String queryPattern = WebRepositoryConnector.evaluateParams(currentRegexp, this.params, WebQueryWizardPage.this.getTaskRepository());
            String evaluatedUrl = WebRepositoryConnector.evaluateParams(this.url, this.params, WebQueryWizardPage.this.getTaskRepository());
            String taskPrefix = WebRepositoryConnector.evaluateParams(WebQueryWizardPage.this.getTaskRepository().getProperty("taskUrl"), this.params, WebQueryWizardPage.this.getTaskRepository());
            this.active = true;
            do {
                final MultiStatus queryStatus = new MultiStatus("org.eclipse.mylyn.tasks.web", 0, "Query result", null);
                final ArrayList queryHits = new ArrayList();
                try {
                    if (WebQueryWizardPage.this.webPage == null) {
                        WebQueryWizardPage.this.webPage = WebRepositoryConnector.fetchResource(evaluatedUrl, this.params, WebQueryWizardPage.this.getTaskRepository());
                    }
                    TaskDataCollector collector = new TaskDataCollector(){

                        public void accept(TaskData taskData) {
                            queryHits.add(new TaskMapper(taskData));
                        }
                    };
                    IStatus status = queryPattern != null && queryPattern.trim().length() > 0 ? WebRepositoryConnector.performQuery(WebQueryWizardPage.this.webPage, queryPattern, taskPrefix, monitor, collector, WebQueryWizardPage.this.getTaskRepository()) : WebRepositoryConnector.performRssQuery(WebQueryWizardPage.this.webPage, monitor, collector, WebQueryWizardPage.this.getTaskRepository());
                    if (!status.isOK()) {
                        queryStatus.add(status);
                    } else if (queryHits.size() == 0) {
                        queryStatus.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.web", 0, "No matching results. Check query regexp", null));
                    }
                }
                catch (IOException ex) {
                    queryStatus.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.web", 4, "Unable to fetch resource: " + ex.getMessage(), null));
                }
                catch (Exception ex) {
                    queryStatus.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.web", 4, "Parsing error: " + ex.getMessage(), null));
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        WebQueryWizardPage.this.updatePreviewTable(queryHits, queryStatus);
                    }
                });
            } while (!currentRegexp.equals(currentRegexp) && !monitor.isCanceled());
            this.active = false;
            return Status.OK_STATUS;
        }
    }
}

