/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import org.eclipse.mylyn.internal.wikitext.confluence.core.block.AbstractConfluenceDelimitedBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class ExtendedQuoteBlock
extends AbstractConfluenceDelimitedBlock {
    private int paraLine = 0;
    private boolean paraOpen = false;

    public ExtendedQuoteBlock() {
        super("quote");
    }

    protected void resetState() {
        super.resetState();
        this.paraOpen = false;
        this.paraLine = 0;
    }

    protected void beginBlock() {
        Attributes attributes = new Attributes();
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, attributes);
    }

    protected void endBlock() {
        if (this.paraOpen) {
            this.builder.endBlock();
            this.paraLine = 0;
            this.paraOpen = false;
        }
        this.builder.endBlock();
    }

    protected void handleBlockContent(String content) {
        if (this.blockLineCount == 1 && content.length() == 0) {
            return;
        }
        if (this.getMarkupLanguage().isEmptyLine(content) && this.blockLineCount > 1 && this.paraOpen) {
            this.builder.endBlock();
            this.paraOpen = false;
            this.paraLine = 0;
            return;
        }
        if (!this.paraOpen) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            this.paraOpen = true;
        }
        if (this.paraLine != 0) {
            this.builder.lineBreak();
        }
        ++this.paraLine;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, content, 0);
    }

    protected void setOption(String key, String value) {
    }
}

