/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.HyperlinkExternalReplacementToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.HyperlinkInternalReplacementToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.ImageReplacementToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.LineBreakToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.TemplateReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlCommentPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.LimitedHtmlEndTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.LimitedHtmlStartTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLiteralReplacementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaWikiLanguage
extends MarkupLanguage {
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Block> paragraphBreakingBlocks = new ArrayList<Block>();
    private static MarkupLanguage.PatternBasedSyntax tokenSyntax = new MarkupLanguage.PatternBasedSyntax();
    private static MarkupLanguage.PatternBasedSyntax phraseModifierSyntax = new MarkupLanguage.PatternBasedSyntax();

    static {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new EscapePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        String[] allowedHtmlTags = new String[]{"b", "big", "blockquote", "caption", "center", "cite", "code", "dd", "del", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "ins", "li", "ol", "p", "pre", "rb", "rp", "rt", "ruby", "s", "small", "span", "strike", "strong", "sub", "sup", "table", "td", "th", "tr", "tt", "u", "ul", "var"};
        phraseModifierSyntax.add((PatternBasedElement)new LimitedHtmlEndTagPhraseModifier(allowedHtmlTags));
        phraseModifierSyntax.add((PatternBasedElement)new LimitedHtmlStartTagPhraseModifier(allowedHtmlTags));
        phraseModifierSyntax.add((PatternBasedElement)new HtmlCommentPhraseModifier());
        tokenSyntax.add((PatternBasedElement)new LineBreakToken());
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new ImageReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkInternalReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkExternalReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new PatternLiteralReplacementToken("(?:(?<=\\w\\s)(----)(?=\\s\\w))", "<hr/>"));
        tokenSyntax.add((PatternBasedElement)new TemplateReplacementToken());
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.EntityReferenceReplacementToken());
    }

    public MediaWikiLanguage() {
        this.blocks.add(new HeadingBlock());
        this.blocks.add(new ListBlock());
        this.blocks.add(new PreformattedBlock());
        this.blocks.add(new TableBlock());
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        this.blocks.add(paragraphBlock);
        for (Block block : this.blocks) {
            if (block == paragraphBlock) continue;
            this.paragraphBreakingBlocks.add(block);
        }
        this.setName("MediaWiki");
        this.setInternalLinkPattern("/wiki/{0}");
    }

    protected MarkupLanguage.PatternBasedSyntax getPhraseModifierSyntax() {
        return phraseModifierSyntax;
    }

    protected MarkupLanguage.PatternBasedSyntax getReplacementTokenSyntax() {
        return tokenSyntax;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Block> getParagraphBreakingBlocks() {
        return this.paragraphBreakingBlocks;
    }

    public String toInternalHref(String pageName) {
        String pageId = pageName.replace(' ', '_');
        if (pageId.startsWith(":")) {
            pageId = pageId.substring(1);
        } else if (pageId.startsWith("#")) {
            return pageId;
        }
        return MessageFormat.format(this.internalLinkPattern, pageId);
    }
}

