/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.TreeSet;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditorOutline;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.mylyn.internal.wikitext.ui.editor.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.actions.SetMarkupLanguageAction;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MarkupMonoReconciler;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupDocumentProvider;
import org.eclipse.mylyn.wikitext.core.WikiTextPlugin;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MarkupEditor
extends TextEditor {
    private static final String MARKUP_LANGUAGE = "markupLanguage";
    public static final String CONTEXT = "org.eclipse.mylyn.wikitext.ui.editor.markupSourceContext";
    private IDocument document;
    private IDocumentListener documentListener;
    private boolean previewDirty = true;
    private boolean outlineDirty = true;
    private Browser browser;
    private MarkupEditorOutline outlinePage;
    private OutlineItem outlineModel;
    private final OutlineParser outlineParser = new OutlineParser();
    private boolean disableReveal;
    private ISourceViewer viewer;
    private IPropertyChangeListener preferencesListener;
    private IDocumentPartitioningListener documentPartitioningListener;
    private final MarkupSourceViewerConfiguration sourceViewerConfiguration;
    private CTabItem sourceTab;
    public static final String EDITOR_SOURCE_VIEWER = "org.eclipse.mylyn.wikitext.ui.editor.sourceViewer";

    public MarkupEditor() {
        this.outlineParser.setLabelMaxLength(48);
        this.outlineModel = this.outlineParser.createRootItem();
        this.disableReveal = false;
        this.setDocumentProvider((IDocumentProvider)new MarkupDocumentProvider());
        this.sourceViewerConfiguration = new MarkupSourceViewerConfiguration(this.getPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        this.sourceTab = new CTabItem(folder, 0);
        this.updateSourceTabLabel();
        this.viewer = new MarkupSourceViewer((Composite)folder, ruler, styles | 0x40);
        this.sourceTab.setControl((Control)(this.viewer instanceof Viewer ? ((Viewer)this.viewer).getControl() : this.viewer.getTextWidget()));
        folder.setSelection(this.sourceTab);
        CTabItem previewTab = new CTabItem(folder, 0);
        previewTab.setText(Messages.getString("MarkupEditor.PreviewView_label"));
        previewTab.setToolTipText(Messages.getString("MarkupEditor.PreviewView_tooltip"));
        this.browser = new Browser((Composite)folder, 0);
        previewTab.setControl((Control)this.browser);
        folder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                MarkupEditor.this.updatePreview();
            }
        });
        this.viewer.getTextWidget().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MarkupEditor.this.updateOutlineSelection();
            }
        });
        this.viewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                MarkupEditor.this.updateOutlineSelection();
            }
        });
        this.viewer.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MarkupEditor.this.updateOutlineSelection();
            }
        });
        IFocusService focusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        if (focusService != null) {
            focusService.addFocusTracker((Control)this.viewer.getTextWidget(), EDITOR_SOURCE_VIEWER);
        }
        this.viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.getMarkupLanguage());
        this.viewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)this.viewer);
        this.getSourceViewerDecorationSupport(this.viewer);
        this.updateDocument();
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (MarkupEditor.this.viewer.getTextWidget().isDisposed()) {
                        return;
                    }
                    MarkupEditor.this.viewer.getTextWidget().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MarkupEditor.this.reloadPreferences();
                        }
                    });
                }
            };
            WikiTextUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        }
        return this.viewer;
    }

    private void reloadPreferences() {
        this.viewer.invalidateTextPresentation();
    }

    public void updatePartControl(IEditorInput input) {
        super.updatePartControl(input);
        this.updateDocument();
    }

    public void dispose() {
        if (this.document != null) {
            if (this.documentListener != null) {
                this.document.removeDocumentListener(this.documentListener);
            }
            if (this.documentPartitioningListener != null) {
                this.document.removeDocumentPartitioningListener(this.documentPartitioningListener);
            }
            this.document = null;
        }
        if (this.preferencesListener != null) {
            WikiTextUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
            this.preferencesListener = null;
        }
        super.dispose();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setHelpContextId(CONTEXT);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.updateDocument();
        if (this.sourceViewerConfiguration != null) {
            this.sourceViewerConfiguration.setFile(this.getFile());
        }
        this.initializeMarkupLanguage(input);
    }

    private void updateDocument() {
        if (this.getSourceViewer() != null) {
            IDocument previousDocument = this.document;
            this.document = this.getSourceViewer().getDocument();
            if (previousDocument == this.document) {
                return;
            }
            if (previousDocument != null && this.documentListener != null) {
                previousDocument.removeDocumentListener(this.documentListener);
            }
            if (previousDocument != null && this.documentPartitioningListener != null) {
                previousDocument.removeDocumentPartitioningListener(this.documentPartitioningListener);
            }
            if (this.document != null) {
                if (this.documentListener == null) {
                    this.documentListener = new IDocumentListener(){

                        public void documentAboutToBeChanged(DocumentEvent event) {
                        }

                        public void documentChanged(DocumentEvent event) {
                            MarkupEditor.this.previewDirty = true;
                            MarkupEditor.this.outlineDirty = true;
                            MarkupEditor.this.scheduleOutlineUpdate();
                        }
                    };
                }
                this.document.addDocumentListener(this.documentListener);
                if (this.documentPartitioningListener == null) {
                    this.documentPartitioningListener = new IDocumentPartitioningListener(){

                        public void documentPartitioningChanged(IDocument document) {
                            MarkupEditor.this.updateOutline();
                        }
                    };
                }
                this.document.addDocumentPartitioningListener(this.documentPartitioningListener);
            }
            this.previewDirty = true;
            this.outlineDirty = true;
            this.updateOutline();
        }
    }

    private void updatePreview() {
        if (this.previewDirty && this.browser != null) {
            String xhtml = null;
            if (this.document == null) {
                xhtml = "<?xml version=\"1.0\" ?><html xmlns=\"http://www.w3.org/1999/xhtml\"><body></body></html>";
            } else {
                try {
                    MarkupParser markupParser = new MarkupParser();
                    IFile file = this.getFile();
                    String title = file.getName();
                    if (title.lastIndexOf(46) != -1) {
                        title = title.substring(0, title.lastIndexOf(46));
                    }
                    StringWriter writer = new StringWriter();
                    HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer);
                    builder.setTitle(title);
                    IPath location = file.getLocation();
                    if (location != null) {
                        builder.setBaseInHead(true);
                        builder.setBase(location.removeLastSegments(1).toFile().toURI());
                    }
                    markupParser.setBuilder((DocumentBuilder)builder);
                    markupParser.setMarkupLanaguage(this.getMarkupLanguage());
                    if (markupParser.getMarkupLanguage() == null) {
                        builder.beginDocument();
                        builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
                        builder.characters(this.document.get());
                        builder.endBlock();
                        builder.endDocument();
                    } else {
                        markupParser.getMarkupLanguage().setBlocksOnly(false);
                        markupParser.getMarkupLanguage().setFilterGenerativeContents(false);
                        markupParser.parse(this.document.get());
                    }
                    xhtml = writer.toString();
                }
                catch (Exception e) {
                    StringWriter stackTrace = new StringWriter();
                    PrintWriter writer = new PrintWriter(stackTrace);
                    e.printStackTrace(writer);
                    writer.close();
                    StringWriter documentWriter = new StringWriter();
                    HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)documentWriter);
                    builder.beginDocument();
                    builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
                    builder.characters(stackTrace.toString());
                    builder.endBlock();
                    builder.endDocument();
                    xhtml = writer.toString();
                }
            }
            this.browser.setText(xhtml);
            this.previewDirty = false;
        }
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class == adapter) {
            if (this.outlinePage == null || this.outlinePage.getControl().isDisposed()) {
                this.outlinePage = new MarkupEditorOutline(this);
                this.scheduleOutlineUpdate();
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public OutlineItem getOutlineModel() {
        return this.outlineModel;
    }

    private void scheduleOutlineUpdate() {
        UIJob updateOutlineJob = new UIJob("Update outline"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!MarkupEditor.this.outlineDirty) {
                    return Status.CANCEL_STATUS;
                }
                MarkupEditor.this.updateOutline();
                return Status.OK_STATUS;
            }
        };
        updateOutlineJob.setUser(false);
        updateOutlineJob.setSystem(true);
        updateOutlineJob.setPriority(10);
        updateOutlineJob.schedule(600L);
    }

    private void updateOutline() {
        if (!this.outlineDirty) {
            return;
        }
        if (this.outlinePage != null && this.outlinePage.getControl() != null && !this.outlinePage.getControl().isDisposed()) {
            this.outlineDirty = false;
            this.outlineParser.setMarkupLanguage(this.getMarkupLanguage());
            this.outlineModel.clear();
            this.outlineParser.parse(this.outlineModel, this.document.get());
            this.outlinePage.refresh();
            this.outlinePage.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MarkupEditor.this.outlinePage != null && MarkupEditor.this.outlinePage.getControl() != null && !MarkupEditor.this.outlinePage.getControl().isDisposed()) {
                        MarkupEditor.this.updateOutlineSelection();
                    }
                }
            });
        }
    }

    private void updateOutlineSelection() {
        if (this.disableReveal) {
            return;
        }
        if (this.outlineModel != null && this.outlinePage != null) {
            this.disableReveal = true;
            try {
                OutlineItem item;
                Point selection = this.getSourceViewer().getTextWidget().getSelection();
                if (selection != null && (item = this.outlineModel.findNearestMatchingOffset(selection.x)) != null) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)item));
                }
            }
            finally {
                this.disableReveal = false;
            }
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{CONTEXT});
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext(CONTEXT);
    }

    private void initializeMarkupLanguage(IEditorInput input) {
        MarkupLanguage markupLanguage = this.loadMarkupLanguagePreference();
        if (markupLanguage == null) {
            String name = input.getName();
            if (input instanceof IFileEditorInput) {
                name = ((IFileEditorInput)input).getFile().getName();
            } else if (input instanceof IPathEditorInput) {
                name = ((IPathEditorInput)input).getPath().lastSegment();
            }
            markupLanguage = WikiTextPlugin.getDefault().getMarkupLanguageForFilename(name);
            if (markupLanguage == null) {
                markupLanguage = WikiTextPlugin.getDefault().getMarkupLanguage("Textile");
            }
        }
        this.setMarkupLanguage(markupLanguage, false);
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage, boolean persistSetting) {
        IReconciler reconciler;
        ISourceViewer sourceViewer;
        ((MarkupDocumentProvider)this.getDocumentProvider()).setMarkupLanguage(markupLanguage);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        IDocumentPartitioner partitioner = document.getDocumentPartitioner();
        if (partitioner instanceof FastMarkupPartitioner) {
            FastMarkupPartitioner fastMarkupPartitioner = (FastMarkupPartitioner)partitioner;
            fastMarkupPartitioner.setMarkupLanguage(markupLanguage);
        }
        this.sourceViewerConfiguration.setMarkupLanguage(markupLanguage);
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().invalidateTextPresentation();
        }
        this.scheduleOutlineUpdate();
        this.updateSourceTabLabel();
        if (this.viewer != null) {
            this.viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.getMarkupLanguage());
        }
        if (persistSetting && markupLanguage != null) {
            this.storeMarkupLanguagePreference(markupLanguage);
        }
        if (persistSetting && (sourceViewer = this.getSourceViewer()) instanceof MarkupSourceViewer && (reconciler = ((MarkupSourceViewer)sourceViewer).getReconciler()) instanceof MarkupMonoReconciler) {
            ((MarkupMonoReconciler)reconciler).forceReconciling();
        }
    }

    private void updateSourceTabLabel() {
        if (this.sourceTab != null) {
            MarkupLanguage markupLanguage = this.getMarkupLanguage();
            if (markupLanguage == null) {
                this.sourceTab.setText(Messages.getString("MarkupEditor.SourceView_label"));
                this.sourceTab.setToolTipText(Messages.getString("MarkupEditor.SourceView_tooltip"));
            } else {
                this.sourceTab.setText(Messages.getMessage("MarkupEditor.SourceView_label2", markupLanguage.getName()));
                this.sourceTab.setToolTipText(Messages.getMessage("MarkupEditor.SourceView_tooltip2", markupLanguage.getName()));
            }
        }
    }

    private MarkupLanguage loadMarkupLanguagePreference() {
        IFile file = this.getFile();
        if (file != null) {
            return MarkupEditor.loadMarkupLanguagePreference(file);
        }
        return null;
    }

    public static MarkupLanguage loadMarkupLanguagePreference(IFile file) {
        try {
            String languageName = file.getPersistentProperty(new QualifiedName(WikiTextUiPlugin.getDefault().getPluginId(), MARKUP_LANGUAGE));
            if (languageName != null) {
                return WikiTextPlugin.getDefault().getMarkupLanguage(languageName);
            }
        }
        catch (CoreException e) {
            WikiTextUiPlugin.getDefault().log(4, "Cannot load markup language preference", e);
        }
        return null;
    }

    private void storeMarkupLanguagePreference(MarkupLanguage markupLanguage) {
        if (markupLanguage == null) {
            throw new IllegalArgumentException();
        }
        IFile file = this.getFile();
        if (file != null) {
            String preference;
            MarkupLanguage defaultMarkupLanguage = WikiTextPlugin.getDefault().getMarkupLanguageForFilename(file.getName());
            String string = preference = markupLanguage == null ? null : markupLanguage.getName();
            if (defaultMarkupLanguage != null && defaultMarkupLanguage.getName().equals(preference)) {
                preference = null;
            }
            try {
                file.setPersistentProperty(new QualifiedName(WikiTextUiPlugin.getDefault().getPluginId(), MARKUP_LANGUAGE), preference);
            }
            catch (CoreException e) {
                WikiTextUiPlugin.getDefault().log(4, String.format("Cannot store markup language preference '%s'", preference), e);
            }
        }
    }

    protected MarkupLanguage getMarkupLanguage() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        IDocumentPartitioner partitioner = document.getDocumentPartitioner();
        MarkupLanguage markupLanguage = null;
        if (partitioner instanceof FastMarkupPartitioner) {
            markupLanguage = ((FastMarkupPartitioner)partitioner).getMarkupLanguage();
        }
        return markupLanguage;
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(Messages.getBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    public void setAction(String actionID, IAction action) {
        if (action.getActionDefinitionId() != null) {
            IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
            handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        super.setAction(actionID, action);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        MenuManager markupLanguageMenu = new MenuManager(Messages.getString("MarkupEditor.MarkupLanguage"));
        for (String markupLanguageName : new TreeSet(WikiTextPlugin.getDefault().getMarkupLanguageNames())) {
            markupLanguageMenu.add((IAction)new SetMarkupLanguageAction(this, markupLanguageName, markupLanguage != null && markupLanguageName.equals(markupLanguage.getName())));
        }
        menu.appendToGroup("settings", (IContributionItem)markupLanguageMenu);
    }

    private static class MarkupSourceViewer
    extends SourceViewer {
        public MarkupSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
            super(parent, ruler, styles);
        }

        public MarkupSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        }

        public IReconciler getReconciler() {
            return this.fReconciler;
        }
    }
}

