/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.preferences;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(WikiTextUiPlugin.getDefault().getPreferenceStore());
        this.setDescription("WikiText editor preferences for syntax highlighting.  CSS is used to control font size, color and style.");
    }

    public void createFieldEditors() {
        String preferenceKey;
        Preferences prefs = new Preferences();
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText("Block Modifiers");
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        for (Map.Entry<String, String> ent : prefs.getCssByBlockModifierType().entrySet()) {
            preferenceKey = Preferences.toPreferenceKey(ent.getKey(), true);
            this.addField((FieldEditor)new StringFieldEditor(preferenceKey, ent.getKey(), (Composite)group));
        }
        group = new Group(this.getFieldEditorParent(), 0);
        group.setText("Phrase Modifiers");
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        for (Map.Entry<String, String> ent : prefs.getCssByPhraseModifierType().entrySet()) {
            preferenceKey = Preferences.toPreferenceKey(ent.getKey(), false);
            this.addField((FieldEditor)new StringFieldEditor(preferenceKey, ent.getKey(), (Composite)group));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), String.valueOf(WikiTextUiPlugin.getDefault().getPluginId()) + ".preferences");
    }

    public void init(IWorkbench workbench) {
    }
}

