/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.preferences;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private static final Pattern BAD_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9]");
    public static final String PHRASE_CODE = "@code@";
    public static final String PHRASE_SPAN = "%span%";
    public static final String PHRASE_SUBSCRIPT = "~subscript~";
    public static final String PHRASE_SUPERSCRIPT = "^superscript^";
    public static final String PHRASE_INSERTED_TEXT = "+inserted text+";
    public static final String PHRASE_DELETED_TEXT = "-deleted text-";
    public static final String PHRASE_CITATION = "??citation??";
    public static final String PHRASE_BOLD = "**bold**";
    public static final String PHRASE_ITALIC = "__italic__";
    public static final String PHRASE_STRONG = "*strong*";
    public static final String PHRASE_EMPHASIS = "_emphasis_";
    public static final String PHRASE_MONOSPACE = "monospace";
    public static final String PHRASE_UNDERLINED = "underlined";
    public static final String BLOCK_QUOTE = "bq.";
    public static final String BLOCK_PRE = "pre.";
    public static final String BLOCK_BC = "bc.";
    public static final String BLOCK_H6 = "h6.";
    public static final String BLOCK_H5 = "h5.";
    public static final String BLOCK_H4 = "h4.";
    public static final String BLOCK_H3 = "h3.";
    public static final String BLOCK_H2 = "h2.";
    public static final String BLOCK_H1 = "h1.";
    public static final String[] HEADING_PREFERENCES;
    private final Map<String, String> cssByBlockModifierType = new LinkedHashMap<String, String>();
    private final Map<String, String> cssByPhraseModifierType;

    static {
        String[] stringArray = new String[7];
        stringArray[1] = BLOCK_H1;
        stringArray[2] = BLOCK_H2;
        stringArray[3] = BLOCK_H3;
        stringArray[4] = BLOCK_H4;
        stringArray[5] = BLOCK_H5;
        stringArray[6] = BLOCK_H6;
        HEADING_PREFERENCES = stringArray;
    }

    public Preferences() {
        this.cssByBlockModifierType.put(BLOCK_H1, "font-size: 150%; font-weight: bold;");
        this.cssByBlockModifierType.put(BLOCK_H2, "font-size: 125%; font-weight: bold;");
        this.cssByBlockModifierType.put(BLOCK_H3, "font-size: 110%; font-weight: bold;");
        this.cssByBlockModifierType.put(BLOCK_H4, "font-weight: bold;");
        this.cssByBlockModifierType.put(BLOCK_H5, "font-size: 83%; font-weight: bold;");
        this.cssByBlockModifierType.put(BLOCK_H6, "font-size: 75%; font-weight: bold;");
        this.cssByBlockModifierType.put(BLOCK_BC, "font-family: monospace; color: Blue;");
        this.cssByBlockModifierType.put(BLOCK_PRE, "font-family: monospace; color: Blue;");
        this.cssByBlockModifierType.put(BLOCK_QUOTE, "font-family: monospace; color: rgb(38,86,145);");
        this.cssByPhraseModifierType = new LinkedHashMap<String, String>();
        this.cssByPhraseModifierType.put(PHRASE_EMPHASIS, "font-style: italic;");
        this.cssByPhraseModifierType.put(PHRASE_STRONG, "font-weight: bold;");
        this.cssByPhraseModifierType.put(PHRASE_ITALIC, "font-style: italic;");
        this.cssByPhraseModifierType.put(PHRASE_BOLD, "font-weight: bold;");
        this.cssByPhraseModifierType.put(PHRASE_CITATION, "font-style: italic;");
        this.cssByPhraseModifierType.put(PHRASE_DELETED_TEXT, "text-decoration: line-through;");
        this.cssByPhraseModifierType.put(PHRASE_INSERTED_TEXT, "text-decoration: underline;");
        this.cssByPhraseModifierType.put(PHRASE_SUPERSCRIPT, "font-size: smaller; vertical-align: super;");
        this.cssByPhraseModifierType.put(PHRASE_SUBSCRIPT, "font-size: smaller; vertical-align: sub;");
        this.cssByPhraseModifierType.put(PHRASE_SPAN, "");
        this.cssByPhraseModifierType.put(PHRASE_CODE, "font-family: monospace; color: Blue;");
        this.cssByPhraseModifierType.put(PHRASE_MONOSPACE, "font-family: monospace;");
        this.cssByPhraseModifierType.put(PHRASE_UNDERLINED, "text-decoration: underline;");
    }

    public Map<String, String> getCssByBlockModifierType() {
        return this.cssByBlockModifierType;
    }

    public Map<String, String> getCssByPhraseModifierType() {
        return this.cssByPhraseModifierType;
    }

    public void save(IPreferenceStore store, boolean asDefault) {
        String propKey;
        for (Map.Entry<String, String> ent : this.cssByBlockModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), true);
            if (asDefault) {
                store.setDefault(propKey, ent.getValue());
                continue;
            }
            store.setValue(propKey, ent.getValue());
        }
        for (Map.Entry<String, String> ent : this.cssByPhraseModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), false);
            if (asDefault) {
                store.setDefault(propKey, ent.getValue());
                continue;
            }
            store.setValue(propKey, ent.getValue());
        }
    }

    public static String toPreferenceKey(String key, boolean block) {
        String propKey = String.valueOf(block ? "block-" : "phrase-") + BAD_CHAR_PATTERN.matcher(key).replaceAll("");
        return propKey;
    }

    public void load(IPreferenceStore store) {
        String value;
        String propKey;
        for (Map.Entry<String, String> ent : this.cssByBlockModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), true);
            value = store.getString(propKey);
            if (value == null) continue;
            ent.setValue(value);
        }
        for (Map.Entry<String, String> ent : this.cssByPhraseModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), false);
            value = store.getString(propKey);
            if (value == null) continue;
            ent.setValue(value);
        }
    }
}

