/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Block;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Span;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.CssStyleManager;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.FontState;
import org.eclipse.mylyn.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupTokenScanner
implements ITokenScanner {
    private Token currentToken = null;
    private Iterator<Token> tokenIt = null;
    private final CssStyleManager styleManager;
    private final FontState defaultState;
    private final Preferences preferences;

    public MarkupTokenScanner(Font defaultFont) {
        this.styleManager = new CssStyleManager(defaultFont);
        this.defaultState = this.styleManager.createDefaultFontState();
        this.preferences = WikiTextUiPlugin.getDefault().getPreferences();
    }

    public int getTokenLength() {
        return this.currentToken == null ? -1 : this.currentToken.getLength();
    }

    public int getTokenOffset() {
        return this.currentToken == null ? -1 : this.currentToken.getOffset();
    }

    public IToken nextToken() {
        if (this.tokenIt == null || !this.tokenIt.hasNext()) {
            this.currentToken = null;
            this.tokenIt = null;
            return org.eclipse.jface.text.rules.Token.EOF;
        }
        this.currentToken = this.tokenIt.next();
        return this.currentToken;
    }

    public void setRange(IDocument document, int offset, int length) {
        IDocumentPartitioner partitioner = document.getDocumentPartitioner();
        ArrayList<Token> tokens = null;
        if (partitioner instanceof FastMarkupPartitioner) {
            FastMarkupPartitioner fastMarkupPartitioner = (FastMarkupPartitioner)partitioner;
            ITypedRegion[] partitioning = partitioner.computePartitioning(offset, length);
            if (partitioning != null) {
                tokens = new ArrayList<Token>();
                ITypedRegion[] partitions = ((FastMarkupPartitioner)partitioner).getScanner().computePartitions(document, offset, length);
                int lastEnd = offset;
                StyleRange styleRange = this.styleManager.createStyleRange(this.defaultState, 0, 1);
                TextAttribute textAttribute = new TextAttribute(styleRange.foreground, styleRange.background, styleRange.fontStyle, styleRange.font);
                Token defaultToken = new Token(this.defaultState, textAttribute, offset, length);
                if (partitions != null) {
                    ITypedRegion[] iTypedRegionArray = partitions;
                    int n = partitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypedRegion region = iTypedRegionArray[n2];
                        if (region.getOffset() >= offset + length) break;
                        if (region.getOffset() + region.getLength() >= offset && region instanceof FastMarkupPartitioner.MarkupPartition) {
                            int realLastEnd;
                            int diff;
                            int partitionEnd;
                            Token blockBridgeToken;
                            int blockTokenLength;
                            int blockTokenStartOffset;
                            List<Span> spans;
                            Token blockToken;
                            FastMarkupPartitioner.MarkupPartition partition = (FastMarkupPartitioner.MarkupPartition)region;
                            if (lastEnd < partition.getOffset()) {
                                Token blockBridgeToken2 = new Token(defaultToken.fontState, defaultToken.getData(), lastEnd, partition.getOffset() - lastEnd);
                                this.addToken(tokens, blockBridgeToken2);
                            }
                            if ((blockToken = this.createToken(partition)) == null) {
                                blockToken = defaultToken;
                            }
                            if (!partition.getBlock().isSpansComputed()) {
                                fastMarkupPartitioner.reparse(document, partition.getBlock());
                            }
                            if ((spans = partition.getSpans()) != null) {
                                for (Span span : spans) {
                                    Token spanToken;
                                    if (span.getOffset() < lastEnd || (spanToken = this.createToken(blockToken.getFontState(), span)) == null) continue;
                                    int n3 = blockTokenStartOffset = lastEnd < offset ? offset : lastEnd;
                                    if (blockTokenStartOffset < spanToken.getOffset()) {
                                        blockTokenLength = spanToken.getOffset() - blockTokenStartOffset;
                                        blockBridgeToken = new Token(blockToken.fontState, blockToken.getData(), blockTokenStartOffset, blockTokenLength);
                                        this.addToken(tokens, blockBridgeToken);
                                    }
                                    this.addToken(tokens, spanToken);
                                    lastEnd = spanToken.offset + spanToken.length;
                                    if (lastEnd <= partition.getOffset() + partition.getLength()) continue;
                                    throw new IllegalStateException();
                                }
                            }
                            if (lastEnd < (partitionEnd = partition.getOffset() + partition.getLength()) && (diff = partitionEnd - (realLastEnd = Math.max(lastEnd, partition.getOffset()))) > 0) {
                                blockTokenStartOffset = realLastEnd;
                                blockTokenLength = diff;
                                blockBridgeToken = new Token(blockToken.fontState, blockToken.getData(), blockTokenStartOffset, blockTokenLength);
                                this.addToken(tokens, blockBridgeToken);
                                lastEnd = blockTokenStartOffset + blockTokenLength;
                                if (lastEnd > partition.getOffset() + partition.getLength()) {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (lastEnd < offset + length) {
                    this.addToken(tokens, new Token(defaultToken.fontState, defaultToken.getData(), lastEnd, length - (lastEnd - offset)));
                }
            }
        }
        this.currentToken = null;
        if (tokens == null || tokens.isEmpty()) {
            this.tokenIt = null;
        } else {
            Iterator it = tokens.iterator();
            while (it.hasNext()) {
                Token next = (Token)((Object)it.next());
                if (next.getOffset() < offset) {
                    it.remove();
                    continue;
                }
                if (next.getOffset() + next.getLength() <= offset + length) continue;
                it.remove();
            }
            this.tokenIt = tokens.iterator();
        }
    }

    private void addToken(List<Token> tokens, Token newToken) {
        this.checkAddToken(tokens, newToken);
        tokens.add(newToken);
    }

    private void checkAddToken(List<Token> tokens, Token newToken) {
        if (newToken.getLength() <= 0) {
            throw new IllegalStateException(String.format("Bad token length %s", newToken.getLength()));
        }
        if (newToken.getOffset() < 0) {
            throw new IllegalStateException(String.format("Bad token offset %s", newToken.getOffset()));
        }
        if (!tokens.isEmpty()) {
            Token previous = tokens.get(tokens.size() - 1);
            if (previous.getOffset() >= newToken.getOffset()) {
                throw new IllegalStateException("New token starts on or before previous");
            }
            if (previous.getOffset() + previous.getLength() > newToken.getOffset()) {
                throw new IllegalStateException("New token starts before the end of the previous");
            }
        }
    }

    private Token createToken(FontState parentState, Span span) {
        if (span.getLength() == 0) {
            return null;
        }
        String cssStyles = null;
        String key = null;
        switch (span.getType()) {
            case BOLD: {
                key = "**bold**";
                break;
            }
            case CITATION: {
                key = "??citation??";
                break;
            }
            case CODE: {
                key = "@code@";
                break;
            }
            case DELETED: {
                key = "-deleted text-";
                break;
            }
            case EMPHASIS: {
                key = "_emphasis_";
                break;
            }
            case INSERTED: {
                key = "+inserted text+";
                break;
            }
            case ITALIC: {
                key = "__italic__";
                break;
            }
            case MONOSPACE: {
                key = "monospace";
                break;
            }
            case SPAN: {
                key = "%span%";
                break;
            }
            case STRONG: {
                key = "*strong*";
                break;
            }
            case SUBSCRIPT: {
                key = "~subscript~";
                break;
            }
            case SUPERSCRIPT: {
                key = "^superscript^";
                break;
            }
            case UNDERLINED: {
                key = "underlined";
            }
        }
        cssStyles = this.preferences.getCssByPhraseModifierType().get(key);
        if (cssStyles == null && span.getAttributes().getCssStyle() == null) {
            return null;
        }
        FontState fontState = new FontState(parentState);
        if (cssStyles != null) {
            this.styleManager.processCssStyles(fontState, parentState, cssStyles);
        }
        if (span.getAttributes().getCssStyle() != null) {
            this.styleManager.processCssStyles(fontState, parentState, span.getAttributes().getCssStyle());
        }
        StyleRange styleRange = this.styleManager.createStyleRange(fontState, 0, 1);
        TextAttribute textAttribute = new TextAttribute(styleRange.foreground, styleRange.background, styleRange.fontStyle, styleRange.font);
        return new Token(fontState, textAttribute, span.getOffset(), span.getLength());
    }

    private Token createToken(FastMarkupPartitioner.MarkupPartition partition) {
        if (partition.getLength() == 0) {
            return null;
        }
        FontState fontState = new FontState(this.defaultState);
        boolean hasStyles = this.processStyles(partition.getBlock(), partition, fontState);
        if (partition.getBlock().getAttributes().getCssStyle() != null) {
            this.styleManager.processCssStyles(fontState, this.defaultState, partition.getBlock().getAttributes().getCssStyle());
        } else if (!hasStyles) {
            return null;
        }
        StyleRange styleRange = this.styleManager.createStyleRange(fontState, 0, 1);
        TextAttribute textAttribute = new TextAttribute(styleRange.foreground, styleRange.background, styleRange.fontStyle, styleRange.font);
        return new Token(fontState, textAttribute, partition.getOffset(), partition.getLength());
    }

    private boolean processStyles(Block block, FastMarkupPartitioner.MarkupPartition partition, FontState fontState) {
        String cssStyles;
        boolean hasStyles = false;
        if (block.getParent() != null) {
            hasStyles = this.processStyles(block.getParent(), partition, fontState);
        }
        if ((cssStyles = this.computeCssStyles(block, partition)) != null) {
            hasStyles = true;
            this.styleManager.processCssStyles(fontState, this.defaultState, cssStyles);
        }
        return hasStyles;
    }

    private String computeCssStyles(Block block, FastMarkupPartitioner.MarkupPartition partition) {
        String cssStyles = null;
        if (block.getHeadingLevel() > 0) {
            cssStyles = this.preferences.getCssByBlockModifierType().get(Preferences.HEADING_PREFERENCES[block.getHeadingLevel()]);
        } else if (block.getType() != null) {
            String key = null;
            switch (block.getType()) {
                case CODE: {
                    key = "bc.";
                    break;
                }
                case QUOTE: {
                    key = "bq.";
                    break;
                }
                case PREFORMATTED: {
                    key = "pre.";
                }
            }
            cssStyles = this.preferences.getCssByBlockModifierType().get(key);
        }
        return cssStyles;
    }

    private static class Token
    extends org.eclipse.jface.text.rules.Token {
        private final int offset;
        private final int length;
        private final FontState fontState;

        public Token(FontState fontState, TextAttribute attribute, int offset, int length) {
            super((Object)attribute);
            this.fontState = fontState;
            if (offset < 0) {
                throw new IllegalArgumentException();
            }
            if (length < 0) {
                throw new IllegalArgumentException();
            }
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public FontState getFontState() {
            return this.fontState;
        }

        public TextAttribute getData() {
            return (TextAttribute)super.getData();
        }
    }
}

