/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.validation;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.DocumentRegionValidator;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMarkerMarkupValidator
extends DocumentRegionValidator {
    @Override
    protected void clearProblems(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        IMarker[] findMarkers = this.resource.findMarkers("org.eclipse.mylyn.wikitext.core.validation.problem", true, 0);
        monitor.beginTask("clearing markers", findMarkers.length == 0 ? 1 : findMarkers.length);
        IMarker[] iMarkerArray = findMarkers;
        int n = findMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            IMarker marker = iMarkerArray[n2];
            int offset = marker.getAttribute("charStart", 0);
            if (this.overlaps(region, offset, (end = marker.getAttribute("charEnd", offset)) - offset) || offset >= document.getLength()) {
                marker.delete();
            }
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
    }

    @Override
    protected void createProblems(IProgressMonitor monitor, IDocument document, IRegion region, List<ValidationProblem> problems) throws CoreException {
        if (problems.isEmpty()) {
            return;
        }
        monitor.beginTask("creating markers", problems.size());
        for (ValidationProblem problem : problems) {
            IMarker marker = this.resource.createMarker(problem.getMarkerId());
            marker.setAttribute("transient", true);
            marker.setAttribute("severity", this.toMarkerSeverity(problem.getSeverity()));
            marker.setAttribute("message", (Object)problem.getMessage());
            marker.setAttribute("charStart", problem.getOffset());
            marker.setAttribute("charEnd", problem.getOffset() + problem.getLength());
            try {
                int line = document.getLineOfOffset(problem.getOffset());
                marker.setAttribute("lineNumber", line + 1);
            }
            catch (BadLocationException badLocationException) {}
            monitor.worked(1);
        }
        monitor.done();
    }

    private int toMarkerSeverity(ValidationProblem.Severity severity) {
        switch (severity) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
        }
        throw new IllegalStateException(severity.name());
    }
}

