/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor;
import org.eclipse.mylyn.wikitext.core.WikiTextPlugin;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMarkupResourceHandler
extends AbstractHandler {
    protected MarkupLanguage markupLanguage;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = null;
        try {
            currentSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        }
        catch (Exception exception) {}
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            Object o = structuredSelection.getFirstElement();
            IFile file = null;
            if (o instanceof IAdaptable) {
                file = (IFile)((IAdaptable)o).getAdapter(IFile.class);
            }
            if (file != null) {
                String name = file.getName();
                int idxOfDot = name.lastIndexOf(46);
                if (idxOfDot != -1) {
                    name = name.substring(0, idxOfDot);
                }
                MarkupLanguage prev = this.markupLanguage;
                try {
                    if (this.markupLanguage == null) {
                        this.markupLanguage = MarkupEditor.loadMarkupLanguagePreference(file);
                        if (this.markupLanguage == null) {
                            this.markupLanguage = WikiTextPlugin.getDefault().getMarkupLanguageForFilename(file.getName());
                        }
                        if (this.markupLanguage == null) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unexpected Error", (String)String.format("Cannot guess markup language for file '%s'", file.getName()));
                            return null;
                        }
                    }
                    this.handleFile(file, name);
                }
                finally {
                    this.markupLanguage = prev;
                }
            }
        }
        return null;
    }

    protected abstract void handleFile(IFile var1, String var2);

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }
}

