/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.xplanner.core.XPlannerClientManager;
import org.eclipse.mylyn.xplanner.core.XPlannerCorePlugin;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.core.service.exceptions.AuthenticationException;
import org.eclipse.mylyn.xplanner.core.service.exceptions.ServiceUnavailableException;
import org.eclipse.mylyn.xplanner.ui.Messages;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryConnector;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;

public class XPlannerClientFacade
implements IRepositoryListener {
    private XPlannerClientManager clientManager = null;
    private static XPlannerClientFacade instance = null;

    public XPlannerClientFacade() {
        TasksUi.getRepositoryManager().addListener((IRepositoryListener)this);
        this.clientManager = XPlannerCorePlugin.getDefault().getClientManager();
    }

    public XPlannerClient getXPlannerClient(TaskRepository taskRepository) throws CoreException {
        try {
            XPlannerRepositoryUtils.checkRepositoryValidated(taskRepository.getRepositoryUrl());
            String serverHostname = XPlannerClientFacade.getServerHost(taskRepository);
            XPlannerClient client = this.clientManager.getClient(serverHostname);
            AuthenticationCredentials repositoryCredentials = taskRepository.getCredentials(AuthenticationType.REPOSITORY);
            AuthenticationCredentials httpCredentials = taskRepository.getCredentials(AuthenticationType.HTTP);
            XPlannerRepositoryConnector connector = (XPlannerRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("xplanner");
            TaskRepositoryLocationFactory locationFactory = connector.getTaskRepositoryLocationFactory();
            AbstractWebLocation location = locationFactory.createWebLocation(taskRepository);
            String repositoryUrl = taskRepository.getRepositoryUrl();
            String repositoryUserName = repositoryCredentials.getUserName();
            String repositoryPassword = repositoryCredentials.getPassword();
            Proxy proxy = location.getProxyForHost(location.getUrl(), "HTTP");
            String httpUserName = httpCredentials == null ? null : httpCredentials.getUserName();
            String httpPassword = httpCredentials == null ? null : httpCredentials.getPassword();
            client = this.clientManager.createClient(serverHostname, repositoryUrl, false, repositoryUserName, repositoryPassword, false, proxy, httpUserName, httpPassword);
            this.clientManager.addClient(client);
            if (client == null) {
                throw new ServiceUnavailableException(String.valueOf(serverHostname) + " " + taskRepository.getRepositoryUrl());
            }
            return client;
        }
        catch (CoreException ce) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", String.valueOf(Messages.XPlannerClientFacade_SERVER_CONNECTION_ERROR) + ": " + ce.getMessage()));
        }
        catch (ServiceUnavailableException sue) {
            throw sue;
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", Messages.XPlannerClientFacade_SERVER_CONNECTION_ERROR, (Throwable)e));
            throw e;
        }
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static XPlannerClientFacade getDefault() {
        if (instance == null) {
            instance = new XPlannerClientFacade();
        }
        return instance;
    }

    public void logOutFromAll() {
        try {
            XPlannerClient[] allClients;
            XPlannerClient[] xPlannerClientArray = allClients = this.clientManager.getAllClients();
            int n = allClients.length;
            int n2 = 0;
            while (n2 < n) {
                XPlannerClient allClient = xPlannerClientArray[n2];
                allClient.logout();
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public void repositoriesRead() {
    }

    public void repositoryAdded(TaskRepository repository) {
        if (repository.getConnectorKind().equals("xplanner")) {
            try {
                this.getXPlannerClient(repository);
            }
            catch (CoreException coreException) {}
        }
    }

    public void repositoryRemoved(TaskRepository repository) {
        if (repository.getConnectorKind().equals("xplanner")) {
            String serverHostname = XPlannerClientFacade.getServerHost(repository);
            XPlannerClient client = this.clientManager.getClient(serverHostname);
            this.removeClient(client);
            XPlannerRepositoryUtils.removeValidatedRepositoryUrl(repository.getRepositoryUrl());
        }
    }

    public void repositorySettingsChanged(TaskRepository repository) {
        this.repositoryRemoved(repository);
        this.repositoryAdded(repository);
    }

    public void refreshClientSettings(TaskRepository repository) {
        try {
            XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            if (client != null) {
                client.refreshDetails();
            }
        }
        catch (Exception e) {
            String reason = e.getLocalizedMessage();
            if (reason == null || reason.length() == 0) {
                reason = e.getClass().getName();
            }
            StatusHandler.log((IStatus)new Status(0, "org.eclipse.mylyn.xplanner.ui", 4, MessageFormat.format(Messages.XPlannerRepositoryConnector_PerformQueryFailure, reason), (Throwable)e));
        }
    }

    private void removeClient(XPlannerClient client) {
        if (client != null) {
            client.logout();
            this.clientManager.removeClient(client);
        }
    }

    public void validateServerAndCredentials(String serverUrl, String user, String password, Proxy proxy, String httpUser, String httpPassword) throws Exception {
        XPlannerRepositoryUtils.removeValidatedRepositoryUrl(serverUrl);
        this.clientManager.testConnection(serverUrl, user, password, proxy, httpUser, httpPassword);
        XPlannerRepositoryUtils.addValidatedRepositoryUrl(serverUrl);
    }

    private static String getServerHost(TaskRepository repository) {
        try {
            return new URL(repository.getRepositoryUrl()).getHost();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(String.valueOf(Messages.XPlannerClientFacade_INVALID_URL_EXCEPTION) + repository.getRepositoryUrl(), ex);
        }
    }

    public static void handleConnectionException(Exception e) {
        if (e instanceof ServiceUnavailableException) {
            TasksUiInternal.displayStatus((String)"XPlanner", (IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", String.valueOf(Messages.XPlannerClientFacade_CONNECTION_FAILURE_ERROR) + Messages.XPlannerClientFacade_NETWORK_CONNECTION_FAILURE, (Throwable)e));
        } else if (e instanceof AuthenticationException) {
            TasksUiInternal.displayStatus((String)"XPlanner", (IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", String.valueOf(Messages.XPlannerClientFacade_AUTHENTICATION_FAILED) + Messages.XPlannerClientFacade_USERNAME_PASSWORD_ERROR, (Throwable)e));
        } else if (e instanceof RuntimeException) {
            TasksUiInternal.displayStatus((String)"XPlanner", (IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", String.valueOf(Messages.XPlannerClientFacade_NO_REPOSITORY_FOUND) + Messages.XPlannerClientFacade_VERIFY_VALID_REPOSITORY, (Throwable)e));
        } else {
            TasksUiInternal.displayStatus((String)"XPlanner", (IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", String.valueOf(Messages.XPlannerClientFacade_COULD_NOT_CONNECT_TO_REPOSITORY) + Messages.XPlannerClientFacade_CHECK_CREDENTIALS, (Throwable)e));
        }
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }
}

