/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.editor;

import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.xplanner.ui.editor.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.PersonData;
import org.xplanner.soap.ProjectData;
import org.xplanner.soap.UserStoryData;

public class XPlannerUserStoryEditor
extends FormPage {
    private static final String NO_PROJECT_NAME = Messages.XPlannerTaskEditor_NO_PROJECT_NAME;
    private static final String NO_ITERATION_NAME = Messages.XPlannerTaskEditor_NO_ITERATION_NAME;
    private static final String NO_STORY_NAME = Messages.XPlannerTaskEditor_NO_STORY_NAME;
    private static final String NO_TRACKER_NAME = Messages.XPlannerUserStoryEditor_NO_TRACKER_NAME;
    private TaskEditorInput input;
    private boolean isDirty = false;
    private XPlannerClient client;
    private UserStoryData userStoryData;

    public XPlannerUserStoryEditor(FormEditor parent) {
        super(parent, "id", "label");
    }

    public void doSave(IProgressMonitor monitor) {
        this.isDirty = false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) {
        if (!(input instanceof TaskEditorInput)) {
            return;
        }
        TaskEditorInput repositoryInput = (TaskEditorInput)input;
        if (!"xplanner".equals(repositoryInput.getTaskRepository().getConnectorKind())) {
            return;
        }
        this.input = repositoryInput;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(this.input.getName());
        try {
            TaskData taskData = TasksUi.getTaskDataManager().getTaskData(repositoryInput.getTask());
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(taskData.getConnectorKind(), taskData.getRepositoryUrl());
            this.client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            String id = taskData.getTaskId();
            if (id == null || id.trim().equals("")) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", Messages.XPlannerTaskEditor_NO_TASK_KEY_EXCEPTION));
            } else {
                this.setUserStoryData(id);
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", "Error initializing task editor", (Throwable)e));
        }
    }

    public void setUserStoryData(String key) {
        try {
            this.userStoryData = this.client.getUserStory(Integer.valueOf(key).intValue());
        }
        catch (NumberFormatException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", "Error formatting user story key", (Throwable)e));
        }
        catch (RemoteException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", "Error retrieving user story: " + key, (Throwable)e));
        }
    }

    public UserStoryData getUserStoryData() {
        return this.userStoryData;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String getFormTitle() {
        return MessageFormat.format(Messages.XPlannerUserStoryEditor_STORY_TITLE, this.getUserStoryData().getName(), String.valueOf(this.getUserStoryData().getId()), String.valueOf(this.getUserStoryData().getActualHours()));
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getFormTitle());
        Composite formBody = form.getBody();
        formBody.setLayout((Layout)new GridLayout(1, false));
        this.createHierarchySection(toolkit, formBody);
        this.createDescriptionSection(toolkit, formBody);
        this.createDataSection(toolkit, formBody);
        form.reflow(true);
    }

    private void createHierarchySection(FormToolkit toolkit, Composite formBody) {
        Section hierarchySection = toolkit.createSection(formBody, 258);
        hierarchySection.setText(Messages.XPlannerTaskEditor_HIERARCHY_SECTION_TITLE);
        hierarchySection.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hierarchySection);
        hierarchySection.setExpanded(true);
        Composite hierarchyComposite = toolkit.createComposite((Composite)hierarchySection, 0);
        GridLayout hierarchyGridLayout = new GridLayout(1, false);
        hierarchyGridLayout.marginWidth = 0;
        hierarchyComposite.setLayout((Layout)hierarchyGridLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hierarchyComposite);
        hierarchySection.setClient((Control)hierarchyComposite);
        Tree hierarchyTree = toolkit.createTree(hierarchyComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(200, 80).applyTo((Control)hierarchyTree);
        TreeItem projectItem = new TreeItem(hierarchyTree, 0);
        projectItem.setText(this.getProjectName());
        TreeItem iterationItem = new TreeItem(projectItem, 0);
        iterationItem.setText(this.getIterationName());
        TreeItem storyItem = new TreeItem(iterationItem, 0);
        storyItem.setText(this.getStoryName());
        hierarchyTree.showItem(storyItem);
    }

    private void createDescriptionSection(FormToolkit toolkit, Composite formBody) {
        Section descriptionSection = toolkit.createSection(formBody, 258);
        descriptionSection.setText(Messages.XPlannerTaskEditor_DESCRIPTION_SECTION_TITLE);
        descriptionSection.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)descriptionSection);
        descriptionSection.setExpanded(true);
        Composite descriptionComposite = toolkit.createComposite((Composite)descriptionSection, 0);
        GridLayout descriptionCompositeLayout = new GridLayout(1, true);
        descriptionCompositeLayout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)descriptionCompositeLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)descriptionComposite);
        Text descriptionText = toolkit.createText(descriptionComposite, this.getUserStoryData().getDescription(), 768);
        descriptionText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)descriptionText);
        descriptionSection.setClient((Control)descriptionComposite);
    }

    private void createDataSection(FormToolkit toolkit, Composite formBody) {
        Section dataSection = toolkit.createSection(formBody, 258);
        dataSection.setText(Messages.XPlannerTaskEditor_DATA_SECTION_TITLE);
        dataSection.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 128).applyTo((Control)dataSection);
        dataSection.setExpanded(true);
        Composite dataComposite = toolkit.createComposite((Composite)dataSection, 2048);
        dataComposite.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dataComposite);
        dataSection.setClient((Control)dataComposite);
        Label priorityLabel = toolkit.createLabel(dataComposite, Messages.XPlannerUserStoryEditor_PRIORITY_LABEL);
        priorityLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 2).applyTo((Control)priorityLabel);
        Label priorityValue = toolkit.createLabel(dataComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 2).applyTo((Control)priorityValue);
        priorityValue.setText(String.valueOf(this.getUserStoryData().getPriority()));
        Label estimatedHoursLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ESTIMATED_HOURS_TEXT);
        estimatedHoursLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        toolkit.createLabel(dataComposite, String.valueOf(this.getUserStoryData().getAdjustedEstimatedHours()) + " (" + this.getUserStoryData().getEstimatedOriginalHours() + ")");
        Label actualTimeLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ACTUAL_HOURS_TEXT);
        actualTimeLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        toolkit.createLabel(dataComposite, String.valueOf(this.getUserStoryData().getActualHours()));
        Label trackerLabel = toolkit.createLabel(dataComposite, Messages.XPlannerUserStoryEditor_TRACKER_LABEL);
        trackerLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)trackerLabel);
        Label trackerValue = toolkit.createLabel(dataComposite, this.getTrackerName());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)trackerValue);
        Label remainingHoursLabel = toolkit.createLabel(dataComposite, Messages.XPlannerUserStoryEditor_REMAINING_HOURS_LABEL);
        remainingHoursLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        toolkit.createLabel(dataComposite, String.valueOf(this.getUserStoryData().getRemainingHours()));
        Label lastUpdatedTimeLabel = toolkit.createLabel(dataComposite, Messages.XPlannerUserStoryEditor_LAST_UPDATE_LABEL);
        lastUpdatedTimeLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)lastUpdatedTimeLabel);
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        Label lastUpdatedTimeValue = toolkit.createLabel(dataComposite, String.valueOf(dateFormat.format(((GregorianCalendar)this.getUserStoryData().getLastUpdateTime()).getTime())));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)lastUpdatedTimeValue);
        Label dispositionLabel = toolkit.createLabel(dataComposite, Messages.XPlannerUserStoryEditor_DISPOSITION_LABEL);
        dispositionLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        toolkit.createLabel(dataComposite, this.getUserStoryData().getDispositionName());
        Button completedButton = toolkit.createButton(dataComposite, Messages.XPlannerTaskEditor_COMPLETED_BUTTON, 32);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)completedButton);
        completedButton.setSelection(this.userStoryData.isCompleted());
        completedButton.setEnabled(false);
    }

    private String getProjectName() {
        String projectName = NO_PROJECT_NAME;
        try {
            ProjectData project;
            IterationData iteration = this.client.getIteration(this.userStoryData.getIterationId());
            if (iteration != null && (project = this.client.getProject(iteration.getProjectId())) != null) {
                projectName = project.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return projectName;
    }

    private String getIterationName() {
        String iterationName = NO_ITERATION_NAME;
        try {
            IterationData iteration = this.client.getIteration(this.userStoryData.getIterationId());
            if (iteration != null) {
                iterationName = iteration.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterationName;
    }

    private String getStoryName() {
        String storyName = NO_STORY_NAME;
        try {
            storyName = this.userStoryData.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return storyName;
    }

    private String getTrackerName() {
        String acceptorName = NO_TRACKER_NAME;
        try {
            PersonData personData = this.client.getPerson(this.getUserStoryData().getTrackerId());
            if (personData != null) {
                acceptorName = personData.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return acceptorName;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }
}

