/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListTableSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

class SortyByDropDownAction
extends Action
implements IMenuCreator {
    private final TaskListView taskListView;
    private static final String LABEL = "Sort by";
    private Action byPriority;
    private Action bySummary;
    private Action byDateCreated;
    private Menu dropDownMenu = null;

    public SortyByDropDownAction(TaskListView taskListView) {
        this.taskListView = taskListView;
        this.setText(LABEL);
        this.setToolTipText(LABEL);
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public void addActionsToMenu() {
        this.byPriority = new Action("", 2){

            public void run() {
                SortyByDropDownAction.this.taskListView.getSorter().setSortByIndex(TaskListTableSorter.SortByIndex.PRIORITY);
                SortyByDropDownAction.this.byPriority.setChecked(true);
                SortyByDropDownAction.this.bySummary.setChecked(false);
                SortyByDropDownAction.this.byDateCreated.setChecked(false);
            }
        };
        this.byPriority.setEnabled(true);
        this.byPriority.setText("Priority");
        this.byPriority.setImageDescriptor(CommonImages.PRIORITY_1);
        new ActionContributionItem((IAction)this.byPriority).fill(this.dropDownMenu, -1);
        this.bySummary = new Action("", 2){

            public void run() {
                SortyByDropDownAction.this.taskListView.getSorter().setSortByIndex(TaskListTableSorter.SortByIndex.SUMMARY);
                SortyByDropDownAction.this.byPriority.setChecked(false);
                SortyByDropDownAction.this.bySummary.setChecked(true);
                SortyByDropDownAction.this.byDateCreated.setChecked(false);
            }
        };
        this.bySummary.setEnabled(true);
        this.bySummary.setText("Summary");
        new ActionContributionItem((IAction)this.bySummary).fill(this.dropDownMenu, -1);
        this.byDateCreated = new Action("", 2){

            public void run() {
                SortyByDropDownAction.this.taskListView.getSorter().setSortByIndex(TaskListTableSorter.SortByIndex.DATE_CREATED);
                SortyByDropDownAction.this.byPriority.setChecked(false);
                SortyByDropDownAction.this.bySummary.setChecked(false);
                SortyByDropDownAction.this.byDateCreated.setChecked(true);
            }
        };
        this.byDateCreated.setEnabled(true);
        this.byDateCreated.setText("Date Created");
        this.byDateCreated.setImageDescriptor(CommonImages.CALENDAR_SMALL);
        new ActionContributionItem((IAction)this.byDateCreated).fill(this.dropDownMenu, -1);
        new Separator().fill(this.dropDownMenu, -1);
        Action reverse = new Action("", 2){

            public void run() {
                SortyByDropDownAction.this.taskListView.getSorter().setSortDirection(SortyByDropDownAction.this.taskListView.getSorter().getSortDirection() * -1);
                this.setChecked(SortyByDropDownAction.this.taskListView.getSorter().getSortDirection() < 0);
            }
        };
        reverse.setEnabled(true);
        reverse.setText("Descending");
        reverse.setChecked(this.taskListView.getSorter().getSortDirection() < 0);
        new ActionContributionItem((IAction)reverse).fill(this.dropDownMenu, -1);
        switch (this.taskListView.getSorter().getSortByIndex()) {
            case PRIORITY: {
                this.byPriority.setChecked(true);
                break;
            }
            case SUMMARY: {
                this.bySummary.setChecked(true);
                break;
            }
            case DATE_CREATED: {
                this.byDateCreated.setChecked(true);
            }
        }
    }

    public void run() {
        this.setChecked(this.isChecked());
    }
}

