/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.AbstractRetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TaskTransfer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.QueryImportAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListDropAdapter
extends ViewerDropAdapter {
    private AbstractTask newTask = null;
    private TransferData currentTransfer;

    public TaskListDropAdapter(Viewer viewer) {
        super(viewer);
        this.setFeedbackEnabled(true);
    }

    public void dragOver(DropTargetEvent event) {
        if (event.detail == 0 && (event.operations & 4) == 4) {
            event.detail = 4;
        }
        super.dragOver(event);
    }

    public boolean performDrop(Object data) {
        int n;
        int n2;
        Object[] objectArray;
        if (data == null) {
            return false;
        }
        Object currentTarget = this.getCurrentTarget();
        ArrayList<ITask> tasksToMove = new ArrayList<ITask>();
        if (this.isUrl(data) && this.createTaskFromUrl(data)) {
            tasksToMove.add((ITask)this.newTask);
        } else if (TaskTransfer.getInstance().isSupportedType(this.currentTransfer) && data instanceof ITask[]) {
            ITask[] tasks;
            objectArray = tasks = (ITask[])data;
            n2 = tasks.length;
            n = 0;
            while (n < n2) {
                ITask task = objectArray[n];
                if (task != null) {
                    tasksToMove.add(task);
                }
                ++n;
            }
        } else if (data instanceof String && this.createTaskFromString((String)data)) {
            tasksToMove.add((ITask)this.newTask);
        } else if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            String[] names = (String[])data;
            objectArray = names;
            n2 = names.length;
            n = 0;
            while (n < n2) {
                ITask path = objectArray[n];
                final File file = new File((String)path);
                final ArrayList<RepositoryQuery> queries = new ArrayList<RepositoryQuery>();
                final HashSet<TaskRepository> repositories = new HashSet<TaskRepository>();
                final List<AbstractTask> readTasks = TasksUiPlugin.getTaskListManager().getTaskListWriter().readTasks(file);
                if (file.isFile()) {
                    try {
                        List<RepositoryQuery> readQueries = TasksUiPlugin.getTaskListManager().getTaskListWriter().readQueries(file);
                        if (readQueries.size() > 0) {
                            queries.addAll(readQueries);
                            repositories.addAll(TasksUiPlugin.getTaskListManager().getTaskListWriter().readRepositories(file));
                        } else {
                            repositories.addAll(TasksUiPlugin.getTaskListManager().getTaskListWriter().readRepositories(file));
                        }
                    }
                    catch (IOException iOException) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "The specified file \"" + file.getName() + "\" is not an exported query. Please, check that you have provided the correct file."));
                    }
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (queries.size() > 0) {
                            new QueryImportAction().importQueries(queries, repositories, TaskListDropAdapter.this.getViewer().getControl().getShell());
                        } else {
                            TasksUiInternal.importTasks(readTasks, repositories, file, TaskListDropAdapter.this.getViewer().getControl().getShell());
                        }
                    }
                });
                ++n;
            }
        }
        if (currentTarget instanceof LocalTask && this.areAllLocalTasks(tasksToMove) && this.getCurrentLocation() == 3 && TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.subtasks.local")) {
            for (ITask task : tasksToMove) {
                if (((AbstractTask)task).contains(((LocalTask)currentTarget).getHandleIdentifier())) continue;
                TasksUiInternal.getTaskList().addTask(task, (AbstractTaskContainer)((LocalTask)currentTarget));
            }
        } else {
            for (ITask task : tasksToMove) {
                if (currentTarget instanceof UncategorizedTaskContainer) {
                    TasksUiInternal.getTaskList().addTask(task, (AbstractTaskContainer)((UncategorizedTaskContainer)currentTarget));
                    continue;
                }
                if (currentTarget instanceof TaskCategory) {
                    TasksUiInternal.getTaskList().addTask(task, (AbstractTaskContainer)((TaskCategory)currentTarget));
                    continue;
                }
                if (currentTarget instanceof UnmatchedTaskContainer) {
                    if (!((UnmatchedTaskContainer)currentTarget).getRepositoryUrl().equals(task.getRepositoryUrl())) continue;
                    TasksUiInternal.getTaskList().addTask(task, (AbstractTaskContainer)((AbstractTaskCategory)currentTarget));
                    continue;
                }
                if (currentTarget instanceof ITask) {
                    ITask targetTask = (ITask)currentTarget;
                    AbstractTaskCategory targetCategory = null;
                    AbstractTaskCategory container = TaskCategory.getParentTaskCategory((ITask)targetTask);
                    if (container instanceof TaskCategory || container instanceof UncategorizedTaskContainer) {
                        targetCategory = container;
                    } else if (container instanceof UnmatchedTaskContainer && ((UnmatchedTaskContainer)container).getRepositoryUrl().equals(task.getRepositoryUrl())) {
                        targetCategory = container;
                    }
                    if (targetCategory == null) continue;
                    TasksUiInternal.getTaskList().addTask(task, (AbstractTaskContainer)targetCategory);
                    continue;
                }
                if (currentTarget instanceof ScheduledTaskContainer) {
                    ScheduledTaskContainer container = (ScheduledTaskContainer)currentTarget;
                    if (container instanceof TaskScheduleContentProvider.Unscheduled) {
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)task, null);
                        continue;
                    }
                    TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)task, container.getDateRange());
                    continue;
                }
                if (currentTarget != null) continue;
                TasksUiInternal.getTaskList().addTask((ITask)this.newTask, (AbstractTaskContainer)TasksUiPlugin.getTaskList().getDefaultCategory());
            }
        }
        if (this.newTask != null) {
            StructuredSelection ss = new StructuredSelection((Object)this.newTask);
            this.getViewer().setSelection((ISelection)ss);
        }
        return true;
    }

    private boolean areAllLocalTasks(List<ITask> tasksToMove) {
        for (ITask task : tasksToMove) {
            if (task instanceof LocalTask) continue;
            return false;
        }
        return true;
    }

    public boolean isUrl(Object data) {
        String uri = "";
        return data instanceof String && ((uri = (String)data).startsWith("http://") || uri.startsWith("https://"));
    }

    public boolean createTaskFromUrl(Object data) {
        if (!(data instanceof String)) {
            return false;
        }
        String[] urlTransfer = ((String)data).split("\n");
        String url = "";
        String urlTitle = "<retrieving from URL>";
        if (urlTransfer.length <= 0) {
            return false;
        }
        url = urlTransfer[0];
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(url);
        if (connector != null) {
            String repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url);
            String id = connector.getTaskIdFromTaskUrl(url);
            if (repositoryUrl == null || id == null) {
                return false;
            }
            for (TaskRepository repository : TasksUi.getRepositoryManager().getRepositories(connector.getConnectorKind())) {
                if (!repository.getRepositoryUrl().equals(repositoryUrl)) continue;
                try {
                    this.newTask = (AbstractTask)TasksUiInternal.createTask(repository, id, (IProgressMonitor)new NullProgressMonitor());
                    TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)this.newTask);
                    return true;
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create task", (Throwable)e));
                    return false;
                }
            }
            return false;
        }
        this.retrieveTaskDescription(url);
        this.newTask = TasksUiInternal.createNewLocalTask(urlTitle);
        if (this.newTask == null) {
            return false;
        }
        this.newTask.setUrl(url);
        TasksUiUtil.openTask((ITask)this.newTask);
        return true;
    }

    public boolean createTaskFromString(String title) {
        this.newTask = TasksUiInternal.createNewLocalTask(title);
        if (this.newTask == null) {
            return false;
        }
        TasksUiUtil.openTask((ITask)this.newTask);
        return true;
    }

    public boolean validateDrop(Object targetObject, int operation, TransferData transferType) {
        this.currentTransfer = transferType;
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        if (TaskTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            if (this.getCurrentTarget() instanceof UncategorizedTaskContainer || this.getCurrentTarget() instanceof TaskCategory || this.getCurrentTarget() instanceof UnmatchedTaskContainer || this.getCurrentTarget() instanceof ScheduledTaskContainer) {
                return true;
            }
            if (this.getCurrentTarget() instanceof ITaskContainer && (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1)) {
                return true;
            }
            return this.getCurrentTarget() instanceof LocalTask && this.getCurrentLocation() == 3 && TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.subtasks.local");
        }
        return TextTransfer.getInstance().isSupportedType(transferType);
    }

    protected void retrieveTaskDescription(String url) {
        try {
            AbstractRetrieveTitleFromUrlJob job = new AbstractRetrieveTitleFromUrlJob(url){

                protected void titleRetrieved(String pageTitle) {
                    TaskListDropAdapter.this.newTask.setSummary(pageTitle);
                    TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)TaskListDropAdapter.this.newTask);
                }
            };
            job.schedule();
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not open task web page", (Throwable)e));
        }
    }
}

