/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.ScalingHyperlink;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.LegacyChangeManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDataDiff;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotification;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotifier;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.WorkweekProgressBar;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TaskListToolTip
extends ToolTip {
    private static final int MAX_TEXT_WIDTH = 300;
    private static final int MAX_WIDTH = 600;
    private static final int X_SHIFT = "gtk".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform()) ? -26 : -23;
    private static final int Y_SHIFT = 1;
    private IRepositoryElement currentTipElement;
    private final List<TaskListToolTipListener> listeners = new ArrayList<TaskListToolTipListener>();
    private boolean visible;
    private boolean triggeredByMouse;
    private final Control control;

    public TaskListToolTip(Control control) {
        super(control);
        this.control = control;
        this.setShift(new Point(1, 1));
    }

    public void dispose() {
        this.hide();
    }

    protected void afterHideToolTip(Event event) {
        this.triggeredByMouse = true;
        this.visible = false;
        TaskListToolTipListener[] taskListToolTipListenerArray = this.listeners.toArray(new TaskListToolTipListener[0]);
        int n = taskListToolTipListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskListToolTipListener listener = taskListToolTipListenerArray[n2];
            listener.toolTipHidden(event);
            ++n2;
        }
    }

    public void addTaskListToolTipListener(TaskListToolTipListener listener) {
        this.listeners.add(listener);
    }

    public void removeTaskListToolTipListener(TaskListToolTipListener listener) {
        this.listeners.remove(listener);
    }

    private IRepositoryElement getTaskListElement(Object hoverObject) {
        Object data;
        if (hoverObject instanceof ScalingHyperlink) {
            TaskHyperlink hyperlink = (TaskHyperlink)((Object)hoverObject);
            return hyperlink.getTask();
        }
        if (hoverObject instanceof Widget && (data = ((Widget)hoverObject).getData()) != null) {
            if (data instanceof ITaskContainer) {
                return (IRepositoryElement)data;
            }
            if (data instanceof IAdaptable) {
                return (IRepositoryElement)((IAdaptable)data).getAdapter(AbstractTaskContainer.class);
            }
        }
        return null;
    }

    private String getTitleText(IRepositoryElement element) {
        if (element instanceof ScheduledTaskContainer) {
            StringBuilder sb = new StringBuilder();
            sb.append(element.getSummary());
            Calendar start = ((ScheduledTaskContainer)element).getDateRange().getStartDate();
            sb.append("  [");
            sb.append(DateFormat.getDateInstance(1).format(start.getTime()));
            sb.append("]");
            return sb.toString();
        }
        if (element instanceof IRepositoryQuery) {
            IRepositoryQuery query = (IRepositoryQuery)element;
            StringBuilder sb = new StringBuilder();
            sb.append(element.getSummary());
            sb.append("  [");
            sb.append(this.getRepositoryLabel(query.getConnectorKind(), query.getRepositoryUrl()));
            sb.append("]");
            return sb.toString();
        }
        return new TaskElementLabelProvider(false).getText(element);
    }

    private String getDetailsText(IRepositoryElement element) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            int estimateTotal = 0;
            long elapsedTotal = 0L;
            for (ITask child : container.getChildren()) {
                if (!(child instanceof AbstractTask)) continue;
                estimateTotal += ((AbstractTask)child).getEstimatedTimeHours();
                elapsedTotal += TasksUiPlugin.getTaskActivityManager().getElapsedTime(child, container.getDateRange());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Estimate: ");
            sb.append(estimateTotal);
            sb.append(" hours");
            sb.append("\n");
            sb.append("Elapsed: ");
            sb.append(DateUtil.getFormattedDurationShort((long)elapsedTotal));
            sb.append("\n");
            return sb.toString();
        }
        if (element instanceof ITask) {
            String key;
            ITask task = (ITask)element;
            StringBuilder sb = new StringBuilder();
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(task.getConnectorKind());
            if (connectorUi != null) {
                sb.append(connectorUi.getTaskKindLabel(task));
            }
            if ((key = task.getTaskKey()) != null) {
                sb.append(" ");
                sb.append(key);
            }
            sb.append(", ");
            sb.append(task.getPriority());
            sb.append("  [");
            sb.append(this.getRepositoryLabel(task.getConnectorKind(), task.getRepositoryUrl()));
            sb.append("]");
            sb.append("\n");
            return sb.toString();
        }
        return null;
    }

    private String getRepositoryLabel(String repositoryKind, String repositoryUrl) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryKind, repositoryUrl);
        if (repository != null) {
            String label = repository.getRepositoryLabel();
            if (label.indexOf("//") != -1) {
                return label.substring(repository.getRepositoryUrl().indexOf("//") + 2);
            }
            return String.valueOf(label);
        }
        return "";
    }

    private String getActivityText(IRepositoryElement element) {
        if (element instanceof ITask) {
            DateRange scheduledDate;
            AbstractTask task = (AbstractTask)element;
            StringBuilder sb = new StringBuilder();
            Date dueDate = task.getDueDate();
            if (dueDate != null) {
                sb.append("Due: ");
                sb.append(new SimpleDateFormat("E").format(dueDate)).append(", ");
                sb.append(DateFormat.getDateInstance(1).format(dueDate));
                sb.append(" (").append(DateFormat.getTimeInstance(3).format(dueDate)).append(')');
                sb.append('\n');
            }
            if ((scheduledDate = task.getScheduledForDate()) != null) {
                sb.append("Scheduled: ");
                sb.append(scheduledDate.toString());
                sb.append('\n');
            }
            long elapsed = TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task);
            String elapsedTimeString = DateUtil.getFormattedDurationShort((long)elapsed);
            sb.append("Elapsed: ");
            sb.append(elapsedTimeString);
            sb.append("\n");
            return sb.toString();
        }
        return null;
    }

    private String getIncommingText(IRepositoryElement element) {
        ITask task;
        if (element instanceof ITask && (task = (ITask)element).getSynchronizationState().isIncoming()) {
            String text = null;
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
            if (connector instanceof AbstractLegacyRepositoryConnector) {
                TaskListNotification notification = LegacyChangeManager.getIncommingNotification(connector, task);
                if (notification != null) {
                    text = notification.getDescription();
                }
            } else {
                TaskListNotifier notifier = new TaskListNotifier(TasksUiPlugin.getRepositoryModel(), TasksUiPlugin.getTaskDataManager());
                TaskDataDiff diff = notifier.getDiff(task);
                if (diff != null) {
                    text = diff.toString(300);
                }
            }
            if (text != null && text.length() > 0) {
                return text;
            }
        }
        return null;
    }

    private String getStatusText(IRepositoryElement element) {
        IStatus status = null;
        if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            status = task.getStatus();
        } else if (element instanceof IRepositoryQuery) {
            RepositoryQuery query = (RepositoryQuery)element;
            status = query.getStatus();
        }
        if (status != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(status.getMessage());
            if (status instanceof RepositoryStatus && ((RepositoryStatus)status).isHtmlMessage()) {
                sb.append(" Please synchronize manually for full error message.");
            }
            return sb.toString();
        }
        return null;
    }

    public Point getLocation(Point tipSize, Event event) {
        Rectangle bounds;
        Widget widget = this.getTipWidget(event);
        if (widget != null && (bounds = this.getBounds(widget)) != null) {
            return this.control.toDisplay(bounds.x + X_SHIFT, bounds.y + bounds.height + 1);
        }
        return super.getLocation(tipSize, event);
    }

    private ProgressData getProgressData(IRepositoryElement element) {
        if (element instanceof ITask) {
            return null;
        }
        if (element instanceof ITaskContainer) {
            Object[] children = new Object[]{};
            children = ((ITaskContainer)element).getChildren().toArray();
            int total = children.length;
            int completed = 0;
            for (ITask task : ((ITaskContainer)element).getChildren()) {
                if (!task.isCompleted()) continue;
                ++completed;
            }
            String text = "Total: " + total + " (Complete: " + completed + ", Incomplete: " + (total - completed) + ")";
            return new ProgressData(completed, total, text);
        }
        return null;
    }

    private Image getImage(IRepositoryElement element) {
        if (element instanceof IRepositoryQuery) {
            IRepositoryQuery query = (IRepositoryQuery)element;
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(query.getConnectorKind());
            if (connector != null) {
                return TasksUiPlugin.getDefault().getBrandingIcon(connector.getConnectorKind());
            }
        } else if (element instanceof ITask) {
            ITask repositoryTask = (ITask)element;
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repositoryTask.getConnectorKind());
            if (connector != null) {
                return TasksUiPlugin.getDefault().getBrandingIcon(connector.getConnectorKind());
            }
        } else if (element instanceof ScheduledTaskContainer) {
            return CommonImages.getImage((ImageDescriptor)CommonImages.CALENDAR);
        }
        return null;
    }

    protected Widget getTipWidget(Event event) {
        Point widgetPosition = new Point(event.x, event.y);
        Widget widget = event.widget;
        if (widget instanceof ToolBar) {
            ToolBar w = (ToolBar)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Table) {
            Table w = (Table)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Tree) {
            Tree w = (Tree)widget;
            return w.getItem(widgetPosition);
        }
        return widget;
    }

    private Rectangle getBounds(Widget widget) {
        if (widget instanceof ToolItem) {
            ToolItem w = (ToolItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TableItem) {
            TableItem w = (TableItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TreeItem) {
            TreeItem w = (TreeItem)widget;
            return w.getBounds();
        }
        return null;
    }

    protected boolean shouldCreateToolTip(Event event) {
        Widget tipWidget;
        this.currentTipElement = null;
        if (super.shouldCreateToolTip(event) && (tipWidget = this.getTipWidget(event)) != null) {
            Rectangle bounds = this.getBounds(tipWidget);
            if (tipWidget instanceof ScalingHyperlink) {
                this.currentTipElement = this.getTaskListElement(tipWidget);
            } else if (bounds != null && this.control.getBounds().contains(bounds.x, bounds.y)) {
                this.currentTipElement = this.getTaskListElement(tipWidget);
            }
        }
        if (this.currentTipElement == null) {
            this.hide();
            return false;
        }
        return true;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        String helpText;
        String statusText;
        ProgressData progress;
        String incommingText;
        String activityText;
        String synchText;
        assert (this.currentTipElement != null);
        Composite composite = this.createToolTipContentAreaComposite(parent);
        this.addIconAndLabel(composite, this.getImage(this.currentTipElement), this.getTitleText(this.currentTipElement));
        String detailsText = this.getDetailsText(this.currentTipElement);
        if (detailsText != null) {
            this.addIconAndLabel(composite, null, detailsText);
        }
        if ((synchText = this.getSynchText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_SYNCHRONIZE), synchText);
        }
        if ((activityText = this.getActivityText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)CommonImages.CALENDAR), activityText);
        }
        if ((incommingText = this.getIncommingText(this.currentTipElement)) != null) {
            Image image = CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING);
            if (this.currentTipElement instanceof ITask) {
                ITask task = (ITask)this.currentTipElement;
                if (task.getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW) {
                    image = CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING_NEW);
                } else if (task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
                    image = CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_OUTGOING_NEW);
                }
            }
            this.addIconAndLabel(composite, image, incommingText);
        }
        if ((progress = this.getProgressData(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, null, progress.text);
            Label label = new Label(composite, 0);
            GridData labelGridData = new GridData(4, 128, true, false);
            labelGridData.heightHint = 0;
            label.setLayoutData((Object)labelGridData);
            Composite progressComposite = new Composite(composite, 0);
            GridLayout progressLayout = new GridLayout(1, false);
            progressLayout.marginWidth = 0;
            progressLayout.marginHeight = 0;
            progressComposite.setLayout((Layout)progressLayout);
            progressComposite.setLayoutData((Object)new GridData(4, 128, true, false));
            WorkweekProgressBar taskProgressBar = new WorkweekProgressBar(progressComposite);
            taskProgressBar.setLayoutData(new GridData(4, 128, true, false));
            taskProgressBar.reset(progress.completed, progress.total);
        }
        if ((statusText = this.getStatusText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)CommonImages.WARNING), statusText);
        }
        if ((helpText = this.getHelpText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)CommonImages.QUESTION), helpText);
        }
        this.visible = true;
        return composite;
    }

    private String getHelpText(IRepositoryElement element) {
        TaskListView taskListView;
        if ((element instanceof TaskCategory || element instanceof IRepositoryQuery) && AbstractTaskListFilter.hasDescendantIncoming((ITaskContainer)element) && (taskListView = TaskListView.getFromActivePerspective()) != null && !taskListView.isFocusedMode() && TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.complete")) {
            Object[] children = ((TaskListContentProvider)taskListView.getViewer().getContentProvider()).getChildren(element);
            boolean hasIncoming = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof ITask && ((ITask)child).getSynchronizationState().isIncoming()) {
                    hasIncoming = true;
                    break;
                }
                ++n2;
            }
            if (!hasIncoming) {
                return "Some incoming elements may be filtered,\nfocus the view to see all incomings";
            }
        }
        if (element instanceof UncategorizedTaskContainer) {
            return "Automatic container for all local tasks\nwith no category set";
        }
        if (element instanceof UnmatchedTaskContainer) {
            return "Automatic container for repository tasks\nnot matched by any query";
        }
        return null;
    }

    protected Composite createToolTipContentAreaComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(composite.getDisplay().getSystemColor(29));
        return composite;
    }

    private String getSynchText(IRepositoryElement element) {
        String syncStamp;
        if (element instanceof IRepositoryQuery && (syncStamp = ((RepositoryQuery)element).getLastSynchronizedTimeStamp()) != null) {
            return "Synchronized: " + syncStamp;
        }
        return null;
    }

    private String removeTrailingNewline(String text) {
        if (text.endsWith("\n")) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    protected void addIconAndLabel(Composite parent, Image image, String text) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setForeground(parent.getDisplay().getSystemColor(28));
        imageLabel.setBackground(parent.getDisplay().getSystemColor(29));
        imageLabel.setLayoutData((Object)new GridData(34));
        imageLabel.setImage(image);
        Label textLabel = new Label(parent, 64);
        textLabel.setForeground(parent.getDisplay().getSystemColor(28));
        textLabel.setBackground(parent.getDisplay().getSystemColor(29));
        textLabel.setLayoutData((Object)new GridData(772));
        text = this.removeTrailingNewline(text);
        textLabel.setText(TasksUiInternal.escapeLabelText(text));
        GC gc = new GC((Drawable)textLabel);
        int width = Math.min(gc.textExtent((String)text).x, 600);
        try {
            GridDataFactory.fillDefaults().align(4, 1).hint(width, -1).applyTo((Control)textLabel);
        }
        finally {
            gc.dispose();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isTriggeredByMouse() {
        return this.triggeredByMouse;
    }

    public void show(Point location) {
        super.show(location);
        this.triggeredByMouse = false;
    }

    private static class ProgressData {
        int completed;
        int total;
        String text;

        public ProgressData(int completed, int total, String text) {
            this.completed = completed;
            this.total = total;
            this.text = text;
        }
    }

    public static interface TaskListToolTipListener {
        public void toolTipHidden(Event var1);
    }
}

