/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.ui.TreeWalker;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonThemes;
import org.eclipse.mylyn.internal.provisional.commons.ui.DelayedRefreshJob;
import org.eclipse.mylyn.internal.provisional.commons.ui.SubstringPatternFilter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TaskArchiveFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskCompletionFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskPriorityFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskTransfer;
import org.eclipse.mylyn.internal.tasks.ui.TaskWorkingSetFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.CollapseAllAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.EditRepositoryPropertiesAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ExpandAllAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.FilterCompletedTasksAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.GoIntoAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.GoUpAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.GroupSubTasksAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.LinkWithEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskCompleteAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskIncompleteAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskListElementAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTasksUiPreferencesAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.PresentationDropDownSelectionAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RemoveFromCategoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RenameAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeAutomaticallyAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskListSortAction;
import org.eclipse.mylyn.internal.tasks.ui.commands.CollapseAllHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDragSourceListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.CustomTaskListDecorationDrawer;
import org.eclipse.mylyn.internal.tasks.ui.views.PriorityDropDownAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListCellModifier;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListDropAdapter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListFilteredTree;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListTableSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListToolTip;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskTableLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.UpdateRepositoryConfigurationAction;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.IThemeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListView
extends ViewPart
implements IPropertyChangeListener {
    public static final int SWT_NO_SCROLL = 16;
    public static final String ID = "org.eclipse.mylyn.tasks.ui.views.tasks";
    public static final String LABEL_VIEW = "Task List";
    private static final String MEMENTO_KEY_SORT_DIRECTION = "sortDirection";
    private static final String MEMENTO_KEY_SORTER = "sorter";
    private static final String MEMENTO_KEY_SORTER2 = "sorter2";
    private static final String MEMENTO_KEY_SORT_INDEX = "sortIndex";
    private static final String MEMENTO_SORT_INDEX = "org.eclipse.mylyn.tasklist.ui.views.tasklist.sortIndex";
    private static final String MEMENTO_LINK_WITH_EDITOR = "linkWithEditor";
    private static final String MEMENTO_PRESENTATION = "presentation";
    private static final String ID_SEPARATOR_NEW = "new";
    public static final String ID_SEPARATOR_OPERATIONS = "operations";
    public static final String ID_SEPARATOR_CONTEXT = "context";
    public static final String ID_SEPARATOR_TASKS = "tasks";
    private static final String ID_SEPARATOR_FILTERS = "filters";
    private static final String ID_SEPARATOR_REPOSITORY = "repository";
    private static final String ID_SEPARATOR_PROPERTIES = "properties";
    public static final String ID_SEPARATOR_NAVIGATE = "navigate";
    private static final String LABEL_NO_TASKS = "no task active";
    private static final int SIZE_MAX_SELECTION_HISTORY = 10;
    private static final String PART_NAME = "Task List";
    static final String[] PRIORITY_LEVELS = new String[]{ITask.PriorityLevel.P1.toString(), ITask.PriorityLevel.P2.toString(), ITask.PriorityLevel.P3.toString(), ITask.PriorityLevel.P4.toString(), ITask.PriorityLevel.P5.toString()};
    public static final String[] PRIORITY_LEVEL_DESCRIPTIONS = new String[]{ITask.PriorityLevel.P1.getDescription(), ITask.PriorityLevel.P2.getDescription(), ITask.PriorityLevel.P3.getDescription(), ITask.PriorityLevel.P4.getDescription(), ITask.PriorityLevel.P5.getDescription()};
    private static List<AbstractTaskListPresentation> presentationsPrimary = new ArrayList<AbstractTaskListPresentation>();
    private static List<AbstractTaskListPresentation> presentationsSecondary = new ArrayList<AbstractTaskListPresentation>();
    private boolean focusedMode = false;
    private boolean linkWithEditor;
    private final TaskListCellModifier taskListCellModifier = new TaskListCellModifier(this);
    private IThemeManager themeManager;
    private TaskListFilteredTree filteredTree;
    private DrillDownAdapter drillDownAdapter;
    private AbstractTaskContainer drilledIntoCategory = null;
    private GoIntoAction goIntoAction;
    private GoUpAction goUpAction;
    private CopyTaskDetailsAction copyDetailsAction;
    private OpenTaskListElementAction openAction;
    private OpenWithBrowserAction openWithBrowser;
    private RenameAction renameAction;
    private CollapseAllAction collapseAll;
    private ExpandAllAction expandAll;
    private DeleteAction deleteAction;
    private RemoveFromCategoryAction removeFromCategoryAction;
    private final TaskActivateAction activateAction = new TaskActivateAction();
    private final TaskDeactivateAction deactivateAction = new TaskDeactivateAction();
    private FilterCompletedTasksAction filterCompleteTask;
    private GroupSubTasksAction filterSubTasksAction;
    private SynchronizeAutomaticallyAction synchronizeAutomatically;
    private OpenTasksUiPreferencesAction openPreferencesAction;
    private PriorityDropDownAction filterOnPriorityAction;
    private TaskListSortAction sortDialogAction;
    private PresentationDropDownSelectionAction presentationDropDownSelectionAction;
    private LinkWithEditorAction linkWithEditorAction;
    private final TaskPriorityFilter filterPriority = new TaskPriorityFilter();
    private final TaskCompletionFilter filterComplete = new TaskCompletionFilter();
    private final TaskArchiveFilter filterArchive = new TaskArchiveFilter();
    private TaskWorkingSetFilter filterWorkingSet;
    private final Set<AbstractTaskListFilter> filters = new HashSet<AbstractTaskListFilter>();
    protected String[] columnNames = new String[]{"Summary"};
    protected int[] columnWidths = new int[]{200};
    private TreeColumn[] columns;
    private IMemento taskListMemento;
    private AbstractTaskListPresentation currentPresentation;
    private TaskTableLabelProvider taskListTableLabelProvider;
    private TaskListTableSorter tableSorter;
    private Color categoryGradientStart;
    private Color categoryGradientEnd;
    private final IPageListener PAGE_LISTENER = new IPageListener(){

        public void pageActivated(IWorkbenchPage page) {
            TaskListView.this.filteredTree.indicateActiveTaskWorkingSet();
        }

        public void pageClosed(IWorkbenchPage page) {
        }

        public void pageOpened(IWorkbenchPage page) {
        }
    };
    private final LinkedHashMap<String, IStructuredSelection> lastSelectionByTaskHandle = new LinkedHashMap(10);
    protected boolean isPaused = false;
    boolean synchronizationOverlaid = false;
    private final Listener CATEGORY_GRADIENT_DRAWER = new Listener(){

        public void handleEvent(Event event) {
            if (event.item.getData() instanceof ITaskContainer && !(event.item.getData() instanceof ITask)) {
                Scrollable scrollable = (Scrollable)event.widget;
                GC gc = event.gc;
                Rectangle area = scrollable.getClientArea();
                Rectangle rect = event.getBounds();
                this.expandRegion(event, scrollable, gc, area);
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(TaskListView.this.categoryGradientEnd);
                gc.drawLine(0, rect.y, area.width, rect.y);
                gc.setForeground(TaskListView.this.categoryGradientStart);
                gc.setBackground(TaskListView.this.categoryGradientEnd);
                gc.fillGradientRectangle(0, rect.y + 1, area.width, rect.height, true);
                gc.setForeground(TaskListView.this.categoryGradientEnd);
                gc.drawLine(0, rect.y + rect.height - 1, area.width, rect.y + rect.height - 1);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFF7;
            }
        }

        private void expandRegion(Event event, Scrollable scrollable, GC gc, Rectangle area) {
            int width;
            int columnCount = scrollable instanceof Table ? ((Table)scrollable).getColumnCount() : ((Tree)scrollable).getColumnCount();
            if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                Region region = new Region();
                gc.getClipping(region);
                region.add(event.x, event.y, width, event.height);
                gc.setClipping(region);
                region.dispose();
            }
        }
    };
    private boolean gradientListenerAdded = false;
    private final ITaskActivityListener TASK_ACTIVITY_LISTENER = new TaskActivityAdapter(){

        public void activityReset() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskListView.this.refreshJob.refresh();
                }
            });
        }
    };
    private final ITaskActivationListener TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

        public void taskActivated(final ITask task) {
            if (task != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskListView.this.updateDescription();
                        this.refresh(task);
                        TaskListView.this.selectedAndFocusTask(task);
                        TaskListView.this.filteredTree.indicateActiveTask(task);
                    }
                });
            }
        }

        public void taskDeactivated(final ITask task) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    this.refresh(task);
                    TaskListView.this.updateDescription();
                    TaskListView.this.filteredTree.indicateNoActiveTask();
                }
            });
        }

        private void refresh(ITask task) {
            if (TaskListView.this.isScheduledPresentation()) {
                TaskListView.this.refreshJob.refresh();
            } else {
                TaskListView.this.refreshJob.refreshElement((Object)task);
            }
        }
    };
    private final ITaskListChangeListener TASKLIST_CHANGE_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(final Set<TaskContainerDelta> deltas) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    for (TaskContainerDelta taskContainerDelta : deltas) {
                        if ("org.eclipse.mylyn.tasks.ui.scheduled".equals(TaskListView.this.getCurrentPresentation().getId())) {
                            TaskListView.this.refreshJob.refresh();
                            continue;
                        }
                        switch (taskContainerDelta.getKind()) {
                            case ROOT: {
                                TaskListView.this.refreshJob.refresh();
                                break;
                            }
                            case ADDED: 
                            case REMOVED: {
                                if (taskContainerDelta.getElement() != null) {
                                    TaskListView.this.refreshJob.refreshElement((Object)taskContainerDelta.getElement());
                                }
                                if (taskContainerDelta.getParent() != null) {
                                    TaskListView.this.refreshJob.refreshElement((Object)taskContainerDelta.getParent());
                                    break;
                                }
                                TaskListView.this.refreshJob.refresh();
                                break;
                            }
                            case CONTENT: {
                                TaskListView.this.refreshJob.refreshElement((Object)taskContainerDelta.getElement());
                            }
                        }
                    }
                }
            });
        }
    };
    private final IPropertyChangeListener THEME_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME") || CommonThemes.isCommonTheme((String)event.getProperty())) {
                TaskListView.this.configureGradientColors();
                TaskListView.this.taskListTableLabelProvider.setCategoryBackgroundColor(TaskListView.this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end"));
                TaskListView.this.getViewer().refresh();
            }
        }
    };
    private TaskListToolTip taskListToolTip;
    private final IPartListener editorListener = new IPartListener(){

        private void jumpToEditor(IWorkbenchPart part) {
            if (!TaskListView.this.linkWithEditor || !(part instanceof IEditorPart)) {
                return;
            }
            TaskListView.this.jumpToEditorTask((IEditorPart)part);
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == TaskListView.this) {
                TaskListView.this.updateDescription();
            } else {
                this.jumpToEditor(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == TaskListView.this) {
                IViewReference reference = TaskListView.this.getSite().getPage().findViewReference(TaskListView.ID);
                if (reference != null && reference.isFastView()) {
                    TaskListView.this.updateDescription();
                }
                TaskListView.this.taskListToolTip.hide();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    boolean isInRenameAction = false;
    private DelayedRefreshJob refreshJob;

    private void configureGradientColors() {
        this.categoryGradientStart = this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.start");
        this.categoryGradientEnd = this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        boolean customized = true;
        if (this.categoryGradientStart != null && this.categoryGradientStart.getRed() == 240 && this.categoryGradientStart.getGreen() == 240 && this.categoryGradientStart.getBlue() == 240 && this.categoryGradientEnd != null && this.categoryGradientEnd.getRed() == 220 && this.categoryGradientEnd.getGreen() == 220 && this.categoryGradientEnd.getBlue() == 220) {
            customized = false;
        }
        if (!this.gradientListenerAdded && this.categoryGradientStart != null && !this.categoryGradientStart.equals((Object)this.categoryGradientEnd)) {
            this.getViewer().getTree().addListener(40, this.CATEGORY_GRADIENT_DRAWER);
            this.gradientListenerAdded = true;
            if (!customized) {
                Color parentBackground = this.getViewer().getTree().getParent().getBackground();
                double GRADIENT_TOP = 1.05;
                double GRADIENT_BOTTOM = 0.995;
                int red = Math.min(255, (int)((double)parentBackground.getRed() * GRADIENT_TOP));
                int green = Math.min(255, (int)((double)parentBackground.getGreen() * GRADIENT_TOP));
                int blue = Math.min(255, (int)((double)parentBackground.getBlue() * GRADIENT_TOP));
                try {
                    this.categoryGradientStart = new Color((Device)Display.getDefault(), red, green, blue);
                }
                catch (Exception e) {
                    this.categoryGradientStart = this.getViewer().getTree().getParent().getBackground();
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set color: " + red + ", " + green + ", " + blue, (Throwable)e));
                }
                red = Math.max(0, (int)((double)parentBackground.getRed() / GRADIENT_BOTTOM));
                green = Math.max(0, (int)((double)parentBackground.getGreen() / GRADIENT_BOTTOM));
                blue = Math.max(0, (int)((double)parentBackground.getBlue() / GRADIENT_BOTTOM));
                if (red > 255) {
                    red = 255;
                }
                try {
                    this.categoryGradientEnd = new Color((Device)Display.getDefault(), red, green, blue);
                }
                catch (Exception e) {
                    this.categoryGradientStart = this.getViewer().getTree().getParent().getBackground();
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set color: " + red + ", " + green + ", " + blue, (Throwable)e));
                }
            }
        } else if (this.categoryGradientStart != null && this.categoryGradientStart.equals((Object)this.categoryGradientEnd)) {
            this.getViewer().getTree().removeListener(40, this.CATEGORY_GRADIENT_DRAWER);
            this.gradientListenerAdded = false;
        }
    }

    public static TaskListView getFromActivePerspective() {
        IViewPart view;
        IWorkbenchPage activePage;
        if (PlatformUI.isWorkbenchRunning() && (activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && (view = activePage.findView(ID)) instanceof TaskListView) {
            return (TaskListView)view;
        }
        return null;
    }

    public TaskListView() {
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
        TasksUiPlugin.getTaskActivityManager().addActivityListener(this.TASK_ACTIVITY_LISTENER);
        TasksUiPlugin.getTaskActivityManager().addActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiInternal.getTaskList().addChangeListener(this.TASKLIST_CHANGE_LISTENER);
    }

    public void dispose() {
        IThemeManager themeManager;
        super.dispose();
        TasksUiInternal.getTaskList().removeChangeListener(this.TASKLIST_CHANGE_LISTENER);
        TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.TASK_ACTIVITY_LISTENER);
        TasksUiPlugin.getTaskActivityManager().removeActivationListener(this.TASK_ACTIVATION_LISTENER);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePageListener(this.PAGE_LISTENER);
        }
        if ((themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager()) != null) {
            themeManager.removePropertyChangeListener(this.THEME_CHANGE_LISTENER);
        }
        this.categoryGradientStart.dispose();
        this.categoryGradientEnd.dispose();
    }

    private void updateDescription() {
        ITask task = TasksUi.getTaskActivityManager().getActiveTask();
        if (this.getSite() == null || this.getSite().getPage() == null) {
            return;
        }
        IViewReference reference = this.getSite().getPage().findViewReference(ID);
        boolean shouldSetDescription = false;
        if (reference != null && reference.isFastView() && !this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            shouldSetDescription = true;
        }
        if (task != null) {
            this.setTitleToolTip("Task List (" + task.getSummary() + ")");
            if (shouldSetDescription) {
                this.setContentDescription(task.getSummary());
            } else {
                this.setContentDescription("");
            }
        } else {
            this.setTitleToolTip("Task List");
            if (shouldSetDescription) {
                this.setContentDescription(LABEL_NO_TASKS);
            } else {
                this.setContentDescription("");
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.taskListMemento = memento;
    }

    public void saveState(IMemento memento) {
        IMemento sorter = memento.createChild(MEMENTO_SORT_INDEX);
        IMemento m = sorter.createChild(MEMENTO_KEY_SORTER);
        switch (this.tableSorter.getSortByIndex()) {
            case SUMMARY: {
                m.putInteger(MEMENTO_KEY_SORT_INDEX, 1);
                break;
            }
            case DATE_CREATED: {
                m.putInteger(MEMENTO_KEY_SORT_INDEX, 2);
                break;
            }
            default: {
                m.putInteger(MEMENTO_KEY_SORT_INDEX, 0);
            }
        }
        m.putInteger(MEMENTO_KEY_SORT_DIRECTION, this.tableSorter.getSortDirection());
        IMemento m2 = sorter.createChild(MEMENTO_KEY_SORTER2);
        switch (this.tableSorter.getSortByIndex2()) {
            case SUMMARY: {
                m2.putInteger(MEMENTO_KEY_SORT_INDEX, 1);
                break;
            }
            case DATE_CREATED: {
                m2.putInteger(MEMENTO_KEY_SORT_INDEX, 2);
                break;
            }
            default: {
                m2.putInteger(MEMENTO_KEY_SORT_INDEX, 0);
            }
        }
        m2.putInteger(MEMENTO_KEY_SORT_DIRECTION, this.tableSorter.getSortDirection2());
        memento.putString(MEMENTO_LINK_WITH_EDITOR, Boolean.toString(this.linkWithEditor));
        memento.putString(MEMENTO_PRESENTATION, this.currentPresentation.getId());
    }

    private void restoreState() {
        this.tableSorter = null;
        if (this.taskListMemento != null) {
            IMemento sorterMemento = this.taskListMemento.getChild(MEMENTO_SORT_INDEX);
            int restoredSortIndex = 0;
            if (sorterMemento != null) {
                IMemento m2;
                int sortDirection = -1;
                this.tableSorter = new TaskListTableSorter(this);
                IMemento m = sorterMemento.getChild(MEMENTO_KEY_SORTER);
                if (m != null) {
                    Integer sortDirInt;
                    Integer sortIndexInt = m.getInteger(MEMENTO_KEY_SORT_INDEX);
                    if (sortIndexInt != null) {
                        restoredSortIndex = sortIndexInt;
                    }
                    if ((sortDirInt = m.getInteger(MEMENTO_KEY_SORT_DIRECTION)) != null) {
                        sortDirection = sortDirInt;
                        this.tableSorter.setSortDirection(sortDirection);
                        switch (restoredSortIndex) {
                            case 1: {
                                this.tableSorter.setSortByIndex(TaskListTableSorter.SortByIndex.SUMMARY);
                                break;
                            }
                            case 2: {
                                this.tableSorter.setSortByIndex(TaskListTableSorter.SortByIndex.DATE_CREATED);
                                break;
                            }
                            default: {
                                this.tableSorter.setSortByIndex(TaskListTableSorter.SortByIndex.PRIORITY);
                            }
                        }
                    }
                }
                if ((m2 = sorterMemento.getChild(MEMENTO_KEY_SORTER2)) != null) {
                    Integer sortDirInt;
                    Integer sortIndexInt = m2.getInteger(MEMENTO_KEY_SORT_INDEX);
                    if (sortIndexInt != null) {
                        restoredSortIndex = sortIndexInt;
                    }
                    if ((sortDirInt = m2.getInteger(MEMENTO_KEY_SORT_DIRECTION)) != null) {
                        sortDirection = sortDirInt;
                        this.tableSorter.setSortDirection2(sortDirection);
                        switch (restoredSortIndex) {
                            case 1: {
                                this.tableSorter.setSortByIndex2(TaskListTableSorter.SortByIndex.SUMMARY);
                                break;
                            }
                            case 2: {
                                this.tableSorter.setSortByIndex2(TaskListTableSorter.SortByIndex.DATE_CREATED);
                                break;
                            }
                            default: {
                                this.tableSorter.setSortByIndex2(TaskListTableSorter.SortByIndex.PRIORITY);
                            }
                        }
                    }
                }
            }
            this.applyPresentation(this.taskListMemento.getString(MEMENTO_PRESENTATION));
        }
        if (this.tableSorter == null) {
            this.tableSorter = new TaskListTableSorter(this);
        }
        this.filterWorkingSet = new TaskWorkingSetFilter();
        this.filterWorkingSet.updateWorkingSet(this.getSite().getPage().getAggregateWorkingSet());
        this.addFilter(this.filterWorkingSet);
        this.addFilter(this.filterPriority);
        if (TasksUiPlugin.getDefault().getPreferenceStore().contains("org.eclipse.mylyn.tasks.ui.filters.complete")) {
            this.addFilter(this.filterComplete);
        }
        this.addFilter(this.filterArchive);
        boolean linkValue = true;
        if (this.taskListMemento != null && this.taskListMemento.getString(MEMENTO_LINK_WITH_EDITOR) != null) {
            linkValue = Boolean.parseBoolean(this.taskListMemento.getString(MEMENTO_LINK_WITH_EDITOR));
        }
        this.setLinkWithEditor(linkValue);
        this.getViewer().setSorter((ViewerSorter)this.tableSorter);
        this.getViewer().refresh();
    }

    public void createPartControl(Composite parent) {
        this.themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener(this.THEME_CHANGE_LISTENER);
        this.filteredTree = new TaskListFilteredTree(parent, 98834, (PatternFilter)new SubstringPatternFilter());
        this.getViewer().getTree().setToolTipText("");
        this.getViewer().getTree().setHeaderVisible(false);
        this.getViewer().setUseHashlookup(true);
        this.refreshJob = new TaskListRefreshJob(this.getViewer(), "Task List Refresh");
        this.configureColumns(this.columnNames, this.columnWidths);
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        Color categoryBackground = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        this.taskListTableLabelProvider = new TaskTableLabelProvider((ILabelProvider)new TaskElementLabelProvider(true), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), categoryBackground);
        this.getViewer().setLabelProvider((IBaseLabelProvider)this.taskListTableLabelProvider);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.getViewer().getTree());
        ((Text)textEditor.getControl()).setOrientation(0x2000000);
        editors[0] = textEditor;
        this.getViewer().setCellEditors(editors);
        this.getViewer().setCellModifier((ICellModifier)this.taskListCellModifier);
        this.tableSorter = new TaskListTableSorter(this);
        this.getViewer().setSorter((ViewerSorter)this.tableSorter);
        this.applyPresentation("org.eclipse.mylyn.tasks.ui.categorized");
        this.drillDownAdapter = new DrillDownAdapter(this.getViewer());
        this.getViewer().setInput((Object)this.getViewSite());
        CustomTaskListDecorationDrawer customDrawer = new CustomTaskListDecorationDrawer(this, 20);
        this.getViewer().getTree().addListener(40, (Listener)customDrawer);
        this.getViewer().getTree().addListener(42, (Listener)customDrawer);
        this.getViewer().getTree().addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                Object selectedObject;
                TreeItem selectedNode = ((Tree)e.widget).getItem(new Point(e.x + 70, e.y));
                if (selectedNode instanceof TreeItem && (selectedObject = selectedNode.getData()) instanceof ITask && e.x > 20 && e.x < 33) {
                    TaskListView.this.taskListCellModifier.toggleTaskActivation(selectedNode);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.getViewer().getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    if (TaskListView.this.renameAction.isEnabled()) {
                        TaskListView.this.renameAction.run();
                    }
                } else if ((e.keyCode & 0x1000000) == 0) {
                    if (e.keyCode == 27) {
                        TaskListView.this.taskListToolTip.hide();
                    } else if (e.keyCode == 102 && e.stateMask == SWT.MOD1) {
                        TaskListView.this.filteredTree.getFilterControl().setFocus();
                    } else if (e.stateMask == 0 && (Character.isLetter((char)e.keyCode) || Character.isDigit((char)e.keyCode))) {
                        String string = new Character((char)e.keyCode).toString();
                        TaskListView.this.filteredTree.getFilterControl().setText(string);
                        TaskListView.this.filteredTree.getFilterControl().setSelection(1, 1);
                        TaskListView.this.filteredTree.getFilterControl().setFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.getViewer().addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(final TreeExpansionEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskListView.this.getViewer().refresh(event.getElement());
                    }
                });
            }

            public void treeExpanded(final TreeExpansionEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskListView.this.getViewer().refresh(event.getElement());
                    }
                });
            }
        });
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject = ((IStructuredSelection)TaskListView.this.getViewer().getSelection()).getFirstElement();
                if (selectedObject instanceof ITaskContainer) {
                    TaskListView.this.updateActionEnablement((Action)TaskListView.this.renameAction, (ITaskContainer)selectedObject);
                    TaskListView.this.updateActionEnablement(TaskListView.this.deleteAction, (ITaskContainer)selectedObject);
                }
            }
        });
        this.taskListToolTip = new TaskListToolTip(this.getViewer().getControl());
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TaskListView.this.updateToolTip(true);
            }
        });
        this.getViewer().getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TaskListView.this.taskListToolTip.hide();
            }
        });
        this.makeActions();
        this.hookGlobalActions();
        this.hookContextMenu();
        this.hookOpenAction();
        this.contributeToActionBars();
        this.initHandlers();
        this.configureGradientColors();
        this.initDragAndDrop(parent);
        this.expandToActiveTasks();
        this.restoreState();
        this.updateDescription();
        IContextService contextSupport = (IContextService)this.getSite().getService(IContextService.class);
        if (contextSupport != null) {
            contextSupport.activateContext(ID);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.getSite().getPage().addPartListener(this.editorListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPageListener(this.PAGE_LISTENER);
    }

    private void initHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new CollapseAllHandler((AbstractTreeViewer)this.getViewer()));
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyDetailsAction);
    }

    private void applyPresentation(String id) {
        if (id != null) {
            for (AbstractTaskListPresentation presentation : presentationsPrimary) {
                if (!id.equals(presentation.getId())) continue;
                this.applyPresentation(presentation);
                return;
            }
            for (AbstractTaskListPresentation presentation : presentationsSecondary) {
                if (!id.equals(presentation.getId())) continue;
                this.applyPresentation(presentation);
                return;
            }
        }
    }

    public void applyPresentation(AbstractTaskListPresentation presentation) {
        try {
            this.getViewer().getControl().setRedraw(false);
            if (!this.filteredTree.getFilterControl().getText().equals("")) {
                this.filteredTree.getFilterControl().setText("");
            }
            AbstractTaskListContentProvider contentProvider = presentation.getContentProvider(this);
            this.getViewer().setContentProvider((IContentProvider)contentProvider);
            this.refresh(true);
            this.currentPresentation = presentation;
        }
        finally {
            this.getViewer().getControl().setRedraw(true);
        }
    }

    public AbstractTaskListPresentation getCurrentPresentation() {
        return this.currentPresentation;
    }

    private void configureColumns(String[] columnNames, final int[] columnWidths) {
        TreeColumnLayout layout = (TreeColumnLayout)this.getViewer().getTree().getParent().getLayout();
        this.getViewer().setColumnProperties(columnNames);
        this.columns = new TreeColumn[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            this.columns[i] = new TreeColumn(this.getViewer().getTree(), 0);
            this.columns[i].setText(columnNames[i]);
            if (i == 0) {
                layout.setColumnData((Widget)this.columns[i], (ColumnLayoutData)new ColumnWeightData(100));
            } else {
                layout.setColumnData((Widget)this.columns[i], (ColumnLayoutData)new ColumnPixelData(columnWidths[i]));
            }
            this.columns[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskListView.this.tableSorter.setSortDirection(TaskListView.this.tableSorter.getSortDirection() * -1);
                    TaskListView.this.getViewer().refresh(false);
                }
            });
            this.columns[i].addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    int j = 0;
                    while (j < columnWidths.length) {
                        if (TaskListView.this.columns[j].equals(e.getSource())) {
                            columnWidths[j] = TaskListView.this.columns[j].getWidth();
                        }
                        ++j;
                    }
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            ++i;
        }
    }

    private void initDragAndDrop(Composite parent) {
        Transfer[] dragTypes = new Transfer[]{TaskTransfer.getInstance(), FileTransfer.getInstance()};
        Transfer[] dropTypes = new Transfer[]{TaskTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance(), RTFTransfer.getInstance()};
        this.getViewer().addDragSupport(7, dragTypes, (DragSourceListener)new TaskDragSourceListener((ISelectionProvider)this.getViewer()));
        this.getViewer().addDropSupport(23, dropTypes, (DropTargetListener)new TaskListDropAdapter((Viewer)this.getViewer()));
    }

    void expandToActiveTasks() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ITask task = TasksUi.getTaskActivityManager().getActiveTask();
                if (task != null) {
                    TaskListView.this.getViewer().expandToLevel((Object)task, 0);
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.updateDrillDownActions();
        manager.add((IAction)this.goUpAction);
        manager.add((IAction)this.collapseAll);
        manager.add((IAction)this.expandAll);
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_FILTERS));
        manager.add((IAction)this.sortDialogAction);
        manager.add((IAction)this.filterOnPriorityAction);
        manager.add((IAction)this.filterCompleteTask);
        manager.add((IAction)this.filterSubTasksAction);
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_TASKS));
        manager.add((IAction)this.synchronizeAutomatically);
        manager.add((IContributionItem)new Separator("additions"));
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskListView.this.filterOnPriorityAction.updateCheckedState();
            }
        });
        manager.add((IAction)this.linkWithEditorAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openPreferencesAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_NEW));
        manager.add((IAction)this.presentationDropDownSelectionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAll);
        manager.add((IContributionItem)new GroupMarker(ID_SEPARATOR_CONTEXT));
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(final IMenuManager manager) {
        this.updateDrillDownActions();
        Object firstSelectedObject = ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
        final ITaskContainer element = firstSelectedObject instanceof ITaskContainer ? (ITaskContainer)firstSelectedObject : null;
        final List<IRepositoryElement> selectedElements = this.getSelectedTaskContainers();
        AbstractTask task = null;
        if (element instanceof ITask) {
            task = (AbstractTask)element;
        }
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_NEW));
        manager.add((IContributionItem)new Separator());
        if (element instanceof ITask) {
            this.addAction(this.openAction, manager, element);
        }
        this.addAction((Action)this.openWithBrowser, manager, element);
        if (task != null) {
            if (task.isActive()) {
                manager.add((IAction)this.deactivateAction);
            } else {
                manager.add((IAction)this.activateAction);
            }
        }
        manager.add((IContributionItem)new Separator());
        Map<String, List<IDynamicSubMenuContributor>> dynamicMenuMap = TasksUiPlugin.getDefault().getDynamicMenuMap();
        for (String menuPath : dynamicMenuMap.keySet()) {
            if (ID_SEPARATOR_CONTEXT.equals(menuPath)) continue;
            for (final IDynamicSubMenuContributor contributor : dynamicMenuMap.get(menuPath)) {
                SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Menu contributor failed"));
                    }

                    public void run() throws Exception {
                        MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                        if (subMenuManager != null) {
                            TaskListView.this.addMenuManager((IMenuManager)subMenuManager, manager, element);
                        }
                    }
                });
            }
        }
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_NAVIGATE));
        manager.add((IContributionItem)new Separator());
        this.addAction((Action)this.copyDetailsAction, manager, element);
        if (task != null) {
            this.addAction(this.removeFromCategoryAction, manager, element);
        }
        this.addAction(this.deleteAction, manager, element);
        if (!(element instanceof ITask)) {
            this.addAction((Action)this.renameAction, manager, element);
        }
        if (element != null && !(element instanceof ITask)) {
            manager.add((IAction)this.goIntoAction);
        }
        if (this.drilledIntoCategory != null) {
            manager.add((IAction)this.goUpAction);
        }
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_CONTEXT));
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_OPERATIONS));
        if (element instanceof ITask) {
            for (String menuPath : dynamicMenuMap.keySet()) {
                if (!ID_SEPARATOR_CONTEXT.equals(menuPath)) continue;
                for (final IDynamicSubMenuContributor contributor : dynamicMenuMap.get(menuPath)) {
                    MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                    if (subMenuManager == null) continue;
                    this.addMenuManager((IMenuManager)subMenuManager, manager, element);
                }
            }
        }
        if (element instanceof IRepositoryQuery) {
            EditRepositoryPropertiesAction repositoryPropertiesAction = new EditRepositoryPropertiesAction();
            repositoryPropertiesAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)element));
            if (repositoryPropertiesAction.isEnabled()) {
                MenuManager subMenu = new MenuManager("Repository");
                manager.add((IContributionItem)subMenu);
                UpdateRepositoryConfigurationAction resetRepositoryConfigurationAction = new UpdateRepositoryConfigurationAction();
                resetRepositoryConfigurationAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)element));
                subMenu.add((IAction)resetRepositoryConfigurationAction);
                subMenu.add((IContributionItem)new Separator());
                subMenu.add((IAction)repositoryPropertiesAction);
            }
        }
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_REPOSITORY));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_PROPERTIES));
    }

    public List<IRepositoryElement> getSelectedTaskContainers() {
        ArrayList<IRepositoryElement> selectedElements = new ArrayList<IRepositoryElement>();
        for (Object object : (IStructuredSelection)this.getViewer().getSelection()) {
            if (!(object instanceof ITaskContainer)) continue;
            selectedElements.add((IRepositoryElement)object);
        }
        return selectedElements;
    }

    private void addMenuManager(IMenuManager menuToAdd, IMenuManager manager, ITaskContainer element) {
        if (element instanceof ITask || element instanceof IRepositoryQuery) {
            manager.add((IContributionItem)menuToAdd);
        }
    }

    private void addAction(Action action, IMenuManager manager, ITaskContainer element) {
        manager.add((IAction)action);
        if (element != null) {
            this.updateActionEnablement(action, element);
        }
    }

    private void updateActionEnablement(Action action, ITaskContainer element) {
        if (element instanceof ITask) {
            if (action instanceof OpenWithBrowserAction) {
                if (TasksUiInternal.isValidUrl(((ITask)element).getUrl())) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
            } else if (action instanceof DeleteAction) {
                action.setEnabled(true);
            } else if (action instanceof OpenTaskListElementAction) {
                action.setEnabled(true);
            } else if (action instanceof CopyTaskDetailsAction) {
                action.setEnabled(true);
            } else if (action instanceof RenameAction) {
                action.setEnabled(true);
            }
        } else if (element != null) {
            if (action instanceof MarkTaskCompleteAction) {
                action.setEnabled(false);
            } else if (action instanceof MarkTaskIncompleteAction) {
                action.setEnabled(false);
            } else if (action instanceof DeleteAction) {
                if (element instanceof UncategorizedTaskContainer) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
            } else if (action instanceof GoIntoAction) {
                TaskCategory cat = (TaskCategory)element;
                if (cat.getChildren().size() > 0) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
            } else if (action instanceof OpenTaskListElementAction) {
                action.setEnabled(true);
            } else if (action instanceof CopyTaskDetailsAction) {
                action.setEnabled(true);
            } else if (action instanceof RenameAction) {
                if (element instanceof AbstractTaskCategory) {
                    AbstractTaskCategory container = (AbstractTaskCategory)element;
                    action.setEnabled(container.isUserManaged());
                } else if (element instanceof IRepositoryQuery) {
                    action.setEnabled(true);
                }
            }
        } else {
            action.setEnabled(true);
        }
    }

    private void makeActions() {
        this.copyDetailsAction = new CopyTaskDetailsAction();
        this.copyDetailsAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.goIntoAction = new GoIntoAction();
        this.goUpAction = new GoUpAction(this.drillDownAdapter);
        this.removeFromCategoryAction = new RemoveFromCategoryAction(this);
        this.renameAction = new RenameAction(this);
        this.filteredTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.renameAction);
        this.deleteAction = new DeleteAction();
        this.collapseAll = new CollapseAllAction(this);
        this.expandAll = new ExpandAllAction(this);
        this.openAction = new OpenTaskListElementAction(this.getViewer());
        this.openWithBrowser = new OpenWithBrowserAction();
        this.filterCompleteTask = new FilterCompletedTasksAction(this);
        this.filterSubTasksAction = new GroupSubTasksAction(this);
        this.synchronizeAutomatically = new SynchronizeAutomaticallyAction();
        this.openPreferencesAction = new OpenTasksUiPreferencesAction();
        this.sortDialogAction = new TaskListSortAction(this.getSite(), this);
        this.filterOnPriorityAction = new PriorityDropDownAction(this);
        this.linkWithEditorAction = new LinkWithEditorAction(this);
        this.presentationDropDownSelectionAction = new PresentationDropDownSelectionAction(this);
        this.filteredTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.openWithBrowser);
        this.filteredTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.copyDetailsAction);
    }

    private void hookOpenAction() {
        this.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TaskListView.this.openAction.run();
            }
        });
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractTask selectedTask;
                if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.activate.when.opened") && (selectedTask = TaskListView.getFromActivePerspective().getSelectedTask()) != null) {
                    TaskListView.this.activateAction.run((ITask)selectedTask);
                }
            }
        });
    }

    public void setFocus() {
        this.filteredTree.getViewer().getControl().setFocus();
    }

    public String getBugIdFromUser() {
        InputDialog dialog = new InputDialog(this.getSite().getWorkbenchWindow().getShell(), "Enter Bugzilla ID", "Enter the Bugzilla ID: ", "", null);
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            return dialog.getValue();
        }
        return null;
    }

    public void refresh(boolean expandIfFocused) {
        if (expandIfFocused && this.isFocusedMode()) {
            try {
                this.getViewer().getControl().setRedraw(false);
                this.refreshJob.refreshNow();
                this.getViewer().expandAll();
            }
            finally {
                this.getViewer().getControl().setRedraw(true);
            }
        } else {
            this.refreshJob.refreshNow();
        }
    }

    public void refresh() {
        this.refreshJob.refreshNow();
    }

    public TaskListToolTip getToolTip() {
        return this.taskListToolTip;
    }

    public TreeViewer getViewer() {
        return this.filteredTree.getViewer();
    }

    public TaskCompletionFilter getCompleteFilter() {
        return this.filterComplete;
    }

    public TaskPriorityFilter getPriorityFilter() {
        return this.filterPriority;
    }

    public void addFilter(AbstractTaskListFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    public void clearFilters(boolean preserveArchiveFilter) {
        this.filters.clear();
        this.filters.add(this.filterArchive);
        this.filters.add(this.filterWorkingSet);
    }

    public void removeFilter(AbstractTaskListFilter filter) {
        this.filters.remove(filter);
    }

    public void updateDrillDownActions() {
        if (this.drillDownAdapter.canGoBack()) {
            this.goUpAction.setEnabled(true);
        } else {
            this.goUpAction.setEnabled(false);
        }
    }

    public void setInRenameAction(boolean b) {
        this.isInRenameAction = b;
    }

    public void goIntoCategory() {
        StructuredSelection structuredSelection;
        Object element;
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof StructuredSelection && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ITaskContainer) {
            this.drilledIntoCategory = (AbstractTaskContainer)element;
            this.drillDownAdapter.goInto();
            IActionBars bars = this.getViewSite().getActionBars();
            bars.getToolBarManager().remove(this.goUpAction.getId());
            bars.getToolBarManager().add((IAction)this.goUpAction);
            bars.updateActionBars();
            this.updateDrillDownActions();
        }
    }

    public void goUpToRoot() {
        this.drilledIntoCategory = null;
        this.drillDownAdapter.goBack();
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().remove("org.eclipse.mylyn.tasklist.actions.view.go.up");
        bars.updateActionBars();
        this.updateDrillDownActions();
    }

    public AbstractTask getSelectedTask() {
        StructuredSelection structuredSelection;
        Object element;
        ISelection selection = this.getViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof StructuredSelection && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ITask) {
            return (AbstractTask)structuredSelection.getFirstElement();
        }
        return null;
    }

    public static AbstractTask getSelectedTask(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return null;
            }
            Object element = structuredSelection.getFirstElement();
            if (element instanceof ITask) {
                return (AbstractTask)structuredSelection.getFirstElement();
            }
        }
        return null;
    }

    public void indicatePaused(boolean paused) {
        this.isPaused = paused;
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        if (this.isPaused) {
            statusLineManager.setMessage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASKS_VIEW), "Mylyn context capture paused");
            this.setPartName("(paused) Task List");
        } else {
            statusLineManager.setMessage("");
            this.setPartName("Task List");
        }
    }

    public AbstractTaskContainer getDrilledIntoCategory() {
        return this.drilledIntoCategory;
    }

    public TaskListFilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    public void selectedAndFocusTask(ITask task) {
        if (task == null || this.getViewer().getControl().isDisposed()) {
            return;
        }
        this.saveSelection();
        IStructuredSelection selection = this.restoreSelection((IRepositoryElement)task);
        this.getViewer().setSelection((ISelection)selection, true);
    }

    private void saveSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ITaskContainer) {
            String handle = ((IRepositoryElement)selection.getFirstElement()).getHandleIdentifier();
            this.lastSelectionByTaskHandle.remove(handle);
            this.lastSelectionByTaskHandle.put(handle, selection);
            if (this.lastSelectionByTaskHandle.size() > 10) {
                Iterator<String> it = this.lastSelectionByTaskHandle.keySet().iterator();
                it.next();
                it.remove();
            }
        }
    }

    private IStructuredSelection restoreSelection(IRepositoryElement task) {
        IStructuredSelection selection = this.lastSelectionByTaskHandle.get(task.getHandleIdentifier());
        if (selection != null) {
            return selection;
        }
        return new StructuredSelection((Object)task);
    }

    public Image[] getPirorityImages() {
        Image[] images = new Image[ITask.PriorityLevel.values().length];
        int i = 0;
        while (i < ITask.PriorityLevel.values().length) {
            images[i] = TasksUiImages.getImageForPriority(ITask.PriorityLevel.values()[i]);
            ++i;
        }
        return images;
    }

    public Set<AbstractTaskListFilter> getFilters() {
        return this.filters;
    }

    public static String getCurrentPriorityLevel() {
        if (TasksUiPlugin.getDefault().getPreferenceStore().contains("org.eclipse.mylyn.tasks.ui.filters.priority")) {
            return TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.filters.priority");
        }
        return ITask.PriorityLevel.P5.toString();
    }

    public TaskArchiveFilter getArchiveFilter() {
        return this.filterArchive;
    }

    public void setManualFiltersEnabled(boolean enabled) {
        this.sortDialogAction.setEnabled(enabled);
        this.filterOnPriorityAction.setEnabled(enabled);
        this.filterCompleteTask.setEnabled(enabled);
    }

    public boolean isScheduledPresentation() {
        return this.currentPresentation != null && "org.eclipse.mylyn.tasks.ui.scheduled".equals(this.currentPresentation.getId());
    }

    public boolean isFocusedMode() {
        return this.focusedMode;
    }

    public void setFocusedMode(boolean focusedMode) {
        if (this.focusedMode == focusedMode) {
            return;
        }
        this.focusedMode = focusedMode;
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        if (focusedMode) {
            manager.remove("org.eclipse.mylyn.tasklist.actions.collapse.all");
        } else {
            manager.prependToGroup(ID_SEPARATOR_CONTEXT, (IAction)this.collapseAll);
        }
        manager.update(false);
    }

    public void setSynchronizationOverlaid(boolean synchronizationOverlaid) {
        this.synchronizationOverlaid = synchronizationOverlaid;
        this.getViewer().refresh();
    }

    public void displayPrioritiesAbove(String priority) {
        this.filterPriority.displayPrioritiesAbove(priority);
        this.getViewer().refresh();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetContentChange".equals(property) || "workingSetRemove".equals(property)) {
            if (this.getSite() != null && this.getSite().getPage() != null && this.filterWorkingSet.updateWorkingSet(this.getSite().getPage().getAggregateWorkingSet())) {
                try {
                    this.getViewer().getControl().setRedraw(false);
                    this.getViewer().refresh();
                    if (this.isFocusedMode()) {
                        this.getViewer().expandAll();
                    }
                }
                finally {
                    this.getViewer().getControl().setRedraw(true);
                }
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskListView.this.filteredTree.indicateActiveTaskWorkingSet();
                }
            });
        }
    }

    public void setLinkWithEditor(boolean linkWithEditor) {
        IEditorPart activeEditor;
        this.linkWithEditor = linkWithEditor;
        this.linkWithEditorAction.setChecked(linkWithEditor);
        if (linkWithEditor && (activeEditor = this.getSite().getPage().getActiveEditor()) != null) {
            this.jumpToEditorTask(activeEditor);
        }
    }

    private void jumpToEditorTask(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof TaskEditorInput) {
            ITask task = ((TaskEditorInput)input).getTask();
            AbstractTask selected = this.getSelectedTask();
            if (selected == null || !selected.equals(task)) {
                this.selectedAndFocusTask(task);
            }
        }
    }

    private void updateToolTip(boolean force) {
        if (this.taskListToolTip != null && this.taskListToolTip.isVisible()) {
            if (!force && this.taskListToolTip.isTriggeredByMouse()) {
                return;
            }
            TreeItem[] selection = this.getViewer().getTree().getSelection();
            if (selection != null && selection.length > 0) {
                Rectangle bounds = selection[0].getBounds();
                this.taskListToolTip.show(new Point(bounds.x, bounds.y));
            }
        }
    }

    public static Set<IWorkingSet> getActiveWorkingSets() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            HashSet allSets = new HashSet(Arrays.asList(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getWorkingSets()));
            HashSet<IWorkingSet> tasksSets = new HashSet<IWorkingSet>(allSets);
            for (IWorkingSet workingSet : allSets) {
                if (workingSet.getId() != null && workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) continue;
                tasksSets.remove(workingSet);
            }
            return tasksSets;
        }
        return Collections.emptySet();
    }

    public static List<AbstractTaskListPresentation> getPresentations() {
        ArrayList<AbstractTaskListPresentation> presentations = new ArrayList<AbstractTaskListPresentation>();
        presentations.addAll(presentationsPrimary);
        presentations.addAll(presentationsSecondary);
        return presentations;
    }

    public static void addPresentation(AbstractTaskListPresentation presentation) {
        if (presentation.isPrimary()) {
            presentationsPrimary.add(presentation);
        } else {
            presentationsSecondary.add(presentation);
        }
    }

    public TaskListTableSorter getSorter() {
        return this.tableSorter;
    }

    private final class TaskListRefreshJob
    extends DelayedRefreshJob {
        private TaskListRefreshJob(TreeViewer treeViewer, String name) {
            super((StructuredViewer)treeViewer, name);
        }

        protected void doRefresh(Object[] items) {
            TreePath selection = this.preserveSelection();
            if (items == null) {
                this.viewer.refresh(true);
            } else if (items.length > 0) {
                try {
                    if (TaskListView.this.isFocusedMode()) {
                        Object item2;
                        HashSet children = new HashSet(Arrays.asList(items));
                        HashSet parents = new HashSet();
                        Object[] objectArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            item2 = objectArray[n2];
                            if (item2 instanceof AbstractTask) {
                                parents.addAll(((AbstractTask)item2).getParentContainers());
                            }
                            ++n2;
                        }
                        children.removeAll(parents);
                        for (AbstractTaskContainer parent : parents) {
                            this.viewer.refresh((Object)parent, false);
                            this.viewer.update((Object)parent, null);
                        }
                        for (Object item2 : children) {
                            this.viewer.refresh(item2, true);
                        }
                        objectArray = items;
                        n = items.length;
                        int n3 = 0;
                        while (n3 < n) {
                            item2 = objectArray[n3];
                            this.updateExpansionState(item2);
                            ++n3;
                        }
                    } else {
                        HashSet parents = new HashSet();
                        Object[] objectArray = items;
                        int n = items.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Object item = objectArray[n4];
                            if (item instanceof AbstractTask) {
                                parents.addAll(((AbstractTask)item).getParentContainers());
                            }
                            this.viewer.refresh(item, true);
                            this.updateExpansionState(item);
                            ++n4;
                        }
                        for (AbstractTaskContainer parent : parents) {
                            this.viewer.update((Object)parent, null);
                        }
                    }
                }
                catch (SWTException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to refresh viewer: " + this.viewer, (Throwable)e));
                }
            }
            TaskListView.this.updateToolTip(false);
            this.restoreSelection(selection);
        }

        private TreePath preserveSelection() {
            TreeViewer treeViewer;
            TreeItem[] selection;
            if (this.viewer instanceof TreeViewer && (selection = (treeViewer = (TreeViewer)this.viewer).getTree().getSelection()).length > 0) {
                TreeWalker treeWalker = new TreeWalker(treeViewer);
                return treeWalker.walk(new TreeWalker.TreeVisitor(){

                    public boolean visit(Object object) {
                        return true;
                    }
                }, selection[selection.length - 1]);
            }
            return null;
        }

        private void restoreSelection(TreePath treePath) {
            ISelection newSelection;
            if (treePath != null && ((newSelection = this.viewer.getSelection()) == null || newSelection.isEmpty())) {
                this.viewer.setSelection((ISelection)new TreeSelection(treePath), true);
            }
        }

        protected void updateExpansionState(Object item) {
            if (TaskListView.this.isFocusedMode()) {
                TaskListView.this.getViewer().expandToLevel(item, 3);
            }
        }
    }
}

