/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.SelectRepositoryConnectorPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewRepositoryWizard
extends Wizard
implements INewWizard {
    private AbstractRepositoryConnector connector;
    private final String connectorKind;
    private TaskRepository taskRepository;
    private SelectRepositoryConnectorPage selectConnectorPage;
    private ITaskRepositoryPage settingsPage;
    private String lastConnectorKind;

    public NewRepositoryWizard() {
        this(null);
    }

    public NewRepositoryWizard(String connectorKind) {
        this.connectorKind = connectorKind;
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Add Task Repository");
    }

    public void addPages() {
        Collection connectors = TasksUi.getRepositoryManager().getRepositoryConnectors();
        if (this.connectorKind != null || connectors.size() == 1) {
            this.connector = this.connectorKind != null ? TasksUi.getRepositoryManager().getRepositoryConnector(this.connectorKind) : connectors.toArray(new AbstractRepositoryConnector[1])[0];
            this.updateSettingsPage();
            this.addPage(this.settingsPage);
        } else {
            this.selectConnectorPage = new SelectRepositoryConnectorPage();
            this.addPage((IWizardPage)this.selectConnectorPage);
        }
    }

    public boolean canFinish() {
        return (this.selectConnectorPage == null || this.selectConnectorPage.isPageComplete()) && this.getContainer().getCurrentPage() != this.selectConnectorPage && this.settingsPage != null && this.settingsPage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectConnectorPage) {
            this.connector = this.selectConnectorPage.getConnector();
            this.updateSettingsPage();
            return this.settingsPage;
        }
        return super.getNextPage(page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            this.taskRepository = new TaskRepository(this.connector.getConnectorKind(), this.settingsPage.getRepositoryUrl());
            this.settingsPage.applyTo(this.taskRepository);
            TasksUi.getRepositoryManager().addRepository(this.taskRepository);
            return true;
        }
        return false;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    private void updateSettingsPage() {
        assert (this.connector != null);
        if (!this.connector.getConnectorKind().equals(this.lastConnectorKind)) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.connector.getConnectorKind());
            this.settingsPage = connectorUi.getSettingsPage(null);
            this.settingsPage.setWizard((IWizard)this);
            this.lastConnectorKind = this.connector.getConnectorKind();
        }
    }
}

