/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TaskDataExportWizardPage
extends WizardPage {
    private static final String LABEL_TASK_LIST = "Task List";
    private static final String LABEL_TASK_CONTEXTS = "Task Contexts";
    private static final String LABEL_ACTIVITY_HISTORY = "Task Activity History";
    protected static final String PAGE_TITLE = "Export Mylyn Task Data";
    public static final String PAGE_NAME = "Export Mylyn Task Data";
    private Button taskListCheckBox = null;
    private Button taskActivationHistoryCheckBox = null;
    private Button taskContextsCheckBox = null;
    private Button browseButton = null;
    private Text destDirText = null;
    private Button overwriteCheckBox = null;
    private static final String SETTINGS_SAVED = "Settings saved";
    private static final String TASKLIST_SETTING = "TaskList setting";
    private static final String ACTIVATION_HISTORY_SETTING = "Activation history setting";
    private static final String CONTEXTS_SETTING = "Contexts setting";
    private static final String DEST_DIR_SETTING = "Destination directory setting";
    private static final String OVERWRITE_SETTING = "Overwrite setting";

    public TaskDataExportWizardPage() {
        super("org.eclipse.mylyn.tasklist.exportPage", "Export Mylyn Task Data", AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.tasks.ui", (String)"icons/wizban/banner-export.gif"));
        this.setPageComplete(false);
    }

    public String getName() {
        return "Export Mylyn Task Data";
    }

    public void createControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            container.setLayout((Layout)layout);
            this.createFileSelectionControl(container);
            this.createExportDirectoryControl(container);
            this.overwriteCheckBox = this.createCheckBox(container, "Overwrite existing files without warning");
            this.initSettings();
            this.setControl((Control)container);
            this.setPageComplete(this.validate());
        }
        catch (RuntimeException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create export wizard page", (Throwable)e));
        }
    }

    private void createFileSelectionControl(Composite parent) {
        Group group = new Group(parent, 16);
        GridLayout gl = new GridLayout(1, false);
        group.setLayout((Layout)gl);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        group.setText("Select data to export:");
        this.taskListCheckBox = this.createCheckBox((Composite)group, LABEL_TASK_LIST);
        this.taskActivationHistoryCheckBox = this.createCheckBox((Composite)group, LABEL_ACTIVITY_HISTORY);
        this.taskContextsCheckBox = this.createCheckBox((Composite)group, LABEL_TASK_CONTEXTS);
    }

    private void createExportDirectoryControl(Composite parent) {
        Group destDirGroup = new Group(parent, 16);
        destDirGroup.setText("Export destination");
        destDirGroup.setLayout((Layout)new GridLayout(3, false));
        destDirGroup.setLayoutData((Object)new GridData(768));
        new Label((Composite)destDirGroup, 0).setText("File:");
        Label l = new Label((Composite)destDirGroup, 0);
        l.setText(TaskListBackupManager.getBackupFileName());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        new Label((Composite)destDirGroup, 0).setText("Folder:");
        this.destDirText = new Text((Composite)destDirGroup, 2048);
        this.destDirText.setEditable(false);
        this.destDirText.setLayoutData((Object)new GridData(768));
        this.destDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskDataExportWizardPage.this.controlChanged();
            }
        });
        this.browseButton = new Button((Composite)destDirGroup, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(TaskDataExportWizardPage.this.getShell());
                dialog.setText("Folder Selection");
                dialog.setMessage("Specify the destination folder for task data");
                String dir = TaskDataExportWizardPage.this.destDirText.getText();
                dialog.setFilterPath(dir);
                dir = dialog.open();
                TaskDataExportWizardPage.this.controlChanged();
                if (dir == null || dir.equals("")) {
                    return;
                }
                TaskDataExportWizardPage.this.destDirText.setText(dir);
            }
        });
    }

    protected void initSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(SETTINGS_SAVED) == null) {
            this.taskListCheckBox.setSelection(true);
            this.taskActivationHistoryCheckBox.setSelection(true);
            this.taskContextsCheckBox.setSelection(true);
            this.destDirText.setText("");
            this.overwriteCheckBox.setSelection(true);
        } else {
            this.taskListCheckBox.setSelection(true);
            this.taskActivationHistoryCheckBox.setSelection(settings.getBoolean(ACTIVATION_HISTORY_SETTING));
            this.taskContextsCheckBox.setSelection(settings.getBoolean(CONTEXTS_SETTING));
            String directory = settings.get(DEST_DIR_SETTING);
            if (directory != null) {
                this.destDirText.setText(settings.get(DEST_DIR_SETTING));
            }
            this.overwriteCheckBox.setSelection(settings.getBoolean(OVERWRITE_SETTING));
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(TASKLIST_SETTING, this.taskListCheckBox.getSelection());
        settings.put(ACTIVATION_HISTORY_SETTING, this.taskActivationHistoryCheckBox.getSelection());
        settings.put(CONTEXTS_SETTING, this.taskContextsCheckBox.getSelection());
        settings.put(DEST_DIR_SETTING, this.destDirText.getText());
        settings.put(OVERWRITE_SETTING, this.overwriteCheckBox.getSelection());
        settings.put(SETTINGS_SAVED, SETTINGS_SAVED);
    }

    protected Button createCheckBox(Composite parent, String text) {
        Button newButton = new Button(parent, 32);
        newButton.setText(text);
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataExportWizardPage.this.controlChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return newButton;
    }

    public void controlChanged() {
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        this.setMessage(null);
        if (!(this.taskListCheckBox.getSelection() || this.taskActivationHistoryCheckBox.getSelection() || this.taskContextsCheckBox.getSelection())) {
            this.setMessage("Please select which task data to export", 2);
            return false;
        }
        if (this.destDirText.getText().equals("")) {
            this.setMessage("Please choose an export destination", 2);
            return false;
        }
        return true;
    }

    public String getDestinationDirectory() {
        return this.destDirText.getText();
    }

    public boolean exportTaskList() {
        return this.taskListCheckBox.getSelection();
    }

    public boolean exportActivationHistory() {
        return this.taskActivationHistoryCheckBox.getSelection();
    }

    public boolean exportTaskContexts() {
        return this.taskContextsCheckBox.getSelection();
    }

    public boolean overwrite() {
        return this.overwriteCheckBox.getSelection();
    }

    public boolean zip() {
        return true;
    }

    public void setParameters(boolean overwrite, boolean exportTaskList, boolean exportActivationHistory, boolean exportTaskContexts, boolean zip, String destinationDir) {
        this.overwriteCheckBox.setSelection(overwrite);
        this.taskListCheckBox.setSelection(exportTaskList);
        this.taskActivationHistoryCheckBox.setSelection(exportActivationHistory);
        this.taskContextsCheckBox.setSelection(exportTaskContexts);
        this.destDirText.setText(destinationDir);
    }
}

