/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataImportWizardPage;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TaskDataImportWizard
extends Wizard
implements IImportWizard {
    private static final String SETTINGS_SECTION = "org.eclipse.mylyn.tasklist.ui.importWizard";
    private static final String WINDOW_TITLE = "Import";
    private TaskDataImportWizardPage importPage = null;

    public TaskDataImportWizard() {
        IDialogSettings masterSettings = TasksUiPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WINDOW_TITLE);
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings settings = master.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = master.addNewSection(SETTINGS_SECTION);
        }
        return settings;
    }

    public void addPages() {
        this.importPage = new TaskDataImportWizardPage();
        this.importPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.importPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return this.importPage.isPageComplete();
    }

    public boolean performFinish() {
        TasksUi.getTaskActivityManager().deactivateTask(TasksUi.getTaskActivityManager().getActiveTask());
        File sourceDirFile = null;
        File sourceZipFile = null;
        File sourceTaskListFile = null;
        File sourceRepositoriesFile = null;
        File sourceActivationHistoryFile = null;
        ArrayList<File> contextFiles = new ArrayList<File>();
        ArrayList<ZipEntry> zipFilesToExtract = new ArrayList<ZipEntry>();
        boolean overwrite = this.importPage.overwrite();
        String sourceZip = this.importPage.getSourceZipFile();
        sourceZipFile = new File(sourceZip);
        if (!sourceZipFile.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"File not found", (String)(String.valueOf(sourceZipFile.toString()) + " could not be found."));
            return false;
        }
        boolean restoreM2Tasklist = false;
        try {
            ZipFile zipFile = new ZipFile(sourceZipFile, 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !this.importPage.importTaskList() && entry.getName().startsWith("tasklist.xml")) continue;
                if (this.importPage.importTaskList() && entry.getName().startsWith("tasklist.xml")) {
                    restoreM2Tasklist = true;
                }
                if (!this.importPage.importTaskList() && entry.getName().startsWith("tasks.xml.zip") || !this.importPage.importActivationHistory() && entry.getName().endsWith("activity.xml") || !this.importPage.importTaskContexts() && entry.getName().matches(".*-\\d*.xml$")) continue;
                File destContextFile = new File(String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + entry.getName());
                if (!overwrite && destContextFile.exists()) {
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"File exists!", (String)("Overwrite existing file?\n" + destContextFile.getName()))) continue;
                    zipFilesToExtract.add(entry);
                    continue;
                }
                zipFilesToExtract.add(entry);
            }
        }
        catch (IOException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not import files", (Throwable)e));
        }
        FileCopyJob job = new FileCopyJob(sourceDirFile, sourceZipFile, sourceTaskListFile, sourceRepositoriesFile, sourceActivationHistoryFile, contextFiles, zipFilesToExtract);
        job.setRestoreM2Tasklist(restoreM2Tasklist);
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, (IRunnableWithProgress)job);
            } else {
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                service.run(true, true, (IRunnableWithProgress)job);
            }
        }
        catch (InvocationTargetException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not import files", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {}
        this.importPage.saveSettings();
        return true;
    }

    private void readTaskListData() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    TasksUiPlugin.getDefault().reloadDataDirectory();
                }
                catch (CoreException e) {
                    TasksUiInternal.displayStatus("Import Error: Please retry importing or use alternate source", e.getStatus());
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileCopyJob
    implements IRunnableWithProgress {
        private static final String PREFIX_BACKUP = ".backup-";
        private static final String JOB_LABEL = "Importing Data";
        private File sourceZipFile = null;
        private final List<ZipEntry> zipEntriesToExtract;
        private boolean restoreM2Tasklist = false;

        public FileCopyJob(File sourceFolder, File sourceZipFile, File sourceTaskListFile, File sourceRepositoriesFile, File sourceActivationHistoryFile, List<File> contextFiles, List<ZipEntry> zipEntries) {
            this.sourceZipFile = sourceZipFile;
            this.zipEntriesToExtract = zipEntries;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    monitor.beginTask(JOB_LABEL, this.zipEntriesToExtract.size() + 2);
                    Job.getJobManager().beginRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE, monitor);
                    if (!this.sourceZipFile.exists()) {
                        throw new InvocationTargetException(new IOException("Source file does not exist."));
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ZipFileUtil.extactEntries((File)this.sourceZipFile, this.zipEntriesToExtract, (String)TasksUiPlugin.getDefault().getDataDirectory());
                    if (this.restoreM2Tasklist) {
                        File taskListFileSnapshot;
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
                        String date = format.format(new Date());
                        File taskListFile = new File(TasksUiPlugin.getDefault().getDataDirectory(), "tasks.xml.zip");
                        if (taskListFile.exists()) {
                            taskListFile.renameTo(new File(taskListFile.getParentFile(), String.valueOf(taskListFile.getName()) + PREFIX_BACKUP + date));
                        }
                        if ((taskListFileSnapshot = new File(TasksUiPlugin.getDefault().getDataDirectory(), ".tasks.xml.zip")).exists()) {
                            taskListFileSnapshot.renameTo(new File(taskListFile.getParentFile(), String.valueOf(taskListFileSnapshot.getName()) + PREFIX_BACKUP + date));
                        }
                    }
                    TaskDataImportWizard.this.readTaskListData();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                Job.getJobManager().endRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
                monitor.done();
            }
        }

        public void setRestoreM2Tasklist(boolean restoreM2Tasklist) {
            this.restoreM2Tasklist = restoreM2Tasklist;
        }
    }
}

