/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.swing.text.html.HTML;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.net.HtmlTag;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.GzipGetMethod;
import org.eclipse.mylyn.internal.bugzilla.core.GzipPostMethod;
import org.eclipse.mylyn.internal.bugzilla.core.MultiBugReportFactory;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfigurationFactory;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryQueryResultsFactory;
import org.eclipse.mylyn.internal.bugzilla.core.history.TaskHistory;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaClient {
    private static final String COOKIE_BUGZILLA_LOGIN = "Bugzilla_login";
    protected static final String USER_AGENT = "BugzillaConnector";
    private static final int MAX_RETRIEVED_PER_QUERY = 100;
    private static final String QUERY_DELIMITER = "?";
    private static final String KEY_ID = "id";
    private static final String VAL_TRUE = "true";
    private static final String KEY_CC = "cc";
    private static final String POST_BUG_CGI = "/post_bug.cgi";
    private static final String PROCESS_BUG_CGI = "/process_bug.cgi";
    public static final int WRAP_LENGTH = 80;
    private static final String VAL_PROCESS_BUG = "process_bug";
    private static final String KEY_FORM_NAME = "form_name";
    private static final String VAL_NONE = "none";
    private static final String KEY_KNOB = "knob";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_SHORT_DESC = "short_desc";
    private static final String VALUE_CONTENTTYPEMETHOD_MANUAL = "manual";
    private static final String VALUE_ISPATCH = "1";
    private static final String VALUE_ACTION_INSERT = "insert";
    private static final String ATTRIBUTE_CONTENTTYPEENTRY = "contenttypeentry";
    private static final String ATTRIBUTE_CONTENTTYPEMETHOD = "contenttypemethod";
    private static final String ATTRIBUTE_ISPATCH = "ispatch";
    private static final String CONTENT_TYPE_APP_RDF_XML = "application/rdf+xml";
    private static final String CONTENT_TYPE_APP_XML = "application/xml";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private static final String[] VALID_CONFIG_CONTENT_TYPES = new String[]{"application/rdf+xml", "application/xml", "text/xml"};
    private static final String ATTR_CHARSET = "charset";
    private static IdleConnectionTimeoutThread idleConnectionTimeoutThread = new IdleConnectionTimeoutThread();
    protected Proxy proxy = Proxy.NO_PROXY;
    protected String username;
    protected String password;
    protected URL repositoryUrl;
    protected String characterEncoding;
    private boolean authenticated;
    private final Map<String, String> configParameters;
    private final HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    private boolean lastModifiedSupported = true;
    private final BugzillaLanguageSettings bugzillaLanguageSettings;
    private RepositoryConfiguration repositoryConfiguration;
    private HostConfiguration hostConfiguration;
    private final AbstractWebLocation location;

    static {
        idleConnectionTimeoutThread.start();
    }

    public BugzillaClient(AbstractWebLocation location, String characterEncoding, Map<String, String> configParameters, BugzillaLanguageSettings languageSettings) throws MalformedURLException {
        AuthenticationCredentials credentials = location.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            this.username = credentials.getUserName();
            this.password = credentials.getPassword();
        }
        this.repositoryUrl = new URL(location.getUrl());
        this.location = location;
        this.characterEncoding = characterEncoding;
        this.configParameters = configParameters;
        this.bugzillaLanguageSettings = languageSettings;
        this.proxy = location.getProxyForHost(location.getUrl(), "HTTP");
        WebUtil.configureHttpClient((HttpClient)this.httpClient, (String)USER_AGENT);
        idleConnectionTimeoutThread.addConnectionManager(this.httpClient.getHttpConnectionManager());
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        idleConnectionTimeoutThread.removeConnectionManager(this.httpClient.getHttpConnectionManager());
    }

    public void validate(IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        GzipGetMethod method = null;
        try {
            this.logout(monitor);
            method = this.getConnect(this.repositoryUrl + "/", monitor);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    protected boolean hasAuthenticationCredentials() {
        return this.username != null && this.username.length() > 0;
    }

    private GzipGetMethod getConnect(String serverURL, IProgressMonitor monitor) throws IOException, CoreException {
        return this.connectInternal(serverURL, false, monitor);
    }

    private GzipGetMethod getConnectGzip(String serverURL, IProgressMonitor monitor) throws IOException, CoreException {
        return this.connectInternal(serverURL, true, monitor);
    }

    private GzipGetMethod connectInternal(String requestURL, boolean gzip, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        int attempt = 0;
        while (attempt < 2) {
            int code;
            if (!this.authenticated && this.hasAuthenticationCredentials()) {
                this.authenticate(monitor);
            }
            GzipGetMethod getMethod = new GzipGetMethod(WebUtil.getRequestPath((String)requestURL), gzip);
            if (requestURL.contains(QUERY_DELIMITER)) {
                getMethod.setQueryString(requestURL.substring(requestURL.indexOf(QUERY_DELIMITER)));
            }
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
            this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
            getMethod.setDoAuthentication(true);
            try {
                code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)getMethod, (IProgressMonitor)monitor);
            }
            catch (IOException e) {
                getMethod.getResponseBodyNoop();
                getMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
            if (code == 200) {
                return getMethod;
            }
            if (code != 401 && code != 403) {
                if (code == 407) {
                    this.authenticated = false;
                    getMethod.getResponseBodyNoop();
                    getMethod.releaseConnection();
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                }
                getMethod.getResponseBodyNoop();
                getMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
            }
            getMethod.getResponseBodyNoop();
            getMethod.releaseConnection();
            this.authenticated = false;
            this.authenticate(monitor);
            ++attempt;
        }
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "All connection attempts to " + this.repositoryUrl.toString() + " failed. Please verify connection and authentication information."));
    }

    public void logout(IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        this.authenticated = true;
        String loginUrl = this.repositoryUrl + "/relogin.cgi";
        GzipGetMethod method = null;
        try {
            method = this.getConnect(loginUrl, monitor);
            this.authenticated = false;
            this.httpClient.getState().clearCookies();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private InputStream getResponseStream(HttpMethodBase method, IProgressMonitor monitor) throws IOException {
        InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
        if (this.isZippedReply(method)) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    private boolean isZippedReply(HttpMethodBase method) {
        boolean zipped = method.getResponseHeader("Content-encoding") != null && method.getResponseHeader("Content-encoding").getValue().equals("gzip") || method.getResponseHeader("Content-Type") != null && method.getResponseHeader("Content-Type").getValue().equals("application/x-gzip");
        return zipped;
    }

    public void authenticate(IProgressMonitor monitor) throws CoreException {
        block17: {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            if (!this.hasAuthenticationCredentials()) {
                this.authenticated = false;
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Authentication credentials missing."));
            }
            GzipPostMethod postMethod = null;
            try {
                try {
                    int code;
                    this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
                    NameValuePair[] formData = new NameValuePair[]{new NameValuePair(COOKIE_BUGZILLA_LOGIN, this.username), new NameValuePair("Bugzilla_password", this.password)};
                    postMethod = new GzipPostMethod(WebUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl.toString()) + "/index.cgi")), true);
                    postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
                    postMethod.setRequestBody(formData);
                    postMethod.setDoAuthentication(true);
                    postMethod.setFollowRedirects(false);
                    this.httpClient.getState().clearCookies();
                    AuthenticationCredentials httpAuthCredentials = this.location.getCredentials(AuthenticationType.HTTP);
                    if (httpAuthCredentials != null && httpAuthCredentials.getUserName() != null && httpAuthCredentials.getUserName().length() > 0) {
                        this.httpClient.getParams().setAuthenticationPreemptive(true);
                    }
                    if ((code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)postMethod, (IProgressMonitor)monitor)) == 401 || code == 403) {
                        this.authenticated = false;
                        postMethod.getResponseBodyNoop();
                        postMethod.releaseConnection();
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "HTTP authentication failed."));
                    }
                    if (code == 407) {
                        this.authenticated = false;
                        postMethod.getResponseBodyNoop();
                        postMethod.releaseConnection();
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                    }
                    if (code != 200) {
                        this.authenticated = false;
                        postMethod.getResponseBodyNoop();
                        postMethod.releaseConnection();
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
                    }
                    if (this.hasAuthenticationCredentials()) {
                        Cookie[] cookieArray = this.httpClient.getState().getCookies();
                        int n = cookieArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Cookie cookie = cookieArray[n2];
                            if (cookie.getName().equals(COOKIE_BUGZILLA_LOGIN)) {
                                this.authenticated = true;
                                break;
                            }
                            ++n2;
                        }
                        if (this.authenticated) break block17;
                        InputStream input = this.getResponseStream((HttpMethodBase)postMethod, monitor);
                        try {
                            this.parseHtmlError(input);
                            break block17;
                        }
                        finally {
                            input.close();
                        }
                    }
                    this.authenticated = true;
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
                }
            }
            finally {
                if (postMethod != null) {
                    postMethod.releaseConnection();
                }
                this.httpClient.getParams().setAuthenticationPreemptive(false);
            }
        }
    }

    public TaskData getTaskData(int id, TaskAttributeMapper mapper, IProgressMonitor monitor) throws IOException, CoreException {
        String idString = String.valueOf(id);
        HashSet<String> data = new HashSet<String>();
        data.add(idString);
        final TaskData[] retrievedData = new TaskData[1];
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                BugzillaClient.this.getRepositoryConfiguration().configureTaskData(taskData);
                retrievedData[0] = taskData;
            }
        };
        this.getTaskData(data, collector, mapper, monitor);
        return retrievedData[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getSearchHits(IRepositoryQuery query, TaskDataCollector collector, TaskAttributeMapper mapper, IProgressMonitor monitor) throws IOException, CoreException {
        GzipPostMethod postMethod;
        block16: {
            NameValuePair ctypePair;
            int n;
            String[] result;
            postMethod = null;
            String queryUrl = query.getUrl();
            int start = queryUrl.indexOf(63);
            ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
            if (start != -1 && (result = (queryUrl = queryUrl.substring(start + 1)).split("&")).length > 0) {
                String[] stringArray = result;
                n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String[] nameValue = string.split("=");
                    if (nameValue.length == 1) {
                        pairs.add(new NameValuePair(nameValue[0].trim(), ""));
                    } else if (nameValue.length == 2 && nameValue[0] != null && nameValue[1] != null) {
                        pairs.add(new NameValuePair(nameValue[0].trim(), URLDecoder.decode(nameValue[1].trim(), this.characterEncoding)));
                    }
                    ++n2;
                }
            }
            if (!pairs.contains(ctypePair = new NameValuePair("ctype", "rdf"))) {
                pairs.add(ctypePair);
            }
            if ((postMethod = this.postFormData("/buglist.cgi", pairs.toArray(new NameValuePair[pairs.size()]), monitor)).getResponseHeader("Content-Type") == null) break block16;
            Header responseTypeHeader = postMethod.getResponseHeader("Content-Type");
            String[] stringArray = VALID_CONFIG_CONTENT_TYPES;
            int n3 = VALID_CONFIG_CONTENT_TYPES.length;
            n = 0;
            while (n < n3) {
                String type = stringArray[n];
                if (responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type)) {
                    InputStream stream = this.getResponseStream((HttpMethodBase)postMethod, monitor);
                    try {
                        RepositoryQueryResultsFactory queryFactory = new RepositoryQueryResultsFactory(stream, this.characterEncoding);
                        int count = queryFactory.performQuery(this.repositoryUrl.toString(), collector, mapper, 5000);
                        boolean bl = count > 0;
                        return bl;
                    }
                    finally {
                        stream.close();
                    }
                }
                ++n;
            }
        }
        this.parseHtmlError(this.getResponseStream((HttpMethodBase)postMethod, monitor));
        return false;
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
    }

    public static void setupExistingBugAttributes(String serverUrl, TaskData existingReport) {
        BugzillaAttribute[] reportElements;
        BugzillaAttribute[] bugzillaAttributeArray = reportElements = new BugzillaAttribute[]{BugzillaAttribute.SHORT_DESC, BugzillaAttribute.BUG_STATUS, BugzillaAttribute.RESOLUTION, BugzillaAttribute.BUG_ID, BugzillaAttribute.REP_PLATFORM, BugzillaAttribute.PRODUCT, BugzillaAttribute.OP_SYS, BugzillaAttribute.COMPONENT, BugzillaAttribute.VERSION, BugzillaAttribute.PRIORITY, BugzillaAttribute.BUG_SEVERITY, BugzillaAttribute.ASSIGNED_TO, BugzillaAttribute.TARGET_MILESTONE, BugzillaAttribute.REPORTER, BugzillaAttribute.DEPENDSON, BugzillaAttribute.BLOCKED, BugzillaAttribute.BUG_FILE_LOC, BugzillaAttribute.NEWCC, BugzillaAttribute.KEYWORDS, BugzillaAttribute.CC, BugzillaAttribute.NEW_COMMENT, BugzillaAttribute.QA_CONTACT, BugzillaAttribute.STATUS_WHITEBOARD, BugzillaAttribute.DEADLINE};
        int n = reportElements.length;
        int n2 = 0;
        while (n2 < n) {
            BugzillaAttribute element = bugzillaAttributeArray[n2];
            BugzillaTaskDataHandler.createAttribute(existingReport, element);
            ++n2;
        }
    }

    public static String getBugUrlWithoutLogin(String repositoryUrl, String id) {
        String url = String.valueOf(repositoryUrl) + "/show_bug.cgi?id=" + id;
        return url;
    }

    public static String getCharsetFromString(String string) {
        int charsetStartIndex = string.indexOf(ATTR_CHARSET);
        if (charsetStartIndex != -1) {
            int charsetEndIndex = string.indexOf("\"", charsetStartIndex);
            if (charsetEndIndex == -1) {
                charsetEndIndex = string.length();
            }
            String charsetString = string.substring(charsetStartIndex + 8, charsetEndIndex);
            if (Charset.availableCharsets().containsKey(charsetString)) {
                return charsetString;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RepositoryConfiguration getRepositoryConfiguration(IProgressMonitor monitor) throws IOException, CoreException {
        GzipGetMethod method = null;
        int attempt = 0;
        if (attempt < 2) {
            try {
                method = this.getConnectGzip(this.repositoryUrl + "/config.cgi?ctype=rdf", monitor);
                if (method == null) {
                    throw new IOException("Could not retrieve configuratoin. HttpClient return null method.");
                }
                InputStream stream = this.getResponseStream((HttpMethodBase)method, monitor);
                try {
                    if (method.getResponseHeader("Content-Type") != null) {
                        Header responseTypeHeader = method.getResponseHeader("Content-Type");
                        String[] stringArray = VALID_CONFIG_CONTENT_TYPES;
                        int n = VALID_CONFIG_CONTENT_TYPES.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String type = stringArray[n2];
                            if (responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type)) {
                                RepositoryConfigurationFactory configFactory = new RepositoryConfigurationFactory(stream, this.characterEncoding);
                                this.repositoryConfiguration = configFactory.getConfiguration();
                                if (this.repositoryConfiguration != null) {
                                    if (!this.repositoryConfiguration.getProducts().isEmpty()) {
                                        this.repositoryConfiguration.setRepositoryUrl(this.repositoryUrl.toString());
                                        RepositoryConfiguration repositoryConfiguration = this.repositoryConfiguration;
                                        return repositoryConfiguration;
                                    }
                                    if (attempt != 0) throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "Unable to retrieve repository configuration. Ensure credentials are valid."));
                                    this.authenticated = false;
                                    break;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (this.authenticated) {
                        this.parseHtmlError(stream);
                        return null;
                    }
                }
                finally {
                    stream.close();
                }
            }
            finally {
                ++attempt;
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return null;
    }

    public void getAttachmentData(String attachmentId, OutputStream out, IProgressMonitor monitor) throws IOException, CoreException {
        String url = this.repositoryUrl + "/attachment.cgi?id=" + attachmentId;
        GzipGetMethod method = this.connectInternal(url, false, monitor);
        try {
            int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (status == 200) {
                out.write(method.getResponseBody());
            } else {
                this.parseHtmlError(method.getResponseBodyAsStream());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void postAttachment(String bugReportID, String comment, String description, String contentType, boolean isPatch, PartSource source, IProgressMonitor monitor) throws HttpException, IOException, CoreException {
        block14: {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            Assert.isNotNull((Object)bugReportID);
            Assert.isNotNull((Object)source);
            Assert.isNotNull((Object)contentType);
            this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
            if (!this.authenticated && this.hasAuthenticationCredentials()) {
                this.authenticate(monitor);
            }
            GzipPostMethod postMethod = null;
            try {
                postMethod = new GzipPostMethod(WebUtil.getRequestPath((String)(this.repositoryUrl + "/attachment.cgi")), true);
                postMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                ArrayList<Object> parts = new ArrayList<Object>();
                parts.add(new StringPart("action", VALUE_ACTION_INSERT, this.characterEncoding));
                if (this.username != null && this.password != null) {
                    parts.add(new StringPart(COOKIE_BUGZILLA_LOGIN, this.username, this.characterEncoding));
                    parts.add(new StringPart("Bugzilla_password", this.password, this.characterEncoding));
                }
                parts.add(new StringPart("bugid", bugReportID, this.characterEncoding));
                if (description != null) {
                    parts.add(new StringPart("description", description, this.characterEncoding));
                }
                if (comment != null) {
                    parts.add(new StringPart(KEY_COMMENT, comment, this.characterEncoding));
                }
                parts.add(new FilePart("data", source));
                if (isPatch) {
                    parts.add(new StringPart(ATTRIBUTE_ISPATCH, VALUE_ISPATCH));
                } else {
                    parts.add(new StringPart(ATTRIBUTE_CONTENTTYPEMETHOD, VALUE_CONTENTTYPEMETHOD_MANUAL));
                    parts.add(new StringPart(ATTRIBUTE_CONTENTTYPEENTRY, contentType));
                }
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[1]), postMethod.getParams()));
                postMethod.setDoAuthentication(true);
                int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)postMethod, (IProgressMonitor)monitor);
                if (status == 200) {
                    InputStream input = this.getResponseStream((HttpMethodBase)postMethod, monitor);
                    try {
                        this.parseHtmlError(input);
                        break block14;
                    }
                    finally {
                        input.close();
                    }
                }
                postMethod.getResponseBodyNoop();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, this.repositoryUrl.toString(), "Http error: " + HttpStatus.getStatusText((int)status)));
            }
            finally {
                if (postMethod != null) {
                    postMethod.releaseConnection();
                }
            }
        }
    }

    private GzipPostMethod postFormData(String formUrl, NameValuePair[] formData, IProgressMonitor monitor) throws IOException, CoreException {
        GzipPostMethod postMethod = null;
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        if (!this.authenticated && this.hasAuthenticationCredentials()) {
            this.authenticate(monitor);
        }
        postMethod = new GzipPostMethod(WebUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl.toString()) + formUrl)), true);
        postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(WebUtil.getConnectionTimeout());
        postMethod.setRequestBody(formData);
        postMethod.setDoAuthentication(true);
        int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)postMethod, (IProgressMonitor)monitor);
        if (status == 200) {
            return postMethod;
        }
        postMethod.getResponseBodyNoop();
        postMethod.releaseConnection();
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), new IOException("Communication error occurred during upload. \n\n" + HttpStatus.getStatusText((int)status))));
    }

    public RepositoryResponse postTaskData(TaskData taskData, IProgressMonitor monitor) throws IOException, CoreException {
        NameValuePair[] formData = null;
        String prefix = null;
        String prefix2 = null;
        String postfix = null;
        String postfix2 = null;
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        if (taskData == null) {
            return null;
        }
        if (taskData.isNew()) {
            formData = this.getPairsForNew(taskData);
            prefix = "Bug ";
            prefix2 = "Issue ";
            postfix = " posted";
            postfix2 = " Submitted";
        } else {
            formData = this.getPairsForExisting(taskData, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        String result = null;
        GzipPostMethod method = null;
        InputStream input = null;
        try {
            method = taskData.isNew() ? this.postFormData(POST_BUG_CGI, formData, monitor) : this.postFormData(PROCESS_BUG_CGI, formData, monitor);
            if (method == null) {
                throw new IOException("Could not post form, client returned null method.");
            }
            input = this.getResponseStream((HttpMethodBase)method, monitor);
            BufferedReader in = new BufferedReader(new InputStreamReader(input, method.getRequestCharSet()));
            if (in.markSupported()) {
                in.mark(1028);
            }
            HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)in, null);
            boolean existingBugPosted = false;
            boolean isTitle = false;
            String title = "";
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.TITLE && !((HtmlTag)token.getValue()).isEndTag()) {
                    isTitle = true;
                } else if (isTitle) {
                    if (token.getType() != HtmlStreamTokenizer.Token.TAG) {
                        title = String.valueOf(title) + ((StringBuffer)token.getValue()).toString().toLowerCase(Locale.ENGLISH) + " ";
                    } else if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.TITLE && ((HtmlTag)token.getValue()).isEndTag()) {
                        boolean found = false;
                        Iterator<String> iterator = this.bugzillaLanguageSettings.getResponseForCommand("processed").iterator();
                        while (iterator.hasNext() && !found) {
                            String value = iterator.next().toLowerCase(Locale.ENGLISH);
                            boolean bl = found = found || title.indexOf(value) != -1;
                        }
                        if (!taskData.isNew() && found) {
                            existingBugPosted = true;
                            break;
                        }
                        if (!taskData.isNew() || prefix == null || prefix2 == null || postfix == null || postfix2 == null) break;
                        int startIndex = -1;
                        int startIndexPrefix = title.toLowerCase(Locale.ENGLISH).indexOf(prefix.toLowerCase(Locale.ENGLISH));
                        int startIndexPrefix2 = title.toLowerCase(Locale.ENGLISH).indexOf(prefix2.toLowerCase(Locale.ENGLISH));
                        if (startIndexPrefix == -1 && startIndexPrefix2 == -1) break;
                        startIndex = startIndexPrefix != -1 ? startIndexPrefix + prefix.length() : startIndexPrefix2 + prefix2.length();
                        int stopIndex = title.toLowerCase(Locale.ENGLISH).indexOf(postfix.toLowerCase(Locale.ENGLISH), startIndex);
                        if (stopIndex == -1) {
                            stopIndex = title.toLowerCase(Locale.ENGLISH).indexOf(postfix2.toLowerCase(Locale.ENGLISH), startIndex);
                        }
                        if (stopIndex <= -1) break;
                        result = title.substring(startIndex, stopIndex).trim();
                        break;
                    }
                }
                token = tokenizer.nextToken();
            }
            if (!taskData.isNew() && !existingBugPosted || taskData.isNew() && result == null) {
                try {
                    if (in.markSupported()) {
                        in.reset();
                    }
                }
                catch (IOException iOException) {}
                this.parseHtmlError(in);
            }
            if (taskData.isNew()) {
                RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, result);
                return repositoryResponse;
            }
            RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskData.getTaskId());
            return repositoryResponse;
        }
        catch (ParseException parseException) {
            this.authenticated = false;
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "Unable to parse response from " + this.repositoryUrl.toString() + "."));
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private NameValuePair[] getPairsForNew(TaskData taskData) {
        HashMap<String, NameValuePair> fields = new HashMap<String, NameValuePair>();
        ArrayList attributes = new ArrayList(taskData.getRoot().getAttributes().values());
        for (TaskAttribute a : attributes) {
            if (a == null || a.getId() == null || a.getId().compareTo("") == 0) continue;
            String value = null;
            value = a.getValue();
            if (value == null) continue;
            if (a.getId().equals(BugzillaAttribute.NEWCC.getKey())) {
                TaskAttribute b = taskData.getRoot().createAttribute(BugzillaAttribute.CC.getKey());
                b.getMetaData().defaults().setReadOnly(BugzillaAttribute.CC.isReadOnly()).setKind(BugzillaAttribute.CC.getKind()).setLabel(BugzillaAttribute.CC.toString()).setType(BugzillaAttribute.CC.getType());
                for (String val : a.getValues()) {
                    if (val == null) continue;
                    b.addValue(val);
                }
                a = b;
                this.cleanIfShortLogin(a);
            } else {
                this.cleanQAContact(a);
            }
            fields.put(a.getId(), new NameValuePair(a.getId(), value));
        }
        TaskAttribute descAttribute = taskData.getRoot().getMappedAttribute("task.common.description");
        if (descAttribute != null && !descAttribute.getValue().equals("")) {
            String bugzillaVersion = null;
            bugzillaVersion = this.repositoryConfiguration != null ? this.repositoryConfiguration.getInstallVersion() : "2.18";
            if (bugzillaVersion.startsWith("2.18")) {
                fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, BugzillaClient.formatTextToLineWrap(descAttribute.getValue(), true)));
            } else {
                fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, descAttribute.getValue()));
            }
        }
        return fields.values().toArray(new NameValuePair[fields.size()]);
    }

    private void cleanQAContact(TaskAttribute a) {
        if (a.getId().equals(BugzillaAttribute.QA_CONTACT.getKey())) {
            this.cleanIfShortLogin(a);
        }
    }

    private void cleanIfShortLogin(TaskAttribute a) {
        int atIndex;
        if (VAL_TRUE.equals(this.configParameters.get("bugzilla.shortLoginEnabled")) && a.getValue() != null && a.getValue().length() > 0 && (atIndex = a.getValue().indexOf("@")) != -1) {
            String newValue = a.getValue().substring(0, atIndex);
            a.setValue(newValue);
        }
    }

    private NameValuePair[] getPairsForExisting(TaskData model, IProgressMonitor monitor) throws CoreException {
        List removeCC;
        TaskAttribute attributeRemoveCC;
        String bugzillaVersion;
        boolean groupSecurityEnabled = false;
        HashMap<String, NameValuePair> fields = new HashMap<String, NameValuePair>();
        fields.put(KEY_FORM_NAME, new NameValuePair(KEY_FORM_NAME, VAL_PROCESS_BUG));
        Collection attributes = model.getRoot().getAttributes().values();
        for (TaskAttribute a : attributes) {
            if (a == null) continue;
            if (a.getId().equals(BugzillaAttribute.QA_CONTACT.getKey()) || a.getId().equals(BugzillaAttribute.ASSIGNED_TO.getKey())) {
                this.cleanIfShortLogin(a);
            } else if (a.getId().equals(BugzillaAttribute.REPORTER.getKey()) || a.getId().equals(BugzillaAttribute.CC.getKey()) || a.getId().equals(BugzillaAttribute.REMOVECC.getKey()) || a.getId().equals(BugzillaAttribute.CREATION_TS.getKey()) || a.getId().equals(BugzillaAttribute.BUG_STATUS.getKey())) continue;
            if (a.getId().equals(BugzillaAttribute.NEW_COMMENT.getKey())) {
                bugzillaVersion = null;
                bugzillaVersion = this.repositoryConfiguration != null ? this.repositoryConfiguration.getInstallVersion() : "2.18";
                if (bugzillaVersion.startsWith("2.18")) {
                    a.setValue(BugzillaClient.formatTextToLineWrap(a.getValue(), true));
                }
            }
            if (a.getId().equals(BugzillaAttribute.GROUP.getKey()) && a.getValue().length() > 0) {
                groupSecurityEnabled = true;
            }
            if (a.getId() == null || a.getId().compareTo("") == 0) continue;
            String value = a.getValue();
            if (a.getId().equals(BugzillaAttribute.DELTA_TS.getKey())) {
                value = BugzillaClient.stripTimeZone(value);
            }
            fields.put(a.getId(), new NameValuePair(a.getId(), value != null ? value : ""));
        }
        TaskAttribute attributeBugId = model.getRoot().getAttribute(BugzillaAttribute.BUG_ID.getKey());
        if (attributeBugId != null) {
            fields.put(KEY_ID, new NameValuePair(KEY_ID, attributeBugId.getValue()));
        }
        bugzillaVersion = null;
        bugzillaVersion = this.repositoryConfiguration != null ? this.repositoryConfiguration.getInstallVersion() : "2.18";
        if (bugzillaVersion.compareTo("3.2") < 0) {
            TaskAttribute attributeOperation = model.getRoot().getMappedAttribute("task.common.operation");
            if (attributeOperation == null) {
                fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, VAL_NONE));
            } else {
                TaskAttribute originalOperation = model.getRoot().getAttribute("task.common.operation-" + attributeOperation.getValue());
                if (originalOperation == null) {
                    fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, VAL_NONE));
                } else {
                    String inputAttributeId = originalOperation.getMetaData().getValue("task.meta.associated.attribute");
                    if (originalOperation == null) {
                        fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, VAL_NONE));
                    } else if (inputAttributeId == null || inputAttributeId.equals("")) {
                        String sel = attributeOperation.getValue();
                        fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, sel));
                    } else {
                        fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, attributeOperation.getValue()));
                        TaskAttribute inputAttribute = attributeOperation.getTaskData().getRoot().getAttribute(inputAttributeId);
                        if (inputAttribute != null) {
                            String knob;
                            String sel;
                            if (inputAttribute.getOptions().size() > 0) {
                                sel = inputAttribute.getValue();
                                knob = inputAttribute.getId();
                                if (knob.equals(BugzillaOperation.resolve.getInputId())) {
                                    knob = BugzillaAttribute.RESOLUTION.getKey();
                                }
                                fields.put(knob, new NameValuePair(knob, inputAttribute.getOption(sel)));
                            } else {
                                sel = inputAttribute.getValue();
                                knob = attributeOperation.getValue();
                                if (knob.equals(BugzillaOperation.reassign.toString())) {
                                    knob = BugzillaAttribute.ASSIGNED_TO.getKey();
                                }
                                fields.put(knob, new NameValuePair(knob, sel));
                            }
                        }
                    }
                }
                if (model.getRoot().getMappedAttribute("task.common.comment.new") != null && model.getRoot().getMappedAttribute("task.common.comment.new").getValue().length() > 0) {
                    fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, model.getRoot().getMappedAttribute("task.common.comment.new").getValue()));
                } else if (attributeOperation != null && attributeOperation.getValue().equals(BugzillaOperation.duplicate.toString())) {
                    fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, ""));
                }
            }
        } else {
            String fieldName = BugzillaAttribute.BUG_STATUS.getKey();
            TaskAttribute attributeStatus = model.getRoot().getMappedAttribute("task.common.status");
            TaskAttribute attributeOperation = model.getRoot().getMappedAttribute("task.common.operation");
            if (attributeOperation == null) {
                fields.put(fieldName, new NameValuePair(fieldName, attributeStatus.getValue()));
            } else {
                TaskAttribute originalOperation = model.getRoot().getAttribute("task.common.operation-" + attributeOperation.getValue());
                if (originalOperation == null) {
                    fields.put(fieldName, new NameValuePair(fieldName, attributeStatus.getValue()));
                } else {
                    String inputAttributeId = originalOperation.getMetaData().getValue("task.meta.associated.attribute");
                    if (originalOperation == null) {
                        fields.put(fieldName, new NameValuePair(fieldName, attributeStatus.getValue()));
                    } else {
                        TaskAttribute inputAttribute;
                        String selOp = attributeOperation.getValue().toUpperCase();
                        if (selOp.equals("NONE")) {
                            selOp = attributeStatus.getValue();
                        }
                        if (selOp.equals("ACCEPT")) {
                            selOp = "ASSIGNED";
                        }
                        if (selOp.equals("RESOLVE")) {
                            selOp = "RESOLVED";
                        }
                        if (selOp.equals("VERIFY")) {
                            selOp = "VERIFIED";
                        }
                        if (selOp.equals("CLOSE")) {
                            selOp = "CLOSED";
                        }
                        if (selOp.equals("REOPEN")) {
                            selOp = "REOPENED";
                        }
                        if (selOp.equals("DUPLICATE")) {
                            selOp = "RESOLVED";
                            String knob = BugzillaAttribute.RESOLUTION.getKey();
                            fields.put(knob, new NameValuePair(knob, "DUPLICATE"));
                        }
                        fields.put(fieldName, new NameValuePair(fieldName, selOp));
                        if (inputAttributeId != null && !inputAttributeId.equals("") && (inputAttribute = attributeOperation.getTaskData().getRoot().getAttribute(inputAttributeId)) != null) {
                            String knob;
                            String sel;
                            if (inputAttribute.getOptions().size() > 0) {
                                sel = inputAttribute.getValue();
                                knob = inputAttribute.getId();
                                if (knob.equals(BugzillaOperation.resolve.getInputId())) {
                                    knob = BugzillaAttribute.RESOLUTION.getKey();
                                }
                                fields.put(knob, new NameValuePair(knob, inputAttribute.getOption(sel)));
                            } else {
                                sel = inputAttribute.getValue();
                                knob = attributeOperation.getValue();
                                if (knob.equals("duplicate")) {
                                    knob = inputAttributeId;
                                }
                                if (knob.equals(BugzillaOperation.reassign.toString())) {
                                    knob = BugzillaAttribute.ASSIGNED_TO.getKey();
                                }
                                fields.put(knob, new NameValuePair(knob, sel));
                            }
                        }
                    }
                }
            }
            if (model.getRoot().getMappedAttribute("task.common.comment.new") != null && model.getRoot().getMappedAttribute("task.common.comment.new").getValue().length() > 0) {
                fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, model.getRoot().getMappedAttribute("task.common.comment.new").getValue()));
            }
        }
        if (model.getRoot().getMappedAttribute(BugzillaAttribute.SHORT_DESC.getKey()) != null) {
            fields.put(KEY_SHORT_DESC, new NameValuePair(KEY_SHORT_DESC, model.getRoot().getMappedAttribute(BugzillaAttribute.SHORT_DESC.getKey()).getValue()));
        }
        if ((attributeRemoveCC = model.getRoot().getMappedAttribute(BugzillaAttribute.REMOVECC.getKey())) != null && (removeCC = attributeRemoveCC.getValues()) != null && removeCC.size() > 0) {
            String[] s = new String[removeCC.size()];
            fields.put(KEY_CC, new NameValuePair(KEY_CC, BugzillaClient.toCommaSeparatedList(removeCC.toArray(s))));
            fields.put(BugzillaAttribute.REMOVECC.getKey(), new NameValuePair(BugzillaAttribute.REMOVECC.getKey(), VAL_TRUE));
        }
        if (groupSecurityEnabled) {
            Map<String, String> groupIds = this.getGroupSecurityInformation(model, monitor);
            for (String key : groupIds.keySet()) {
                fields.put(key, new NameValuePair(key, groupIds.get(key)));
            }
        }
        return fields.values().toArray(new NameValuePair[fields.size()]);
    }

    private Map<String, String> getGroupSecurityInformation(TaskData taskData, IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> groupSecurityInformation = new HashMap<String, String>();
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        String bugUrl = String.valueOf(taskData.getRepositoryUrl()) + "/show_bug.cgi?id=" + taskData.getTaskId();
        GzipGetMethod getMethod = new GzipGetMethod(WebUtil.getRequestPath((String)bugUrl), false);
        getMethod.setRequestHeader("Content-Type", "text/xml; charset=" + this.characterEncoding);
        this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        getMethod.setDoAuthentication(true);
        InputStream inStream = null;
        try {
            try {
                int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)getMethod, (IProgressMonitor)monitor);
                if (code == 200) {
                    inStream = this.getResponseStream((HttpMethodBase)getMethod, monitor);
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)new BufferedReader(new InputStreamReader(inStream, this.characterEncoding)), null);
                    HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                    while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                        if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.INPUT && !((HtmlTag)token.getValue()).isEndTag()) {
                            HtmlTag tag = (HtmlTag)token.getValue();
                            String id = tag.getAttribute(KEY_ID);
                            String checkedValue = tag.getAttribute("checked");
                            String type = tag.getAttribute("type");
                            if (type != null && type.equalsIgnoreCase("checkbox") && id != null && id.startsWith("bit-")) {
                                groupSecurityInformation.put(id, checkedValue);
                            }
                        }
                        token = tokenizer.nextToken();
                    }
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to retrieve group security information", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
        return groupSecurityInformation;
    }

    public static String stripTimeZone(String longTime) {
        String[] values;
        String result = longTime;
        if (longTime != null && (values = longTime.split(" ")) != null && values.length > 2) {
            result = String.valueOf(values[0]) + " " + values[1];
        }
        return result;
    }

    private static String toCommaSeparatedList(String[] strings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buffer.append(strings[i]);
            if (i != strings.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private void parseHtmlError(InputStream inputStream) throws IOException, CoreException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, this.characterEncoding));
        this.parseHtmlError(in);
    }

    /*
     * Exception decompiling
     */
    private void parseHtmlError(BufferedReader in) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public TaskHistory getHistory(String taskId, IProgressMonitor monitor) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void getTaskData(Set<String> taskIds, final TaskDataCollector collector, TaskAttributeMapper mapper, final IProgressMonitor monitor) throws IOException, CoreException {
        GzipPostMethod method = null;
        HashMap<String, TaskData> taskDataMap = new HashMap<String, TaskData>();
        taskIds = new HashSet<String>(taskIds);
        int authenticationAttempt = 0;
        while (taskIds.size() > 0) {
            try {
                HashSet<String> idsToRetrieve = new HashSet<String>();
                Iterator<String> itr = taskIds.iterator();
                int x = 0;
                while (itr.hasNext() && x < 100) {
                    idsToRetrieve.add(itr.next());
                    ++x;
                }
                NameValuePair[] formData = new NameValuePair[idsToRetrieve.size() + 2];
                if (idsToRetrieve.size() == 0) {
                    return;
                }
                itr = idsToRetrieve.iterator();
                int x2 = 0;
                while (itr.hasNext()) {
                    String taskId = itr.next();
                    formData[x2] = new NameValuePair(KEY_ID, taskId);
                    TaskData taskData = new TaskData(mapper, "bugzilla", this.repositoryUrl.toString(), taskId);
                    BugzillaClient.setupExistingBugAttributes(this.repositoryUrl.toString(), taskData);
                    taskDataMap.put(taskId, taskData);
                    ++x2;
                }
                formData[x2++] = new NameValuePair("ctype", "xml");
                formData[x2] = new NameValuePair("excludefield", "attachmentdata");
                method = this.postFormData("/show_bug.cgi", formData, monitor);
                if (method == null) {
                    throw new IOException("Could not post form, client returned null method.");
                }
                boolean parseable = false;
                if (method.getResponseHeader("Content-Type") != null) {
                    Header responseTypeHeader = method.getResponseHeader("Content-Type");
                    String[] stringArray = VALID_CONFIG_CONTENT_TYPES;
                    int n = VALID_CONFIG_CONTENT_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String type = stringArray[n2];
                        if (responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type)) {
                            InputStream input = this.getResponseStream((HttpMethodBase)method, monitor);
                            try {
                                MultiBugReportFactory factory = new MultiBugReportFactory(input, this.characterEncoding);
                                TaskDataCollector collector2 = new TaskDataCollector(){

                                    public void accept(TaskData taskData) {
                                        BugzillaClient.this.getRepositoryConfiguration().configureTaskData(taskData);
                                        collector.accept(taskData);
                                        monitor.worked(1);
                                    }
                                };
                                ArrayList<BugzillaCustomField> customFields = new ArrayList();
                                if (this.repositoryConfiguration != null) {
                                    customFields = this.repositoryConfiguration.getCustomFields();
                                }
                                factory.populateReport(taskDataMap, collector2, mapper, customFields);
                                taskIds.removeAll(idsToRetrieve);
                                parseable = true;
                                break;
                            }
                            finally {
                                input.close();
                            }
                        }
                        ++n2;
                    }
                }
                if (parseable) continue;
                this.parseHtmlError(this.getResponseStream((HttpMethodBase)method, monitor));
                break;
            }
            catch (CoreException c) {
                if (c.getStatus().getCode() == 3 && authenticationAttempt < 1) {
                    this.authenticated = false;
                    ++authenticationAttempt;
                    continue;
                }
                throw c;
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }

    public String getConfigurationTimestamp(IProgressMonitor monitor) throws CoreException {
        if (!this.lastModifiedSupported) {
            return null;
        }
        String lastModified = null;
        HeadMethod method = null;
        try {
            try {
                method = this.connectHead(this.repositoryUrl + "/config.cgi?ctype=rdf", monitor);
                Header lastModifiedHeader = method.getResponseHeader("Last-Modified");
                if (lastModifiedHeader != null && lastModifiedHeader.getValue() != null && lastModifiedHeader.getValue().length() > 0) {
                    lastModified = lastModifiedHeader.getValue();
                } else {
                    this.lastModifiedSupported = false;
                }
            }
            catch (Exception e) {
                this.lastModifiedSupported = false;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error retrieving configuration timestamp", (Throwable)e));
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return lastModified;
    }

    private HeadMethod connectHead(String requestURL, IProgressMonitor monitor) throws IOException, CoreException {
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        int attempt = 0;
        while (attempt < 2) {
            int code;
            if (!this.authenticated && this.hasAuthenticationCredentials()) {
                this.authenticate(monitor);
            }
            HeadMethod headMethod = new HeadMethod(WebUtil.getRequestPath((String)requestURL));
            if (requestURL.contains(QUERY_DELIMITER)) {
                headMethod.setQueryString(requestURL.substring(requestURL.indexOf(QUERY_DELIMITER)));
            }
            headMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
            headMethod.setDoAuthentication(true);
            try {
                code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)headMethod, (IProgressMonitor)monitor);
            }
            catch (IOException e) {
                headMethod.getResponseBody();
                headMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
            if (code == 200) {
                return headMethod;
            }
            if (code != 401 && code != 403) {
                if (code == 407) {
                    this.authenticated = false;
                    headMethod.getResponseBody();
                    headMethod.releaseConnection();
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                }
                headMethod.getResponseBody();
                headMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
            }
            headMethod.getResponseBody();
            headMethod.releaseConnection();
            this.authenticated = false;
            this.authenticate(monitor);
            ++attempt;
        }
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "All connection attempts to " + this.repositoryUrl.toString() + " failed. Please verify connection and authentication information."));
    }

    public void setRepositoryConfiguration(RepositoryConfiguration repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        return this.repositoryConfiguration;
    }

    public void shutdown() {
        ((MultiThreadedHttpConnectionManager)this.httpClient.getHttpConnectionManager()).shutdown();
    }

    public static String formatTextToLineWrap(String origText, boolean hardWrap) {
        if (!hardWrap) {
            return origText;
        }
        String newText = "";
        while (!origText.equals("")) {
            int newLine = origText.indexOf(10);
            if (newLine == -1) {
                if (origText.length() > 80) {
                    int spaceIndex = origText.lastIndexOf(" ", 80);
                    if (spaceIndex == -1) {
                        spaceIndex = 80;
                    }
                    newText = String.valueOf(newText) + origText.substring(0, spaceIndex) + "\n";
                    origText = origText.substring(spaceIndex + 1, origText.length());
                    continue;
                }
                newText = String.valueOf(newText) + origText;
                origText = "";
                continue;
            }
            newText = String.valueOf(newText) + origText.substring(0, newLine + 1);
            origText = origText.substring(newLine + 1, origText.length());
        }
        return newText;
    }
}

