/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.mylyn.internal.provisional.commons.ui.DateSelectionDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DatePicker
extends Composite {
    public static final String TITLE_DIALOG = "Choose Date";
    public static final String LABEL_CHOOSE = "Choose Date";
    private Text dateText = null;
    private Button pickButton = null;
    private Calendar date = null;
    private final List<SelectionListener> pickerListeners = new LinkedList<SelectionListener>();
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
    private String initialText = "Choose Date";
    private final boolean includeTimeOfday;
    private final int hourOfDay = 0;
    private int selectedHourOfDay = 0;

    public DatePicker(Composite parent, int style, String initialText, boolean includeHours, int selectedHourOfDay) {
        super(parent, style);
        this.initialText = initialText;
        this.includeTimeOfday = includeHours;
        this.selectedHourOfDay = selectedHourOfDay;
        this.initialize((style & 0x800000) != 0 ? 0x800000 : 0);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDatePattern(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    private void initialize(int style) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.dateText = new Text((Composite)this, style);
        GridData dateTextGridData = new GridData(4, 4, false, false);
        dateTextGridData.grabExcessHorizontalSpace = true;
        dateTextGridData.verticalAlignment = 4;
        dateTextGridData.verticalIndent = 0;
        this.dateText.setLayoutData((Object)dateTextGridData);
        this.dateText.setText(this.initialText);
        this.dateText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DatePicker.this.notifyPickerListeners();
            }
        });
        this.dateText.addFocusListener((FocusListener)new FocusAdapter(){
            Calendar calendar = Calendar.getInstance();

            public void focusLost(FocusEvent e) {
                try {
                    Date reminderDate = DatePicker.this.dateFormat.parse(DatePicker.this.dateText.getText());
                    this.calendar.setTime(reminderDate);
                    DatePicker.this.date = this.calendar;
                    DatePicker.this.updateDateText();
                }
                catch (ParseException parseException) {
                    DatePicker.this.updateDateText();
                }
            }
        });
        this.pickButton = new Button((Composite)this, style | 4 | 0x400);
        GridData pickButtonGridData = new GridData(131072, 4, false, true);
        pickButtonGridData.verticalIndent = 0;
        this.pickButton.setLayoutData((Object)pickButtonGridData);
        this.pickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Calendar newCalendar = Calendar.getInstance();
                newCalendar.set(11, 0);
                newCalendar.set(12, 0);
                newCalendar.set(13, 0);
                newCalendar.set(14, 0);
                if (DatePicker.this.date != null) {
                    newCalendar.setTime(DatePicker.this.date.getTime());
                }
                Shell shell = null;
                shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(PlatformUI.getWorkbench().getDisplay());
                DateSelectionDialog dialog = new DateSelectionDialog(shell, newCalendar, "Choose Date", DatePicker.this.includeTimeOfday, DatePicker.this.selectedHourOfDay);
                DatePicker.this.pickButton.setEnabled(false);
                DatePicker.this.dateText.setEnabled(false);
                int dialogResponse = dialog.open();
                if (dialog.getDate() != null) {
                    newCalendar.setTime(dialog.getDate());
                } else {
                    newCalendar = null;
                }
                DatePicker.this.dateSelected(dialogResponse == 1, newCalendar);
            }
        });
        this.pack();
    }

    public void addPickerSelectionListener(SelectionListener listener) {
        this.pickerListeners.add(listener);
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setBackground(Color backgroundColor) {
        this.dateText.setBackground(backgroundColor);
        super.setBackground(backgroundColor);
    }

    public void setDate(Calendar date) {
        this.date = date;
        this.updateDateText();
    }

    protected void dateSelected(boolean canceled, Calendar selectedDate) {
        if (!canceled) {
            this.date = selectedDate != null ? selectedDate : null;
            this.updateDateText();
            this.notifyPickerListeners();
        }
        this.pickButton.setEnabled(true);
        this.dateText.setEnabled(true);
    }

    private void notifyPickerListeners() {
        for (SelectionListener listener : this.pickerListeners) {
            listener.widgetSelected(null);
        }
    }

    private void updateDateText() {
        if (this.date != null) {
            Date currentDate = new Date(this.date.getTimeInMillis());
            this.dateText.setText(this.dateFormat.format(currentDate));
        } else {
            this.dateText.setEnabled(false);
            this.dateText.setText("Choose Date");
            this.dateText.setEnabled(true);
        }
    }

    public void setEnabled(boolean enabled) {
        this.dateText.setEnabled(enabled);
        this.pickButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

