/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.editors;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.actions.ContextAttachAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextClearAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextCopyAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextRetrieveAction;
import org.eclipse.mylyn.internal.context.ui.editors.ScalableInterestFilter;
import org.eclipse.mylyn.internal.context.ui.views.ContextNodeOpenListener;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.DelayedRefreshJob;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextEditorFormPage
extends FormPage {
    private static final int SCALE_STEPS = 14;
    public static final String ID_VIEWER = "org.eclipse.mylyn.context.ui.navigator.context";
    private ScrolledForm form;
    private FormToolkit toolkit;
    private CommonViewer commonViewer;
    private final ScalableInterestFilter interestFilter = new ScalableInterestFilter();
    private Scale doiScale;
    private ITask task;
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextActivated(IInteractionContext context) {
            ContextEditorFormPage.this.refresh();
        }

        public void contextDeactivated(IInteractionContext context) {
            ContextEditorFormPage.this.refresh();
        }

        public void contextCleared(IInteractionContext context) {
            ContextEditorFormPage.this.refresh();
        }

        public void elementsDeleted(List<IInteractionElement> element) {
            ContextEditorFormPage.this.refresh(element);
        }

        public void interestChanged(List<IInteractionElement> elements) {
            ContextEditorFormPage.this.refresh(elements);
        }

        public void landmarkAdded(IInteractionElement element) {
            ContextEditorFormPage.this.refresh(Arrays.asList(element));
        }

        public void landmarkRemoved(IInteractionElement element) {
            ContextEditorFormPage.this.refresh(Arrays.asList(element));
        }
    };
    private ContextEditorDelayedRefreshJob refreshJob;

    public ContextEditorFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ContextCore.getContextManager().addListener(this.CONTEXT_LISTENER);
        this.task = ((TaskEditorInput)this.getEditorInput()).getTask();
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.form.getBody().setLayout((Layout)new GridLayout(2, false));
        this.createActionsSection(this.form.getBody());
        this.createDisplaySection(this.form.getBody());
        this.form.reflow(true);
    }

    public void dispose() {
        super.dispose();
        ContextCore.getContextManager().removeListener(this.CONTEXT_LISTENER);
    }

    private void createActionsSection(Composite composite) {
        Section section = this.toolkit.createSection(composite, 258);
        section.setText("Actions");
        section.setLayout((Layout)new GridLayout());
        GridData sectionGridData = new GridData(2);
        sectionGridData.widthHint = 80;
        section.setLayoutData((Object)sectionGridData);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        sectionClient.setLayoutData((Object)new GridData());
        Label label = this.toolkit.createLabel(sectionClient, "");
        label.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FILTER));
        this.doiScale = new Scale(sectionClient, 0x800000);
        GridData scaleGridData = new GridData(768);
        scaleGridData.heightHint = 36;
        scaleGridData.widthHint = 80;
        this.doiScale.setLayoutData((Object)scaleGridData);
        this.doiScale.setPageIncrement(1);
        this.doiScale.setMinimum(0);
        this.doiScale.setSelection(7);
        this.doiScale.setMaximum(14);
        this.doiScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextEditorFormPage.this.setFilterThreshold();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!this.task.equals(TasksUi.getTaskActivityManager().getActiveTask())) {
            this.doiScale.setEnabled(false);
        }
        Label attachImage = this.toolkit.createLabel(sectionClient, "");
        attachImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ATTACH));
        attachImage.setEnabled(this.task != null);
        Hyperlink attachHyperlink = this.toolkit.createHyperlink(sectionClient, "Attach context...", 0);
        attachHyperlink.setEnabled(this.task != null);
        attachHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextAttachAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label retrieveImage = this.toolkit.createLabel(sectionClient, "");
        retrieveImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_RETRIEVE));
        retrieveImage.setEnabled(this.task != null);
        Hyperlink retrieveHyperlink = this.toolkit.createHyperlink(sectionClient, "Retrieve Context...", 0);
        retrieveHyperlink.setEnabled(this.task != null);
        retrieveHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextRetrieveAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label copyImage = this.toolkit.createLabel(sectionClient, "");
        copyImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_COPY));
        Hyperlink copyHyperlink = this.toolkit.createHyperlink(sectionClient, "Copy Context to...", 0);
        copyHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextCopyAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label clearImage = this.toolkit.createLabel(sectionClient, "");
        clearImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_CLEAR));
        Hyperlink clearHyperlink = this.toolkit.createHyperlink(sectionClient, "Clear Context", 0);
        clearHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextClearAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        section.setExpanded(true);
    }

    protected void setFilterThreshold() {
        double setting = this.doiScale.getSelection() - 7;
        double threshold = Math.signum(setting) * Math.pow(Math.exp(Math.abs(setting)), 1.5);
        this.interestFilter.setThreshold(threshold);
        this.refresh();
    }

    private void refresh() {
        this.createRefreshJob();
        if (this.refreshJob != null) {
            this.refreshJob.refresh();
        }
    }

    private synchronized void createRefreshJob() {
        if (this.commonViewer == null) {
            return;
        }
        if (this.refreshJob == null) {
            this.refreshJob = new ContextEditorDelayedRefreshJob((StructuredViewer)this.commonViewer, "refresh viewer");
        }
    }

    private void refresh(List<IInteractionElement> elements) {
        this.createRefreshJob();
        if (this.refreshJob != null) {
            this.refreshJob.doRefresh(elements.toArray());
        }
    }

    private void createDisplaySection(Composite composite) {
        Section section = this.toolkit.createSection(composite, 258);
        section.setText("Elements");
        section.setLayoutData((Object)new GridData(1808));
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        if (this.task.equals(TasksUi.getTaskActivityManager().getActiveTask())) {
            sectionClient.setLayout(new Layout(){

                protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                    return new Point(0, 0);
                }

                protected void layout(Composite composite, boolean flushCache) {
                    Rectangle clientArea = composite.getClientArea();
                    ContextEditorFormPage.this.commonViewer.getControl().setBounds(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                }
            });
            this.createViewer(sectionClient);
        } else {
            sectionClient.setLayout((Layout)new GridLayout());
            Hyperlink retrieveHyperlink = this.toolkit.createHyperlink(sectionClient, "Activate task to edit context", 0);
            retrieveHyperlink.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    new TaskActivateAction().run(ContextEditorFormPage.this.task);
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }
            });
        }
        section.setExpanded(true);
    }

    private void createViewer(Composite aParent) {
        this.commonViewer = this.createCommonViewer(aParent);
        this.commonViewer.addFilter((ViewerFilter)this.interestFilter);
        this.commonViewer.addOpenListener((IOpenListener)new ContextNodeOpenListener((Viewer)this.commonViewer));
        try {
            this.commonViewer.getControl().setRedraw(false);
            ContextEditorFormPage.forceFlatLayoutOfJavaContent(this.commonViewer);
            this.commonViewer.setInput((Object)this.getSite().getPage().getInput());
            this.getSite().setSelectionProvider((ISelectionProvider)this.commonViewer);
            this.hookContextMenu();
            this.commonViewer.expandAll();
        }
        finally {
            this.commonViewer.getControl().setRedraw(true);
        }
    }

    public static void forceFlatLayoutOfJavaContent(CommonViewer commonViewer) {
        INavigatorContentExtension javaContent = commonViewer.getNavigatorContentService().getContentExtensionById("org.eclipse.jdt.java.ui.javaContent");
        if (javaContent != null) {
            ITreeContentProvider treeContentProvider = javaContent.getContentProvider();
            try {
                Class<?> clazz = treeContentProvider.getClass().getSuperclass();
                Method method = clazz.getDeclaredMethod("setIsFlatLayout", Boolean.TYPE);
                method.invoke((Object)treeContentProvider, true);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not set flat layout on Java content provider", (Throwable)e));
            }
        }
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = new CommonViewer(ID_VIEWER, parent, 770);
        viewer.setUseHashlookup(true);
        return viewer;
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextEditorFormPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.commonViewer.getControl());
        this.commonViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.commonViewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public ISelection getSelection() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    private class ContextEditorDelayedRefreshJob
    extends DelayedRefreshJob {
        public ContextEditorDelayedRefreshJob(StructuredViewer treeViewer, String name) {
            super(treeViewer, name);
        }

        protected void doRefresh(Object[] items) {
            if (ContextEditorFormPage.this.commonViewer != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                ContextEditorFormPage.this.commonViewer.refresh();
                if (items != null) {
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        this.updateExpansionState(item);
                        ++n2;
                    }
                } else {
                    this.updateExpansionState(null);
                }
            }
        }

        protected void updateExpansionState(Object item) {
            if (ContextEditorFormPage.this.commonViewer != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                try {
                    ContextEditorFormPage.this.commonViewer.getTree().setRedraw(false);
                    if (item == null) {
                        ContextEditorFormPage.this.commonViewer.expandAll();
                    } else if (item != null && item instanceof IInteractionElement) {
                        IInteractionElement node = (IInteractionElement)item;
                        AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                        Object objectToRefresh = structureBridge.getObjectForHandle(node.getHandleIdentifier());
                        if (objectToRefresh != null) {
                            ContextEditorFormPage.this.commonViewer.expandToLevel(objectToRefresh, -1);
                        }
                    }
                }
                finally {
                    ContextEditorFormPage.this.commonViewer.getTree().setRedraw(true);
                }
            }
        }
    }
}

